/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.InspectorCell;
import com.adobe.acrobat.debug.PDFObjStoreInspectorBrowser;
import com.adobe.acrobat.debug.PDFObjStoreInspectorChain;
import com.adobe.acrobat.debug.VPDFObjStoreInspectorChain;
import com.adobe.acrobat.debug.VResolvedChain;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFContainer;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.StrobeUtils;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VInt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class BrowserColumn
extends Panel
implements VObserver,
MouseListener,
StrobeContainer {
    static final int kCellHeight = 15;
    private PDFObjStoreInspectorBrowser browser;
    VResolvedChain vChain;
    private VPDFObjStoreInspectorChain vInChain;
    int column;
    private VStrobe strobe;
    int numRows;
    VInt vHeight;

    BrowserColumn(PDFObjStoreInspectorBrowser pDFObjStoreInspectorBrowser, int n) throws Exception {
        this.browser = pDFObjStoreInspectorBrowser;
        this.vChain = pDFObjStoreInspectorBrowser.vChain;
        this.vInChain = pDFObjStoreInspectorBrowser.vInChain;
        this.column = n;
        this.vHeight = new VBrowserColumnHeight(this);
        this.setLayout(new BrowserColumnLayout());
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            try {
                Object object;
                int n = 0;
                while (n < this.getComponentCount()) {
                    object = this.getComponent(n);
                    StrobeUtils.setAllStrobesActive(this.strobe.getLastOwnerTransaction(), (Component)object, false);
                    ((Component)object).removeMouseListener(this);
                    ++n;
                }
                this.removeAll();
                if (this.column >= this.vChain.getNumContainers(requester)) {
                    Object var3_6 = null;
                    this.invalidate();
                    this.validate();
                    return;
                }
                object = this.vChain.nthContainer(this.column, requester);
                int n2 = ((PDFObj)object).type(requester);
                Object object2 = this.vChain.nthSelectedKey(this.column, requester);
                if (n2 == 6) {
                    PDFDict pDFDict = ((PDFObj)object).dictValue(requester);
                    this.numRows = pDFDict.size();
                    int n3 = 0;
                    while (n3 < pDFDict.size()) {
                        String string = pDFDict.nthKey(n3);
                        PDFObj pDFObj = pDFDict.nthValue(n3);
                        InspectorCell inspectorCell = new InspectorCell(n3, string, pDFObj);
                        this.add(inspectorCell);
                        if (object2 != null && string.equals(object2)) {
                            inspectorCell.setSelected(true);
                        }
                        inspectorCell.addMouseListener(this);
                        StrobeUtils.setAllStrobesActive(this.strobe.getLastOwnerTransaction(), inspectorCell, true);
                        ++n3;
                    }
                } else if (n2 == 7) {
                    PDFArray pDFArray = ((PDFObj)object).arrayValue(requester);
                    this.numRows = pDFArray.size();
                    int n4 = 0;
                    while (n4 < pDFArray.size()) {
                        PDFObj pDFObj = pDFArray.get(n4);
                        InspectorCell inspectorCell = new InspectorCell(n4, String.valueOf(n4), pDFObj);
                        this.add(inspectorCell);
                        if (object2 != null && object2 instanceof Integer && (Integer)object2 == n4) {
                            inspectorCell.setSelected(true);
                        }
                        inspectorCell.addMouseListener(this);
                        StrobeUtils.setAllStrobesActive(this.strobe.getLastOwnerTransaction(), inspectorCell, true);
                        ++n4;
                    }
                }
            }
            catch (WriteLockException writeLockException) {
                throw writeLockException;
            }
            catch (Exception exception) {
                Log.clog("BrowserColumn.change: " + exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.invalidate();
            this.validate();
            throw throwable;
        }
        Object var3_7 = null;
        this.invalidate();
        this.validate();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            final InspectorCell inspectorCell = (InspectorCell)mouseEvent.getComponent();
            Transactor transactor = new Transactor(){

                public void buildChanges(Transaction transaction) throws Exception {
                    int n = inspectorCell.index;
                    PDFObj pDFObj = inspectorCell.obj;
                    PDFContainer pDFContainer = vChain.nthContainer(column, transaction);
                    int n2 = pDFContainer.type(transaction);
                    PDFObjStoreInspectorChain pDFObjStoreInspectorChain = vInChain.peObjStoreInspectorChainValue(transaction);
                    if (n2 == 6) {
                        PDFDict pDFDict = pDFContainer.dictValue(transaction);
                        pDFObjStoreInspectorChain = new PDFObjStoreInspectorChain(pDFObjStoreInspectorChain, column, pDFDict.nthKey(n));
                    } else if (n2 == 7) {
                        PDFArray pDFArray = pDFContainer.arrayValue(transaction);
                        pDFObjStoreInspectorChain = new PDFObjStoreInspectorChain(pDFObjStoreInspectorChain, column, new Integer(n));
                    }
                    vInChain.setPDFObjStoreInspectorChainValue(transaction, pDFObjStoreInspectorChain);
                    if (((BrowserColumn)this).browser.hScrollValue != null) {
                        ((BrowserColumn)this).browser.hScrollValue.setIntValue(transaction, Integer.MAX_VALUE);
                    }
                }
            };
            transactor.commit();
        }
        catch (Exception exception) {
            Log.clog("BrowserColumn.mousePressed: " + exception.toString());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    class BrowserColumnLayout
    implements LayoutManager {
        BrowserColumnLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n = BrowserColumn.this.getSize().width;
            int n2 = 0;
            while (n2 < BrowserColumn.this.getComponentCount()) {
                Component component = BrowserColumn.this.getComponent(n2);
                component.setBounds(0, n2 * 15, n, 15);
                ++n2;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, BrowserColumn.this.numRows * 15);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    class VBrowserColumnHeight
    extends VInt {
        private BrowserColumn col;

        VBrowserColumnHeight(BrowserColumn browserColumn2) {
            this.col = browserColumn2;
        }

        public final int computeInt(Requester requester) throws Exception {
            if (BrowserColumn.this.column < this.col.vChain.getNumContainers(requester)) {
                PDFContainer pDFContainer = this.col.vChain.nthContainer(this.col.column, requester);
                int n = pDFContainer.type(requester);
                if (n == 6) {
                    return pDFContainer.dictValue(requester).size() * 15;
                }
                if (n == 7) {
                    return pDFContainer.arrayValue(requester).size() * 15;
                }
            }
            return 0;
        }
    }
}

