/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import netscape.security.PrivilegeManager;

class RandomAccessFileStream
extends InputStream {
    private RandomAccessFile rf;
    private long markPos;
    private long ptr;

    public RandomAccessFileStream(RandomAccessFile randomAccessFile, int n) {
        this.rf = randomAccessFile;
        this.ptr = n;
    }

    public void mark(int n) {
        this.markPos = this.ptr;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            RandomAccessFile randomAccessFile = this.rf;
            synchronized (randomAccessFile) {
                this.rf.seek(this.ptr);
                int n = this.rf.read();
                if (n != -1) {
                    ++this.ptr;
                }
                int n2 = n;
                Object var4_6 = null;
                return n2;
            }
        }
        catch (Exception exception) {
            Log.clog("FileByteArraySourceSpace.read()" + exception);
            return -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            RandomAccessFile randomAccessFile = this.rf;
            synchronized (randomAccessFile) {
                this.rf.seek(this.ptr);
                int n3 = this.rf.read(byArray, n, n2);
                if (n3 != -1) {
                    this.ptr += (long)n3;
                }
                int n4 = n3;
                Object var7_9 = null;
                return n4;
            }
        }
        catch (Exception exception) {
            Log.clog("FileByteArraySourceSpace.read(...)" + exception);
            return -1;
        }
    }

    public void reset() throws IOException {
        this.ptr = this.markPos;
    }

    public long skip(long l) throws IOException {
        this.ptr += l;
        return l;
    }
}

