/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.filters;

import com.adobe.acrobat.filters.FilterParams;
import com.adobe.acrobat.filters.TIFFInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class TIFFEngine {
    private boolean encode;
    private TIFFInputStream rdr;
    private OutputStream wtr;
    private boolean init;
    private long totalOut;
    private boolean eofRead;
    private int predictor;
    private int samplesPerRow;
    private int componentsPerSample;
    private int componentsPerRow;
    private int bitsPerComponent;
    private int bytesPerSample;
    private int bytesPerRow;
    private int rowPredictor;
    private int nRows;
    private byte[][] row;
    private int[] predictedComponent;
    private int curSample;
    private int curComponent;

    public TIFFEngine(InputStream inputStream) {
        this(inputStream, null);
    }

    public TIFFEngine(InputStream inputStream, FilterParams filterParams) {
        this(false);
        this.rdr = (TIFFInputStream)inputStream;
        this.engineInit(filterParams);
    }

    public TIFFEngine(OutputStream outputStream) {
        this(outputStream, null);
    }

    public TIFFEngine(OutputStream outputStream, FilterParams filterParams) {
        this(true);
        this.wtr = outputStream;
        this.engineInit(filterParams);
    }

    private TIFFEngine(boolean bl) {
        this.encode = bl;
        this.init = false;
        this.predictor = 1;
        this.samplesPerRow = 1;
        this.componentsPerSample = 1;
        this.bitsPerComponent = 8;
    }

    public int TIFFPredict(int n) throws IOException {
        int n2;
        if (!this.init) {
            this.TIFFPredictInit();
        }
        if (n < 0) {
            this.eofRead = true;
        }
        if (this.eofRead) {
            return -1;
        }
        block0 : switch (this.predictor) {
            case 1: {
                n2 = n & 0xFF;
                break;
            }
            case 2: {
                if (this.bitsPerComponent == 8) {
                    int n3;
                    if (this.encode) {
                        n3 = n & 0xFF;
                        n2 = n3 - this.predictedComponent[this.curComponent] & 0xFF;
                        this.predictedComponent[this.curComponent] = n3;
                    } else {
                        this.predictedComponent[this.curComponent] = n2 = n + this.predictedComponent[this.curComponent] & 0xFF;
                    }
                    if (++this.curComponent != this.componentsPerSample) break;
                    this.curComponent = 0;
                    if (++this.curSample != this.samplesPerRow) break;
                    this.curSample = 0;
                    n3 = 0;
                    while (n3 < this.componentsPerSample) {
                        this.predictedComponent[n3] = 0;
                        ++n3;
                    }
                    break;
                }
                int n4 = (1 << this.bitsPerComponent) - 1;
                int n5 = 8 - this.bitsPerComponent;
                int n6 = n4 << n5;
                n2 = 0;
                while (n6 != 0) {
                    int n7;
                    if (this.encode) {
                        n7 = (n & n6) >>> n5;
                        n2 += (n7 - this.predictedComponent[this.curComponent] & n4) << n5;
                        this.predictedComponent[this.curComponent] = n7;
                    } else {
                        n7 = (n & n6) >>> n5;
                        n2 = (n7 + this.predictedComponent[this.curComponent] & n4) << n5;
                        this.predictedComponent[this.curComponent] = n7;
                    }
                    if (++this.curComponent == this.componentsPerSample) {
                        this.curComponent = 0;
                        if (++this.curSample == this.samplesPerRow) {
                            this.curSample = 0;
                            n7 = 0;
                            while (n7 < this.componentsPerSample) {
                                this.predictedComponent[n7] = 0;
                                ++n7;
                            }
                            break block0;
                        }
                    }
                    n6 >>>= this.bitsPerComponent;
                    n5 -= this.bitsPerComponent;
                }
                break;
            }
            default: {
                int n8;
                int n9;
                if (this.rowPredictor == -1) {
                    if (this.encode) {
                        this.rowPredictor = this.predictor < 15 ? this.predictor - 10 : 1;
                        this.put(this.rowPredictor);
                    } else {
                        if (n > 4) {
                            this.eofRead = true;
                            return -1;
                        }
                        this.rowPredictor = n;
                        n = this.rdr.read1();
                        if (n < 0) {
                            this.eofRead = true;
                            return -1;
                        }
                    }
                }
                switch (this.rowPredictor) {
                    default: {
                        n9 = 0;
                        break;
                    }
                    case 1: {
                        n9 = this.row[0][this.curComponent] & 0xFF;
                        break;
                    }
                    case 2: {
                        n9 = this.row[1][this.curComponent + this.bytesPerSample] & 0xFF;
                        break;
                    }
                    case 3: {
                        n9 = (this.row[0][this.curComponent] & 0xFF) + (this.row[1][this.curComponent + this.bytesPerSample] & 0xFF) >> 1;
                        break;
                    }
                    case 4: {
                        int n10 = this.row[0][this.curComponent] & 0xFF;
                        n8 = this.row[1][this.curComponent + this.bytesPerSample] & 0xFF;
                        int n11 = this.row[1][this.curComponent] & 0xFF;
                        int n12 = n10 + n8 - n11;
                        int n13 = Math.abs(n12 - n10);
                        int n14 = Math.abs(n12 - n8);
                        int n15 = Math.abs(n12 - n11);
                        int n16 = n13 <= n14 && n13 <= n15 ? n10 : (n9 = n14 <= n15 ? n8 : n11);
                    }
                }
                if (this.encode) {
                    n2 = n - n9 & 0xFF;
                    this.row[0][this.curComponent + this.bytesPerSample] = (byte)n;
                } else {
                    n2 = n + n9 & 0xFF;
                    this.row[0][this.curComponent + this.bytesPerSample] = (byte)n2;
                }
                if (++this.curComponent != this.componentsPerRow) break;
                byte[] byArray = this.row[this.nRows - 1];
                n8 = this.nRows - 1;
                while (n8 > 0) {
                    this.row[n8] = this.row[n8 - 1];
                    --n8;
                }
                this.row[0] = byArray;
                this.curComponent = 0;
                this.rowPredictor = -1;
            }
        }
        return n2;
    }

    private void TIFFPredictInit() {
        if (this.samplesPerRow < 1 || this.componentsPerSample < 1 || this.bitsPerComponent < 1) {
            this.predictor = 1;
        }
        this.nRows = 0;
        switch (this.predictor) {
            case 2: {
                if (this.bitsPerComponent == 1 || this.bitsPerComponent == 2 || this.bitsPerComponent == 4 || this.bitsPerComponent == 8) break;
                this.predictor = 1;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                if (this.bitsPerComponent != 8) {
                    this.predictor = 1;
                    break;
                }
                this.nRows = 2;
                break;
            }
            default: {
                this.predictor = 1;
            }
        }
        int n = this.componentsPerSample * this.bitsPerComponent;
        this.bytesPerSample = (n + 7) / 8;
        this.bytesPerRow = (this.samplesPerRow * n + 7) / 8;
        this.componentsPerRow = this.componentsPerSample * this.samplesPerRow;
        this.rowPredictor = -1;
        this.predictedComponent = new int[this.componentsPerSample];
        int n2 = 0;
        while (n2 < this.componentsPerSample) {
            this.predictedComponent[n2] = 0;
            ++n2;
        }
        this.row = new byte[this.nRows][];
        int n3 = 0;
        while (n3 < this.nRows) {
            this.row[n3] = new byte[this.bytesPerRow + this.bytesPerSample];
            int n4 = 0;
            while (n4 < this.bytesPerRow + this.bytesPerSample) {
                this.row[n3][n4] = 0;
                ++n4;
            }
            ++n3;
        }
        this.curSample = 0;
        this.curComponent = 0;
        this.eofRead = false;
        this.init = true;
    }

    private void engineInit(FilterParams filterParams) {
        if (filterParams != null) {
            if (filterParams.containsKey("Predictor")) {
                this.predictor = (Integer)filterParams.get("Predictor");
            }
            if (filterParams.containsKey("Cols")) {
                this.samplesPerRow = (Integer)filterParams.get("Cols");
            }
            if (filterParams.containsKey("Components")) {
                this.componentsPerSample = (Integer)filterParams.get("Components");
            }
            if (filterParams.containsKey("BitsPerComponent")) {
                this.bitsPerComponent = (Integer)filterParams.get("BitsPerComponent");
            }
        }
    }

    public long getTotalOut() {
        return this.totalOut;
    }

    protected void put(int n) throws IOException {
        this.wtr.write(this.TIFFPredict(n));
        ++this.totalOut;
    }
}

