/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ActionHandler;
import com.adobe.acrobat.gui.BookmarkNode;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.GoToActionHandler;
import com.adobe.acrobat.gui.tree.Icon;
import com.adobe.acrobat.gui.tree.Tree;
import com.adobe.acrobat.gui.tree.TreeListener;
import com.adobe.acrobat.gui.tree.TreeNode;
import com.adobe.acrobat.pdf.Bookmark;
import com.adobe.acrobat.pdf.VBookmark;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import java.io.InterruptedIOException;
import java.util.Dictionary;

public class BookmarkView
extends Tree
implements TreeListener,
VObserver,
StrobeContainer {
    private static Icon rootIcon = new Icon("icons/default/icon16.gif", "Acrobat Icon");
    static Icon icon = new Icon("icons/default/pageonly.gif", "Acrobat Icon");
    private AcroViewContext context;
    private BookmarkNode root;
    private VStrobe strobe;

    public BookmarkView(AcroViewContext acroViewContext) throws Exception {
        this.context = acroViewContext;
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        block7: {
            TreeNode treeNode = null;
            try {
                PDFObjStore pDFObjStore = this.context.getPDFObjStore(requester);
                if (pDFObjStore != null) {
                    this.removeTreeListener(this);
                    this.removeAll();
                    Bookmark bookmark = VBookmark.getVBookmarkRoot(pDFObjStore).bookmarkValue(requester);
                    String string = this.getDocumentTitle(requester);
                    treeNode = new BookmarkNode(null, bookmark, rootIcon, string);
                    this.addRootNode(treeNode);
                    ((BookmarkNode)treeNode).computeChildren(requester);
                    if (treeNode.getChildren().size() > 0) {
                        this.expandNode(treeNode);
                    }
                    this.addTreeListener(this);
                }
            }
            catch (WriteLockException writeLockException) {
                throw writeLockException;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                if (treeNode == null) break block7;
                treeNode.setIsLeaf();
                this.invalidate();
                this.validate();
            }
        }
    }

    public void computeChildrenAndExpand(TreeNode treeNode) {
        BookmarkNode bookmarkNode = (BookmarkNode)treeNode;
        Requester requester = new Requester();
        try {
            try {
                bookmarkNode.computeChildren(requester);
            }
            catch (Exception exception) {
                new ErrorDialog(PEUtil.getFrame(this), exception);
            }
            Object var5_5 = null;
            requester.releaseRequestees();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            requester.releaseRequestees();
            throw throwable;
        }
        this.expandNode(bookmarkNode);
    }

    private String getDocumentTitle(Requester requester) throws Exception {
        String string;
        String string2 = "Bookmarks for current document";
        PDFDict pDFDict = this.context.getPDFObjStore(requester).getTrailer().pdfReferenceValue(requester).dictValue(requester).get("Info").dictValue(requester);
        if (pDFDict.hasKey(string = "Title")) {
            PDFObj pDFObj = pDFDict.get(string);
            string2 = pDFObj.stringValue(requester);
        }
        return string2;
    }

    private String getStatusText(Bookmark bookmark, Requester requester) throws Exception {
        PDFObj pDFObj = bookmark.getDestObj();
        PDFReference pDFReference = bookmark.getActionRef();
        if (pDFObj != null) {
            return GoToActionHandler.getStatusText("GoTo", pDFObj, 0, this.context, requester);
        }
        if (pDFReference != null) {
            Dictionary dictionary = this.context.getPageView().createActionParamsDictionary(requester);
            return ActionHandler.getStatusText(pDFReference, dictionary, requester);
        }
        return "";
    }

    public void nodeDeselected(TreeNode treeNode) {
    }

    public void nodeSelected(TreeNode treeNode) {
        BookmarkNode bookmarkNode = (BookmarkNode)treeNode;
        this.performCommand(bookmarkNode.getBookmark());
    }

    private void performCommand(final Bookmark bookmark) {
        try {
            Transactor transactor = new Transactor(){

                public void buildChanges(Transaction transaction) throws Exception {
                    PDFObj pDFObj = bookmark.getDestObj();
                    PDFReference pDFReference = bookmark.getActionRef();
                    if (pDFObj != null) {
                        GoToActionHandler.goToDest(transaction, pDFObj, context);
                    } else if (pDFReference != null) {
                        Dictionary dictionary = context.getPageView().createActionParamsDictionary(transaction);
                        ActionHandler.performAction(transaction, pDFReference, dictionary);
                    }
                }
            };
            transactor.commit(this.context);
        }
        catch (Exception exception) {
            new ErrorDialog(PEUtil.getFrame(this), exception);
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

