/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.FontsPanel;
import com.adobe.acrobat.gui.TabbedPane;
import com.adobe.acrobat.gui.TransactionDialog;
import com.adobe.acrobat.pdf.PDFUtil;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStorePerms;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.StrobeUtils;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.VStrobeAsync;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InterruptedIOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DocInfo
extends TransactionDialog
implements VObserver,
StrobeContainer {
    private AcroViewContext context;
    private Frame parent;
    private TabbedPane tabs;
    private Container general;
    private Container security;
    private GridBagLayout gGeneral;
    private GridBagLayout gSecurity;
    private GridBagConstraints cGeneralL;
    private GridBagConstraints cGeneralR;
    private FontsPanel fontsPanel;
    private Button fonts;
    private Label titleLabel;
    private Label subjectLabel;
    private Label authorLabel;
    private Label keywordsLabel;
    private Label creatorLabel;
    private Label producerLabel;
    private Label creationDateLabel;
    private Label modificationDateLabel;
    private Label optimizedLabel;
    private Label sizeLabel;
    private Label versionLabel;
    private Label sourceLabel;
    private Label sourceHeading;
    private Label uriBaseLabel;
    private Label securityMethodLabel;
    private Label haveUserPermsLabel;
    private Label haveOwnerPermsLabel;
    private Label canPrintLabel;
    private Label canChangeLabel;
    private Label canCopyLabel;
    private Label canAnnotateLabel;
    private VStrobe strobe;

    DocInfo(AcroViewContext acroViewContext) {
        super(PEUtil.getFrame(acroViewContext.getRootComponent()), Util.getDialogString("DocInfo:Title"));
        this.context = acroViewContext;
        this.setLayout(new BorderLayout(5, 5));
        this.createGridPanels();
        this.createGeneralElements();
        this.createSecurityElements();
        this.tabs = new TabbedPane();
        this.tabs.addTab(Util.getDialogString("DocInfo:General"), this.general);
        this.tabs.addTab(Util.getDialogString("DocInfo:Security"), this.security);
        this.fontsPanel = new FontsPanel(this.context);
        this.tabs.addTab(Util.getDialogString("DocInfo:Font"), this.fontsPanel);
        this.tabs.selectTab(Util.getDialogString("DocInfo:General"));
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.okCancelPanel, "South");
        this.strobe = new VStrobeAsync(this);
        this.setResizable(false);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, Label label, GridBagConstraints gridBagConstraints, Component component, GridBagConstraints gridBagConstraints2) {
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
        gridBagLayout.setConstraints(component, gridBagConstraints2);
        container.add(component);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, String string, GridBagConstraints gridBagConstraints, Component component, GridBagConstraints gridBagConstraints2) {
        Label label = new Label(string, 2);
        this.addRow(container, gridBagLayout, label, gridBagConstraints, component, gridBagConstraints2);
    }

    protected void arrangeButtons() {
        this.buttons.setLayout(new GridLayout(1, 2, 5, 5));
        this.buttons.add(this.ok);
    }

    public void change(Requester requester) throws WriteLockException {
        PDFDict pDFDict = null;
        String string = null;
        try {
            pDFDict = this.context.getPDFObjStore(requester).getTrailer().pdfReferenceValue(requester).dictValue(requester).get("Info").dictValue(requester);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception exception) {
            string = PEUtil.getThrowableMessage(exception, true);
        }
        this.sizeLabel.setText("...");
        if (string != null) {
            this.titleLabel.setText(string);
            this.subjectLabel.setText(string);
            this.authorLabel.setText(string);
            this.keywordsLabel.setText(string);
            this.creatorLabel.setText(string);
            this.producerLabel.setText(string);
            this.creationDateLabel.setText(string);
            this.modificationDateLabel.setText(string);
        } else {
            this.titleLabel.setText("...");
            this.subjectLabel.setText("...");
            this.authorLabel.setText("...");
            this.keywordsLabel.setText("...");
            this.creatorLabel.setText("...");
            this.producerLabel.setText("...");
            this.creationDateLabel.setText("...");
            this.modificationDateLabel.setText("...");
            this.titleLabel.setText(this.getValue(pDFDict, "Title", requester));
            this.subjectLabel.setText(this.getValue(pDFDict, "Subject", requester));
            this.authorLabel.setText(this.getValue(pDFDict, "Author", requester));
            this.keywordsLabel.setText(this.getValue(pDFDict, "Keywords", requester));
            this.creatorLabel.setText(this.getValue(pDFDict, "Creator", requester));
            this.producerLabel.setText(this.getValue(pDFDict, "Producer", requester));
            String string2 = DocInfo.getDate(this.getValue(pDFDict, "CreationDate", requester));
            this.creationDateLabel.setText(string2);
            String string3 = this.getValue(pDFDict, "ModDate", requester);
            string3 = string3.equals(Util.getDialogString("DocInfo:FieldNotSpecified")) ? string2 : DocInfo.getDate(string3);
            this.modificationDateLabel.setText(string3);
        }
        try {
            int n = 0;
            n = this.context.getVByteArraySource().byteArraySourceValue(this.transaction).getByteArray().getLength();
            this.sizeLabel.setText(NumberFormat.getInstance().format(n));
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception exception) {
            this.sizeLabel.setText(PEUtil.getThrowableMessage(exception, true));
        }
        try {
            String string4 = null;
            pDFDict = this.context.getPDFObjStore(requester).getRootDict().pdfReferenceValue(requester).dictValue(requester);
            if (pDFDict.hasKey("URI") && (pDFDict = pDFDict.get("URI").dictValue(requester)).hasKey("Base")) {
                string4 = pDFDict.get("Base").stringValue(requester);
            }
            if (string4 != null) {
                this.uriBaseLabel.setText(string4);
            } else {
                this.uriBaseLabel.setText("");
            }
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception exception) {
            string = PEUtil.getThrowableMessage(exception, true);
        }
    }

    private void createGeneralElements() {
        this.titleLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:DocTitle"), this.cGeneralL, (Component)this.titleLabel, this.cGeneralR);
        this.subjectLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Subject"), this.cGeneralL, (Component)this.subjectLabel, this.cGeneralR);
        this.authorLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Author"), this.cGeneralL, (Component)this.authorLabel, this.cGeneralR);
        this.keywordsLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Keywords"), this.cGeneralL, (Component)this.keywordsLabel, this.cGeneralR);
        this.creatorLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Creator"), this.cGeneralL, (Component)this.creatorLabel, this.cGeneralR);
        this.producerLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Producer"), this.cGeneralL, (Component)this.producerLabel, this.cGeneralR);
        this.creationDateLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Created"), this.cGeneralL, (Component)this.creationDateLabel, this.cGeneralR);
        this.modificationDateLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Modified"), this.cGeneralL, (Component)this.modificationDateLabel, this.cGeneralR);
        Insets insets = new Insets(1, 4, 1, 4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.optimizedLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Optimized"), this.cGeneralL, (Component)this.optimizedLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 2;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = insets;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weightx = 1.0;
        this.sizeLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:FileSize"), gridBagConstraints2, (Component)this.sizeLabel, gridBagConstraints3);
        this.versionLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:Version"), this.cGeneralL, (Component)this.versionLabel, this.cGeneralR);
        this.sourceLabel = new Label();
        this.sourceHeading = new Label("", 2);
        this.addRow(this.general, this.gGeneral, this.sourceHeading, this.cGeneralL, (Component)this.sourceLabel, this.cGeneralR);
        this.uriBaseLabel = new Label();
        this.addRow(this.general, this.gGeneral, Util.getDialogString("DocInfo:URIBase"), this.cGeneralL, (Component)this.uriBaseLabel, this.cGeneralR);
    }

    private void createGridPanels() {
        this.general = new Panel();
        this.gGeneral = new GridBagLayout();
        this.general.setLayout(this.gGeneral);
        Insets insets = new Insets(1, 4, 1, 4);
        this.cGeneralL = new GridBagConstraints();
        this.cGeneralL.insets = insets;
        this.cGeneralL.fill = 1;
        this.cGeneralL.gridx = 0;
        this.cGeneralR = new GridBagConstraints();
        this.cGeneralR.insets = insets;
        this.cGeneralR.fill = 1;
        this.cGeneralR.gridx = 1;
        this.cGeneralR.gridwidth = 0;
        this.cGeneralR.weightx = 1.0;
        this.security = new Panel();
        this.gSecurity = new GridBagLayout();
        this.security.setLayout(this.gSecurity);
    }

    private void createSecurityElements() {
        this.securityMethodLabel = new Label();
        this.addRow(this.security, this.gSecurity, Util.getDialogString("DocInfo:SecurityMethod"), this.cGeneralL, (Component)this.securityMethodLabel, this.cGeneralR);
        this.haveUserPermsLabel = new Label();
        this.addRow(this.security, this.gSecurity, Util.getDialogString("DocInfo:OpenPassword"), this.cGeneralL, (Component)this.haveUserPermsLabel, this.cGeneralR);
        this.haveOwnerPermsLabel = new Label();
        this.addRow(this.security, this.gSecurity, Util.getDialogString("DocInfo:SecurityPassword"), this.cGeneralL, (Component)this.haveOwnerPermsLabel, this.cGeneralR);
        this.canPrintLabel = new Label();
        this.addRow(this.security, this.gSecurity, Util.getDialogString("DocInfo:Printing"), this.cGeneralL, (Component)this.canPrintLabel, this.cGeneralR);
        this.canChangeLabel = new Label();
        this.addRow(this.security, this.gSecurity, Util.getDialogString("DocInfo:Changing"), this.cGeneralL, (Component)this.canChangeLabel, this.cGeneralR);
        this.canCopyLabel = new Label();
        this.addRow(this.security, this.gSecurity, Util.getDialogString("DocInfo:Selecting"), this.cGeneralL, (Component)this.canCopyLabel, this.cGeneralR);
        this.canAnnotateLabel = new Label();
        this.addRow(this.security, this.gSecurity, Util.getDialogString("DocInfo:NotesForms"), this.cGeneralL, (Component)this.canAnnotateLabel, this.cGeneralR);
    }

    public static String getDate(String string) {
        Date date = null;
        Calendar calendar = PDFUtil.parseDate(string);
        if (calendar != null) {
            date = calendar.getTime();
        } else {
            DateFormat dateFormat = DateFormat.getDateInstance(1, Locale.US);
            dateFormat.setLenient(true);
            try {
                date = dateFormat.parse(string);
            }
            catch (Exception exception) {
                date = null;
                return string;
            }
        }
        return date == null ? Util.getDialogString("DocInfo:DateParseFailed") : String.valueOf(DateFormat.getDateInstance(1).format(date)) + "  " + DateFormat.getTimeInstance(2).format(date);
    }

    private String getSource(Requester requester) throws Exception {
        String string = null;
        ByteArraySource byteArraySource = this.context.getVByteArraySource().byteArraySourceValue(requester);
        URL uRL = byteArraySource.getURL();
        if (uRL == null) {
            string = byteArraySource.getFullName();
            this.sourceHeading.setText(Util.getDialogString("DocInfo:Source"));
        } else {
            string = uRL.toExternalForm();
            string = Util.decodeURL(string);
            string = Util.decodeURL(string);
            this.sourceHeading.setText(Util.getDialogString("DocInfo:URLSource"));
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String getValue(PDFDict pDFDict, String string, Requester requester) throws WriteLockException {
        try {
            if (pDFDict.hasKey(string)) {
                PDFObj pDFObj = pDFDict.get(string);
                return pDFObj.stringValue(requester);
            }
            return Util.getDialogString("DocInfo:FieldNotSpecified");
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
        catch (InterruptedIOException interruptedIOException) {
            return "";
        }
        catch (Exception exception) {
            return PEUtil.getThrowableMessage(exception, true);
        }
    }

    protected void populate() throws Exception {
        this.populateGeneralElements();
        this.populateSecurityElements();
        this.fontsPanel.populate();
        this.ok.requestFocus();
    }

    private void populateGeneralElements() throws Exception {
        PDFDict pDFDict = this.context.getPDFObjStore(this.transaction).getTrailer().pdfReferenceValue(this.transaction).dictValue(this.transaction).get("Info").dictValue(this.transaction);
        boolean bl = false;
        bl = this.context.getPDFObjStore(this.transaction).getVLinearizerInfo().linearizerInfoValue(this.transaction).isLinearized();
        String string = bl ? Util.getDialogString("DocInfo:Yes") : Util.getDialogString("DocInfo:No");
        this.optimizedLabel.setText(string);
        String string2 = this.context.getPDFObjStore(this.transaction).getHeader().stringValue(this.transaction);
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            if (Character.isDigit(string2.charAt(n2))) break;
            ++n2;
        }
        if (n2 < n) {
            string2 = string2.substring(n2);
        }
        this.versionLabel.setText(string2);
        this.sourceLabel.setText(this.getSource(this.transaction));
    }

    private void populateSecurityElements() throws Exception {
        PDFObjStorePerms pDFObjStorePerms = this.context.getPDFObjStore(this.transaction).getVPDFObjStorePerms().peObjStorePermsValue(this.transaction);
        this.securityMethodLabel.setText(pDFObjStorePerms.getCryptKey() == null ? Util.getDialogString("DocInfo:SecurityMethodNone") : Util.getDialogString("DocInfo:SecurityMethodStandard"));
        String string = Util.getDialogString("DocInfo:Yes");
        String string2 = Util.getDialogString("DocInfo:No");
        String string3 = Util.getDialogString("DocInfo:Allowed");
        String string4 = Util.getDialogString("DocInfo:NotAllowed");
        this.haveUserPermsLabel.setText(pDFObjStorePerms.haveUser() ? string : string2);
        this.haveOwnerPermsLabel.setText(pDFObjStorePerms.haveOwner() ? string : string2);
        this.canPrintLabel.setText(pDFObjStorePerms.canPrint() ? string3 : string4);
        this.canChangeLabel.setText(pDFObjStorePerms.canChange() ? string3 : string4);
        this.canCopyLabel.setText(pDFObjStorePerms.canCopy() ? string3 : string4);
        this.canAnnotateLabel.setText(pDFObjStorePerms.canAnnotate() ? string3 : string4);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            StrobeUtils.setAllStrobesActive(this.transaction, this, true);
            this.ok.requestFocus();
        }
        super.setVisible(bl);
        if (!bl) {
            StrobeUtils.setAllStrobesActive(this.transaction, this, false);
        }
    }

    public class TextLabel
    extends TextField
    implements KeyListener {
        public TextLabel() {
            super(55);
            this.addKeyListener(this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.moveCaret(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        private void moveCaret(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = this.getText().length();
            int n3 = this.getCaretPosition();
            switch (n) {
                case 35: {
                    this.setCaretPosition(n2);
                    break;
                }
                case 39: {
                    this.setCaretPosition(n3 > n2 ? n2 : n3 + 1);
                    break;
                }
                case 37: {
                    this.setCaretPosition(n3 > 0 ? n3 - 1 : 0);
                    break;
                }
                case 36: {
                    this.setCaretPosition(0);
                    break;
                }
                case 9: {
                    this.transferFocus();
                    break;
                }
                default: {
                    keyEvent.consume();
                }
            }
        }
    }
}

