/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.AddBinding;
import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.GroupBox;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.QuickSort;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.pe.notify.Transaction;
import com.adobe.util.MemUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class KeyBindings
extends BasicDialog
implements ItemListener {
    private Button addBinding;
    private Button delete;
    private Label heading;
    private Label userHeading;
    private List list;
    private List userList;
    private Vector sc;
    private Vector userSc;
    private int maxLine = 0;
    private int userMaxLine = 0;
    private int[] tab;
    private int[] userTab;
    private Font mono;
    private int scSortIndex = 0;
    private int userScSortIndex = 0;
    Frame parent;
    private Container pSys;
    private Container pUser;
    private Container pMain;
    private GridBagLayout gSys;
    private GridBagLayout gUser;
    private GridBagLayout gMain;
    private GridBagConstraints cSys;
    private GridBagConstraints cUser;
    private GridBagConstraints cMain;

    public KeyBindings(Frame frame, AcroViewContext acroViewContext, Transaction transaction) {
        super(frame, Util.getDialogString("KeyBinding:Title"), true);
        this.parent = frame;
        this.setLayout(new BorderLayout(5, 5));
        this.sc = new Vector();
        this.userSc = new Vector();
        this.mono = new Font("Monospaced", 0, 12);
        this.createGridPanels();
        this.createSystemElements();
        this.createUserElements();
        this.addRowFill(this.pMain, this.gMain, this.cMain, this.pSys, 1);
        this.addRowFill(this.pMain, this.gMain, this.cMain, this.pUser, 15);
        this.add((Component)this.pMain, "Center");
        this.add((Component)this.okCancelPanel, "East");
        this.initTabs();
        this.getKeyBindings();
        this.displayBindings();
        this.setHeading();
        this.initUserTabs();
        this.getUserKeyBindings();
        this.displayUserBindings();
        this.setUserHeading();
        this.restoreLocation();
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addBinding) {
            new AddBinding(this.parent, this);
        } else if (actionEvent.getSource() == this.delete) {
            int n = this.userList.getSelectedIndex();
            this.userSc.removeElementAt(n);
            this.userList.remove(n);
            if (this.userSc.size() == 0) {
                this.delete.setEnabled(false);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void addKeyBinding(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        this.userSc.addElement(stringArray);
        KeyBindings.sort(this.userSc, this.userScSortIndex);
        this.userList.add(this.align(stringArray));
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(string, 2);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRowFill(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, int n) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, 4, 1, 4);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private String align(String[] stringArray) {
        StringBuffer stringBuffer = MemUtil.allocStringBuffer(this.maxLine);
        int n = 0;
        while (n < this.maxLine) {
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.insert(0, stringArray[0]);
        stringBuffer.insert(this.tab[0], stringArray[1]);
        return stringBuffer.toString().trim();
    }

    protected void arrangeButtons() {
        this.buttons.setLayout(new GridLayout(2, 1, 5, 5));
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
        this.cancel.setVisible(false);
    }

    public void cancel() {
        this.getKeyBindings();
        this.displayBindings();
        super.cancel();
    }

    private void computeTabs() {
        int n = 0;
        while (n < this.sc.size()) {
            String[] stringArray = (String[])this.sc.elementAt(n);
            this.tab[0] = Math.max(this.tab[0], stringArray[0].length() + 5);
            this.maxLine = Math.max(this.maxLine, this.tab[0] + stringArray[1].length());
            ++n;
        }
    }

    private void computeUserTabs() {
        int n = 0;
        while (n < this.userSc.size()) {
            String[] stringArray = (String[])this.userSc.elementAt(n);
            this.userTab[0] = Math.max(this.userTab[0], stringArray[0].length() + 5);
            this.userMaxLine = Math.max(this.userMaxLine, this.userTab[0] + stringArray[1].length());
            ++n;
        }
    }

    private void createGridPanels() {
        this.pSys = new GroupBox(Util.getDialogString("KeyBinding:SystemDefinedShortcuts"));
        this.gSys = new GridBagLayout();
        this.cSys = new GridBagConstraints();
        this.pSys.setLayout(this.gSys);
        this.cSys.insets = new Insets(1, 4, 1, 4);
        this.cSys.fill = 1;
        this.pUser = new GroupBox(Util.getDialogString("KeyBinding:UserDefinedShortcuts"));
        this.gUser = new GridBagLayout();
        this.cUser = new GridBagConstraints();
        this.pUser.setLayout(this.gUser);
        this.cUser.insets = new Insets(1, 4, 1, 4);
        this.cUser.fill = 1;
        this.pMain = new LightWeightPanel();
        this.gMain = new GridBagLayout();
        this.cMain = new GridBagConstraints();
        this.pMain.setLayout(this.gMain);
        this.cMain.fill = 1;
    }

    private void createSystemElements() {
        this.list = new List(10, false);
        this.list.setFont(this.mono);
        this.heading = new Label();
        this.heading.setFont(this.mono);
        this.heading.addMouseListener(this);
        this.addRow(this.pSys, this.gSys, this.cSys, this.heading);
        this.addRow(this.pSys, this.gSys, this.cSys, this.list);
    }

    private void createUserElements() {
        this.addBinding = new Button(Util.getDialogString("KeyBinding:Add"));
        this.addBinding.addActionListener(this);
        this.addBinding.addKeyListener(this);
        this.delete = new Button(Util.getDialogString("KeyBinding:Remove"));
        this.delete.addActionListener(this);
        this.delete.addKeyListener(this);
        LightWeightPanel lightWeightPanel = new LightWeightPanel(new GridLayout(1, 2, 5, 5));
        lightWeightPanel.add(this.addBinding);
        lightWeightPanel.add(this.delete);
        this.userList = new List(6, false);
        this.userList.setFont(this.mono);
        this.userList.addItemListener(this);
        this.userHeading = new Label();
        this.userHeading.setFont(this.mono);
        this.userHeading.addMouseListener(this);
        this.addRow(this.pUser, this.gUser, this.cUser, this.userHeading);
        this.addRow(this.pUser, this.gUser, this.cUser, this.userList);
        this.addRow(this.pUser, this.gUser, this.cUser, lightWeightPanel);
    }

    private void displayBindings() {
        this.list.removeAll();
        this.computeTabs();
        int n = 0;
        while (n < this.sc.size()) {
            String[] stringArray = (String[])this.sc.elementAt(n);
            this.list.add(this.align(stringArray));
            ++n;
        }
    }

    private void displayUserBindings() {
        this.userList.removeAll();
        this.computeUserTabs();
        int n = 0;
        while (n < this.userSc.size()) {
            String[] stringArray = (String[])this.userSc.elementAt(n);
            this.userList.add(this.align(stringArray));
            ++n;
        }
    }

    private void getKeyBindings() {
        this.sc.removeAllElements();
        Properties properties = ReaderPrefs.getSystemKeymaps();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.sc.addElement(new String[]{(String)((Hashtable)properties).get(string), string});
        }
        if (this.sc.size() != 0) {
            KeyBindings.sort(this.sc, this.scSortIndex);
        }
    }

    public static char getKeyCode(String string) {
        String string2;
        int n = 0;
        if (string != null && (string2 = KeyBindings.getMainKeyText(string)) != null) {
            if (string2.length() == 1) {
                n = string2.charAt(0);
            } else if (string2.equals("F1")) {
                n = 112;
            } else if (string2.equals("F2")) {
                n = 113;
            } else if (string2.equals("F3")) {
                n = 114;
            } else if (string2.equals("F4")) {
                n = 115;
            } else if (string2.equals("F5")) {
                n = 116;
            } else if (string2.equals("F6")) {
                n = 117;
            } else if (string2.equals("F7")) {
                n = 118;
            } else if (string2.equals("F8")) {
                n = 119;
            } else if (string2.equals("F9")) {
                n = 120;
            } else if (string2.equals("F10")) {
                n = 121;
            } else if (string2.equals("F11")) {
                n = 122;
            } else if (string2.equals("F12")) {
                n = 123;
            }
        }
        return (char)n;
    }

    public static String getKeybindingText(KeyEvent keyEvent) {
        String string;
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        if (c != '\uffff' && c != ' ' && !Character.isISOControl(c)) {
            if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
                n &= 0xFFFFFFFE;
            } else if (!Character.isUpperCase(c)) {
                n &= 0xFFFFFFFE;
            }
            string = new Character(c).toString();
        } else {
            string = KeyEvent.getKeyText(keyEvent.getKeyCode());
            if (string.toLowerCase().indexOf("unknown") >= 0) {
                int n2 = (string = string.toLowerCase()).indexOf("0x");
                if (n2 >= 0) {
                    string = string.substring(n2);
                } else {
                    n2 = string.lastIndexOf(32);
                    if (n2 >= 0) {
                        string = string.substring(n2 + 1);
                    }
                }
            }
        }
        if ((n & 1) != 0) {
            string = "Shift+" + string;
        }
        if ((n & 4) != 0) {
            string = "Meta+" + string;
        }
        if ((n & 8) != 0) {
            string = "Alt+" + string;
        }
        if ((n & 2) != 0) {
            string = "Ctrl+" + string;
        }
        return string.replace(' ', '_');
    }

    public static String getMainKeyText(String string) {
        String string2 = KeyBindings.getModifiersText(string);
        if (string2.length() > 0) {
            string = string.substring(string2.length());
        }
        return string;
    }

    public static int getModifiers(String string) {
        int n = 0;
        if (string != null) {
            if (string.indexOf("Ctrl+") >= 0) {
                n += 2;
            }
            if (string.indexOf("Alt+") >= 0) {
                n += 8;
            }
            if (string.indexOf("Meta+") >= 0) {
                n += 4;
            }
            if (string.indexOf("Shift+") >= 0) {
                ++n;
            }
        }
        return n;
    }

    public static String getModifiersText(String string) {
        int n = string.lastIndexOf(43);
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(0, n + 1);
        }
        return "";
    }

    private void getUserKeyBindings() {
        this.userSc.removeAllElements();
        Properties properties = ReaderPrefs.getUserKeymaps();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.userSc.addElement(new String[]{(String)((Hashtable)properties).get(string), string});
        }
        if (this.userSc.size() == 0) {
            this.delete.setEnabled(false);
        } else {
            KeyBindings.sort(this.userSc, this.userScSortIndex);
            this.delete.setEnabled(true);
        }
    }

    private void initTabs() {
        this.tab = new int[1];
        this.tab[0] = Util.getDialogString("KeyBinding:Command").length() + 5;
    }

    private void initUserTabs() {
        this.userTab = new int[1];
        this.userTab[0] = Util.getDialogString("KeyBinding:Command").length() + 5;
    }

    public boolean isShortcutAvailable(String string) {
        int n = 0;
        while (n < this.sc.size()) {
            String[] stringArray = (String[])this.sc.elementAt(n);
            if (stringArray[1].equals(string)) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.userSc.size()) {
            String[] stringArray = (String[])this.userSc.elementAt(n2);
            if (stringArray[1].equals(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValidKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = n == 17 || n == 18 || n == 16 || n == 9;
        return keyEvent.isActionKey() || !bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.userList && itemEvent.getStateChange() == 1) {
            this.delete.setEnabled(true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.userHeading) {
            this.userScSortIndex = this.userScSortIndex == 0 ? 1 : 0;
            KeyBindings.sort(this.userSc, this.userScSortIndex);
            this.displayUserBindings();
        } else if (mouseEvent.getComponent() == this.heading) {
            this.scSortIndex = this.scSortIndex == 0 ? 1 : 0;
            KeyBindings.sort(this.sc, this.scSortIndex);
            this.displayBindings();
        }
    }

    public void ok() {
        ReaderPrefs.clearUserKeymaps();
        int n = 0;
        while (n < this.userSc.size()) {
            String[] stringArray = (String[])this.userSc.elementAt(n);
            ReaderPrefs.addUserKeymap(stringArray[0], stringArray[1]);
            ++n;
        }
        CommandRegistry.refresh();
        super.ok();
    }

    private void setHeading() {
        String string = this.align(new String[]{Util.getDialogString("KeyBinding:Command"), Util.getDialogString("KeyBinding:Binding")});
        this.heading.setText(String.valueOf(string) + "     ");
    }

    private void setUserHeading() {
        String string = this.align(new String[]{Util.getDialogString("KeyBinding:Command"), Util.getDialogString("KeyBinding:Binding")});
        this.userHeading.setText(String.valueOf(string) + "     ");
    }

    private static void sort(Vector vector, int n) {
        try {
            String[][] stringArray = new String[vector.size()][2];
            vector.copyInto((Object[])stringArray);
            QuickSort.sort(stringArray, 0, stringArray.length - 1, n);
            vector.removeAllElements();
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            Log.log(exception.toString());
        }
    }
}

