/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.URLByteArraySourceSpace;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ActionHandler;
import com.adobe.acrobat.gui.Authenticator;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.ViewerFrame;
import com.adobe.acrobat.pdf.FileSpec;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.util.PEUtil;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;

public class LaunchActionHandler
extends ActionHandler {
    public static final String Launch_K = "Launch";
    public static final String URI_K = "URI";
    public static final String Named_K = "Named";
    public static final String F_K = "F";
    public static final String N_K = "N";
    public static final String Base_K = "Base";
    public static final String IsMap_K = "IsMap";
    public static final String NewWindow_K = "NewWindow";

    private String getLaunchStatusText(PDFReference pDFReference, Dictionary dictionary, Requester requester) throws Exception {
        String string = "?";
        PDFDict pDFDict = pDFReference.dictValue(requester);
        if (pDFDict.hasKey(F_K)) {
            string = FileSpec.getFileString(pDFDict.get(F_K), requester);
        }
        return Util.getAcroViewContextString("StatusText:Launch", string);
    }

    private String getNamedStatusText(PDFReference pDFReference, Dictionary dictionary, Requester requester) throws Exception {
        String string = "?";
        PDFDict pDFDict = pDFReference.dictValue(requester);
        if (pDFDict.hasKey(N_K)) {
            string = pDFDict.get(N_K).nameValue(requester);
        }
        return Util.getAcroViewContextString("StatusText:Named", string);
    }

    public String getStatusText(String string, PDFReference pDFReference, Dictionary dictionary, Requester requester) throws Exception {
        if (string.equals(Launch_K)) {
            return this.getLaunchStatusText(pDFReference, dictionary, requester);
        }
        if (string.equals(URI_K)) {
            return this.getURIStatusText(pDFReference, dictionary, requester);
        }
        if (string.equals(Named_K)) {
            return this.getNamedStatusText(pDFReference, dictionary, requester);
        }
        return "";
    }

    private String getURIStatusText(PDFReference pDFReference, Dictionary dictionary, Requester requester) throws Exception {
        String string = "?";
        PDFDict pDFDict = pDFReference.dictValue(requester);
        if (pDFDict.hasKey(URI_K)) {
            string = pDFDict.get(URI_K).stringValue(requester);
        }
        return Util.getAcroViewContextString("StatusText:URI", string);
    }

    public void perform(Transaction transaction, String string, PDFReference pDFReference, Dictionary dictionary) throws Exception {
        if (string.equals(Launch_K)) {
            this.performLaunch(transaction, pDFReference, dictionary);
        } else if (string.equals(URI_K)) {
            this.performURI(transaction, pDFReference, dictionary);
        } else if (string.equals(Named_K)) {
            this.performNamed(transaction, pDFReference, dictionary);
        }
    }

    private void performLaunch(Transaction transaction, PDFReference pDFReference, Dictionary dictionary) throws Exception {
        PDFDict pDFDict = pDFReference.dictValue(transaction);
        AcroViewContext acroViewContext = (AcroViewContext)dictionary.get("AcroViewContext");
        boolean bl = false;
        if (pDFDict.hasKey(NewWindow_K)) {
            bl = pDFDict.get(NewWindow_K).booleanValue(transaction);
        }
        if (pDFDict.hasKey(F_K)) {
            PDFObjStore pDFObjStore = pDFReference.getObjStore();
            ByteArraySource byteArraySource = FileSpec.getByteArraySource(pDFDict.get(F_K), pDFObjStore, transaction);
            if (bl) {
                AcroViewContext acroViewContext2 = new AcroViewContext(transaction, byteArraySource);
                ViewerFrame viewerFrame = new ViewerFrame(acroViewContext2, transaction);
                viewerFrame.show();
            } else {
                acroViewContext.setByteArraySource(transaction, byteArraySource);
            }
        }
    }

    private void performNamed(Transaction transaction, PDFReference pDFReference, Dictionary dictionary) throws Exception {
        PDFDict pDFDict = pDFReference.dictValue(transaction);
        AcroViewContext acroViewContext = (AcroViewContext)dictionary.get("AcroViewContext");
        if (pDFDict.hasKey(N_K)) {
            String string = pDFDict.get(N_K).nameValue(transaction);
            CommandRegistry.executeCommand(transaction, acroViewContext, string);
        }
    }

    private void performURI(Transaction transaction, PDFReference pDFReference, Dictionary dictionary) throws Exception {
        block13: {
            Object object;
            Object object2;
            PDFDict pDFDict = pDFReference.dictValue(transaction);
            AcroViewContext acroViewContext = (AcroViewContext)dictionary.get("AcroViewContext");
            boolean bl = false;
            if (pDFDict.hasKey(IsMap_K)) {
                bl = pDFDict.get(IsMap_K).booleanValue(transaction);
            }
            if (!pDFDict.hasKey(URI_K)) break block13;
            String string = pDFDict.get(URI_K).stringValue(transaction);
            Point point = (Point)dictionary.get("MouseLocation");
            URL uRL = null;
            PDFDict pDFDict2 = acroViewContext.getPDFObjStore(transaction).getRootDict().pdfReferenceValue(transaction).dictValue(transaction);
            if (pDFDict2.hasKey(URI_K) && ((PDFDict)(object2 = pDFDict2.get(URI_K).dictValue(transaction))).hasKey(Base_K)) {
                try {
                    object = ((PDFDict)object2).get(Base_K).stringValue(transaction);
                    if (object != null) {
                        uRL = new URL((String)object);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (uRL == null) {
                uRL = acroViewContext.getVByteArraySource().byteArraySourceValue(transaction).getURL();
            }
            if (bl && point != null) {
                string = String.valueOf(string) + "?" + Integer.toString(point.x) + "," + Integer.toString(point.x);
            }
            uRL = uRL != null ? new URL(uRL, string) : new URL(string);
            object2 = null;
            if (uRL.getProtocol().equals("http")) {
                object = new Authenticator(uRL, PEUtil.getFrame(acroViewContext.getRootComponent()));
                if (!((Authenticator)object).didUserCancel()) {
                    object2 = URLByteArraySourceSpace.createURLByteArraySource(uRL, (Authenticator)object);
                }
            } else {
                object2 = URLByteArraySourceSpace.createURLByteArraySource(uRL);
            }
            if (object2 != null) {
                try {
                    acroViewContext.setByteArraySource(transaction, (ByteArraySource)object2);
                }
                catch (Exception exception) {
                    Session.getTheSession().showURL(uRL.toExternalForm());
                }
            }
        }
    }

    public static void register() {
        LaunchActionHandler launchActionHandler = new LaunchActionHandler();
        ActionHandler.registerHandler(Launch_K, launchActionHandler);
        ActionHandler.registerHandler(URI_K, launchActionHandler);
        ActionHandler.registerHandler(Named_K, launchActionHandler);
    }
}

