/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ActionHandler;
import com.adobe.acrobat.gui.Ornament;
import com.adobe.acrobat.gui.OrnamentFactory;
import com.adobe.acrobat.gui.OrnamentList;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.Selection;
import com.adobe.acrobat.gui.Tool;
import com.adobe.acrobat.gui.VGalleyPainting;
import com.adobe.acrobat.gui.VOrnament;
import com.adobe.acrobat.gui.VOrnamentList;
import com.adobe.acrobat.gui.VSelection;
import com.adobe.acrobat.gui.VisiblePage;
import com.adobe.acrobat.gui.ZoomValueSpec;
import com.adobe.acrobat.pdf.Document;
import com.adobe.acrobat.pdf.VAdditionalAction;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdf.VPageRefByNum;
import com.adobe.acrobat.pdf.VPageTreeNodeProps;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Util;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.awt.MessageDialog;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.awt.ScrollerLogic;
import com.adobe.pe.awt.StatusTextProvider;
import com.adobe.pe.awt.VCursor;
import com.adobe.pe.awt.VPoint;
import com.adobe.pe.awt.VRectangle;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.ExtensibleProxy;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VChange;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.notify.VValue;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.painting.VPaintingChain;
import com.adobe.pe.painting.VTranslatedPainting;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.vtypes.VFloat;
import com.adobe.pe.vtypes.VInt;
import com.adobe.pe.vtypes.VString;
import com.adobe.util.MemUtil;
import com.adobe.util.WeakRef;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.InterruptedIOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class PageView
implements Extensible,
StatusTextProvider {
    public static final String SinglePage_K = "SinglePage";
    public static final String OneColumn_K = "OneColumn";
    public static final String TwoColumnLeft_K = "TwoColumnLeft";
    public static final String TwoColumn_K = "TwoColumn";
    public static final String TwoColumnRight_K = "TwoColumnRight";
    public static final String FixedZoom_K = "FixedZoom";
    public static final String FitPage_K = "FitPage";
    public static final String FitVisible_K = "FitVisible";
    public static final String FitWidth_K = "FitWidth";
    public static final String FitVisibleWidth_K = "FitVisibleWidth";
    public static final String FitHeight_K = "FitHeight";
    public static final String FitVisibleHeight_K = "FitVisibleHeight";
    public static float kMinimumZoom = 0.083333336f;
    public static float kMaximumZoom = 8.0f;
    static final int kHGutterMargin = 5;
    static final int kVGutterMargin = 5;
    static final int kHInterpageMargin = 6;
    static final int kVInterpageMargin = 6;
    static final int kPageBorderThickness = 1;
    static final int kDropShadowThickness = 2;
    private Component component;
    private ExtensibleProxy exProxy = null;
    private VString vInScaleType;
    private VFloat vInScale;
    private VFloat vScale;
    private VInt vInCurrPage;
    private VInt vCurrPage;
    private VString vPageLayout;
    private VRectangle vContentBounds;
    VGalleySpecUserSpace vGalleySpecUserSpace;
    VGalleySpecDeviceSpace vGalleySpecDeviceSpace;
    VOrnamentList vOrnaments = new VGalleyOrnaments();
    VPainting vOrnamentPainting = new VPainting(){

        protected Painting computePainting(Requester requester) throws Exception {
            OrnamentList ornamentList = PageView.this.vOrnaments.ornamentListValue(requester);
            Painting painting = ornamentList.getVPainting().paintingValue(requester);
            return painting;
        }
    };
    private VPainting vPainting;
    private VRectangle vVisiblePagesRect = new VVisiblePagesRectangle();
    private Vector visPageCache = new Vector(0, 50);
    private VVisiblePages vVisiblePages = new VVisiblePages();
    private VHoveredOverOrnament vHoveredOverOrnament = new VHoveredOverOrnament();
    VSynchronizer mouseSynchronizer = new VSynchronizer();
    private VCursor vCursor = new VPageViewCursor();
    private VPoint vMouseHoverPosition = new VPoint(null);
    private VSelection vSelection = new VSelection(null);
    private AcroViewContext context;
    VInt vGalleyWidth;
    VInt vGalleyHeight;
    private ScrollerLogic scrollerLogic;
    static final String C_K = "C";
    static final String O_K = "O";
    private VSynchronizer openActionSynchronizer = new VSynchronizer(true, true);
    private VInt vNavigationSuspensionCounter = new VInt(0);
    private VPDFReference vLastMostVisiblePage = new VPDFReference(null);

    PageView(AcroViewContext acroViewContext, Requester requester) throws Exception {
        this.context = acroViewContext;
        String string = ReaderPrefs.fDefPageLayout.stringValue(requester);
        this.vPageLayout = new VString(string);
        this.vInCurrPage = new VInt(0);
        ZoomValueSpec zoomValueSpec = ReaderPrefs.fDefaultZoom.zoomValueSpecValue(requester);
        this.vInScaleType = new VString(zoomValueSpec.zoomType);
        this.vInScale = new VFloat(zoomValueSpec.zoomLevel);
        this.vScale = new VScale();
        this.vCurrPage = new VCurrPage();
        this.vGalleySpecUserSpace = new VGalleySpecUserSpace();
        this.vGalleySpecDeviceSpace = new VGalleySpecDeviceSpace();
        this.vGalleyWidth = new VGalleySize(true);
        this.vGalleyHeight = new VGalleySize(false);
        this.scrollerLogic = new ScrollerLogic(this.vGalleyWidth, this.vGalleyHeight, 0, 0);
        VGalleyPainting vGalleyPainting = new VGalleyPainting(this);
        VPaintingChain vPaintingChain = new VPaintingChain(this.vOrnamentPainting, vGalleyPainting);
        this.vPainting = new VTranslatedPainting(vPaintingChain, this.scrollerLogic.vHOutValue, this.scrollerLogic.vVOutValue);
    }

    private Point computeDesiredScrollPos(int n, Requester requester) throws Exception {
        Rectangle rectangle = this.getAperture(requester);
        Rectangle rectangle2 = this.getPageRectangle(n, requester);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        if (!rectangle.intersects(rectangle2)) {
            n2 = rectangle2.x - 1 - 3;
            n3 = rectangle2.y - 1 - 3;
        }
        return new Point(n2, n3);
    }

    public Dictionary createActionParamsDictionary(Requester requester) throws Exception {
        Dictionary dictionary = this.context.createActionParamsDictionary(requester);
        dictionary.put("PageView", this);
        dictionary.put("VisiblePage", this.getVisiblePage(this.getCurrentPage(requester)));
        return dictionary;
    }

    MouseTransactionClient createMouseTransactionClient(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        Tool tool;
        MouseTransactionClient mouseTransactionClient;
        Point point = mouseEvent.getPoint();
        int n = this.findPage(point, transaction);
        if (n >= 0) {
            this.vInCurrPage.setIntValue(transaction, n);
        }
        if ((mouseTransactionClient = this.getOrnamentMouseTransactionClient(transaction, mouseEvent)) == null && (tool = this.context.getVTool().toolValue(transaction)) != null) {
            mouseTransactionClient = tool.wantsMouseTransactionControl(transaction, this, mouseEvent);
        }
        return mouseTransactionClient;
    }

    public String dumpState(Requester requester) throws Exception {
        Rectangle rectangle = this.getAperture(requester);
        String string = "Aperture: (" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ")\n";
        Dimension dimension = new Dimension(this.vGalleyWidth.intValue(requester), this.vGalleyHeight.intValue(requester));
        string = String.valueOf(string) + "Galley size: (" + dimension.width + ", " + dimension.height + ")\n";
        return string;
    }

    public boolean extensionDataIsAvailable(String string) {
        return this.exProxy != null && this.exProxy.extensionDataExistsFor(string);
    }

    public int findPage(Point point, Requester requester) throws Exception {
        int n = this.vVisiblePages.numVisiblePages(requester);
        int n2 = 0;
        while (n2 < n) {
            VisiblePage visiblePage = this.vVisiblePages.NthVisiblePage(n2, requester);
            Rectangle rectangle = visiblePage.vPageCellRectangle.rectangleValue(requester);
            if (rectangle.contains(point)) {
                return visiblePage.pageNum;
            }
            ++n2;
        }
        return -1;
    }

    public PDFReference findPageRef(Point point, Requester requester) throws Exception {
        int n = this.findPage(point, requester);
        if (n == -1) {
            return null;
        }
        return VPageRefByNum.getVPageRefByNum(this.getPDFObjStore(requester), n).pdfReferenceValue(requester);
    }

    public AcroViewContext getAcroViewContext() {
        return this.context;
    }

    public Rectangle getAperture(Requester requester) throws Exception {
        return this.scrollerLogic.vApertureRectangle.rectangleValue(requester);
    }

    public FloatRect getAperturePageSpace(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.vAperturePageSpace.floatRectValue(requester);
        }
        return null;
    }

    public Dimension getApertureSize(Requester requester) throws Exception {
        return this.scrollerLogic.vAperture.dimensionValue(requester);
    }

    public int getCurrentPage(Requester requester) throws Exception {
        return this.vCurrPage.intValue(requester);
    }

    public PDFReference getCurrentPageRef(Requester requester) throws Exception {
        int n = this.getCurrentPage(requester);
        if (n == -1) {
            return null;
        }
        return this.getPageRef(n, requester);
    }

    public Component getDisplayComponent() {
        return this.component;
    }

    public Object getExtensionData(String string) {
        if (this.exProxy == null) {
            this.exProxy = new ExtensibleProxy(this);
        }
        return this.exProxy.getExtensionDataFor(string);
    }

    public AffineTransform getGalleyTransform(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.vGalleyTransform.affineTransformValue(requester);
        }
        return null;
    }

    public int getHScrollMax(Requester requester) throws Exception {
        return this.scrollerLogic.getHScrollMax(requester);
    }

    public Ornament getHoveredOverOrnament(Requester requester) throws Exception {
        return this.vHoveredOverOrnament.ornamentValue(requester);
    }

    int getNthColumnStart(int n, Requester requester) throws Exception {
        return this.vGalleySpecDeviceSpace.NthColumnStart(n, requester);
    }

    int getNthColumnWidthDeviceSpace(int n, Requester requester) throws Exception {
        return this.vGalleySpecDeviceSpace.NthColumnWidth(n, requester);
    }

    double getNthColumnWidthUserSpace(int n, Requester requester) throws Exception {
        return this.vGalleySpecUserSpace.NthColumnWidth(n, requester);
    }

    int getNthRowHeightDeviceSpace(int n, Requester requester) throws Exception {
        return this.vGalleySpecDeviceSpace.NthRowHeight(n, requester);
    }

    double getNthRowHeightUserSpace(int n, Requester requester) throws Exception {
        return this.vGalleySpecUserSpace.NthRowHeight(n, requester);
    }

    int getNthRowStart(int n, Requester requester) throws Exception {
        return this.vGalleySpecDeviceSpace.NthRowStart(n, requester);
    }

    public int getNumColumns(Requester requester) throws Exception {
        return this.vGalleySpecUserSpace.numColumns(requester);
    }

    public int getNumPages(Requester requester) throws Exception {
        PDFObjStore pDFObjStore = this.context.getPDFObjStore(requester);
        if (pDFObjStore == null) {
            return 0;
        }
        return Document.getNumPages(pDFObjStore).intValue(requester);
    }

    public int getNumRows(Requester requester) throws Exception {
        return this.vGalleySpecUserSpace.numRows(requester);
    }

    public FloatPoint getOriginForPage(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.vPageOrigin.floatPointValue(requester);
        }
        return null;
    }

    OrnamentList getOrnamentList(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.vPageOrnaments.ornamentListValue(requester);
        }
        return null;
    }

    public MouseTransactionClient getOrnamentMouseTransactionClient(Transaction transaction, MouseEvent mouseEvent) throws Exception {
        OrnamentList ornamentList = this.vOrnaments.ornamentListValue(transaction);
        Point point = mouseEvent.getPoint();
        Enumeration enumeration = ornamentList.getOrnaments();
        while (enumeration.hasMoreElements()) {
            MouseTransactionClient mouseTransactionClient;
            Ornament ornament = (Ornament)enumeration.nextElement();
            Rectangle rectangle = ornament.getVBounds().rectangleValue(transaction);
            if (rectangle == null || !rectangle.contains(point) || (mouseTransactionClient = ornament.wantsMouseTransactionControl(transaction, mouseEvent)) == null) continue;
            return mouseTransactionClient;
        }
        return null;
    }

    public PDFObjStore getPDFObjStore(Requester requester) throws Exception {
        return this.context.getPDFObjStore(requester);
    }

    Rectangle getPageCellRectangle(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.vPageCellRectangle.rectangleValue(requester);
        }
        return null;
    }

    int getPageColumn(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.getColumn(requester);
        }
        return -1;
    }

    public String getPageLayout(Requester requester) throws Exception {
        return this.vPageLayout.stringValue(requester);
    }

    public int getPageNum(PDFReference pDFReference, Requester requester) throws Exception {
        VPageTreeNodeProps vPageTreeNodeProps = VPageTreeNodeProps.getVPageTreeNodeProps(pDFReference);
        if (!vPageTreeNodeProps.isPage(requester)) {
            throw new Exception("Page not in page tree");
        }
        return vPageTreeNodeProps.numPagesBefore(requester);
    }

    Painting getPagePainting(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.vPagePainting.paintingValue(requester);
        }
        return null;
    }

    public Rectangle getPageRectangle(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.vPageRectangle.rectangleValue(requester);
        }
        return null;
    }

    public PDFReference getPageRef(int n, Requester requester) throws Exception {
        PDFObjStore pDFObjStore = this.context.getPDFObjStore(requester);
        if (pDFObjStore == null) {
            return null;
        }
        return VPageRefByNum.getVPageRefByNum(pDFObjStore, n).pdfReferenceValue(requester);
    }

    int getPageRow(int n, Requester requester) throws Exception {
        VisiblePage visiblePage;
        if (n >= 0 && n < this.getNumPages(requester) && (visiblePage = this.getVisiblePage(n)) != null) {
            return visiblePage.getRow(requester);
        }
        return -1;
    }

    public float getScale(Requester requester) throws Exception {
        return this.vScale.floatValue(requester);
    }

    public String getScaleType(Requester requester) throws Exception {
        return this.vInScaleType.stringValue(requester);
    }

    public Point getScrollPosition(Requester requester) throws Exception {
        return new Point(this.scrollerLogic.vHOutValue.intValue(requester), this.scrollerLogic.vVOutValue.intValue(requester));
    }

    ScrollerLogic getScrollerLogic() {
        return this.scrollerLogic;
    }

    public Selection getSelection(Requester requester) throws Exception {
        return this.vSelection.selectionValue(requester);
    }

    public int getTopLeftPage(Requester requester) throws Exception {
        String string = this.vPageLayout.stringValue(requester);
        if (string.equals(SinglePage_K)) {
            return this.vCurrPage.intValue(requester);
        }
        return -this.vGalleySpecUserSpace.startColumn(requester);
    }

    public VCursor getVCursor() {
        return this.vCursor;
    }

    public VPoint getVMousePosition() {
        return this.vMouseHoverPosition;
    }

    public VPainting getVPainting() {
        return this.vPainting;
    }

    public int getVScrollMax(Requester requester) throws Exception {
        return this.scrollerLogic.getVScrollMax(requester);
    }

    public VSelection getVSelection() {
        return this.vSelection;
    }

    VisiblePage getVisiblePage(int n) {
        VisiblePage visiblePage = null;
        WeakRef weakRef = null;
        if (n >= 0) {
            if (this.visPageCache.size() > n) {
                weakRef = (WeakRef)((Object)this.visPageCache.elementAt(n));
                if (weakRef != null) {
                    visiblePage = (VisiblePage)weakRef.get();
                }
            } else {
                this.visPageCache.setSize(n + 1);
            }
            if (visiblePage == null) {
                if (weakRef == null) {
                    weakRef = new WeakRef();
                    this.visPageCache.setElementAt(weakRef, n);
                }
                visiblePage = new VisiblePage(this, n);
                weakRef.set(visiblePage);
            }
        }
        return visiblePage;
    }

    public Rectangle getVisiblePagesRectangle(Requester requester) throws Exception {
        return this.vVisiblePagesRect.rectangleValue(requester);
    }

    public void goToPage(Transaction transaction, int n) throws Exception {
        this.suspendNavigation(transaction);
        this.goToPageGalley(transaction, n);
        Point point = this.computeDesiredScrollPos(n, transaction);
        this.scrollTo(transaction, point);
        this.resumeNavigation(transaction);
    }

    public void goToPageGalley(Transaction transaction, int n) throws Exception {
        this.suspendNavigation(transaction);
        this.vInCurrPage.setIntValue(transaction, n);
        this.resumeNavigation(transaction);
    }

    public int navigationSuspensionDepth(Transaction transaction) throws Exception {
        return this.vNavigationSuspensionCounter.intValue(transaction);
    }

    public boolean pageIsScrolledIntoView(int n, Requester requester) throws Exception {
        if (n < 0 || this.getNumPages(requester) <= n) {
            return true;
        }
        int n2 = this.vGalleySpecUserSpace.numRows(requester);
        int n3 = this.vGalleySpecUserSpace.numColumns(requester);
        int n4 = this.getTopLeftPage(requester);
        if (n2 == 1 && n3 == 1) {
            return n4 == n;
        }
        if (n < n4 || n4 + n2 * n3 <= n) {
            return false;
        }
        Point point = this.computeDesiredScrollPos(n, requester);
        Point point2 = this.getScrollPosition(requester);
        return point2.equals(point);
    }

    void performDocumentCloseAction(Transaction transaction) throws Exception {
        this.performPendingPageCloseAction(transaction);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        this.releaseInvisiblePages(rectangle, transaction);
    }

    private void performPageAction(Transaction transaction, VisiblePage visiblePage, String string, boolean bl) throws Exception {
        PDFReference pDFReference = visiblePage.getPageRef(transaction);
        PDFReference pDFReference2 = VAdditionalAction.getAdditionalAction(string, pDFReference, transaction);
        if (pDFReference2 != null) {
            try {
                ActionHandler.performAction(transaction, pDFReference2, visiblePage.createActionParamsDictionary(transaction));
            }
            catch (WriteLockException writeLockException) {
                throw writeLockException;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                if (bl) {
                    String string2 = Util.getAcroViewContextString("ErrorDialog:ContinueQuery", PEUtil.getThrowableMessage(throwable, true));
                    bl2 = MessageDialog.run(PEUtil.getFrame(this.context.getRootComponent()), Util.getAcroViewContextString("ErrorDialog:Title"), string2, Util.getAcroViewContextString("ErrorDialog:Continue"));
                }
                if (bl2) {
                    return;
                }
                transaction.errorAlreadyReported(throwable);
                PEUtil.throwThrowable(throwable);
            }
        }
    }

    void performPendingPageCloseAction(Transaction transaction) throws Exception {
        Object object;
        PDFObjStore pDFObjStore = this.getPDFObjStore(transaction);
        if (pDFObjStore == null) {
            return;
        }
        int n = this.getCurrentPage(transaction);
        final PDFReference pDFReference = n == -1 ? null : VPageRefByNum.getVPageRefByNum(pDFObjStore, n).pdfReferenceValue(transaction);
        PDFReference pDFReference2 = this.vLastMostVisiblePage.pdfReferenceValue(transaction);
        if (pDFReference2 != null) {
            VisiblePage visiblePage;
            object = this.getPDFObjStore(transaction);
            if (object == pDFReference2.getObjStore() && (visiblePage = this.getVisiblePage(VPageTreeNodeProps.getVPageTreeNodeProps(pDFReference2).numPagesBefore(transaction))) != null) {
                this.performPageAction(transaction, visiblePage, C_K, true);
            }
            this.vLastMostVisiblePage.setReferenceValue(transaction, null);
        }
        if (pDFReference2 != pDFReference) {
            object = new Transactor(){

                protected final void buildChanges(Transaction transaction) throws Exception {
                    VisiblePage visiblePage;
                    if (pDFReference != null && (visiblePage = this.getVisiblePage(VPageTreeNodeProps.getVPageTreeNodeProps(pDFReference).numPagesBefore(transaction))) != null) {
                        this.performPageAction(transaction, visiblePage, PageView.O_K, false);
                    }
                }
            };
            this.vLastMostVisiblePage.setReferenceValue(transaction, pDFReference);
            this.openActionSynchronizer.setTransactor(transaction.getExecutionContext(), (Transactor)object);
        }
    }

    public String provideStatusString(Requester requester) throws Exception {
        Tool tool = this.context.getVTool().toolValue(requester);
        return tool.getStatusString(this, requester);
    }

    void releaseInvisiblePages(Rectangle rectangle, Requester requester) throws Exception {
        int n = 0;
        while (n < this.visPageCache.size()) {
            VisiblePage visiblePage;
            WeakRef weakRef = (WeakRef)((Object)this.visPageCache.elementAt(n));
            if (weakRef != null && weakRef.isLocked() && (visiblePage = (VisiblePage)weakRef.get()) != null) {
                int n2 = visiblePage.getRow(requester);
                int n3 = visiblePage.getColumn(requester);
                if (n2 < rectangle.y || n3 < rectangle.x || n2 >= rectangle.y + rectangle.height || n3 >= rectangle.x + rectangle.width) {
                    visiblePage.pageIsInvisible(requester);
                    weakRef.unlockAll();
                }
            }
            ++n;
        }
    }

    public void resumeNavigation(Transaction transaction) throws Exception {
        int n = this.vNavigationSuspensionCounter.intValue(transaction);
        this.vNavigationSuspensionCounter.setIntValue(transaction, n - 1);
        if (n - 1 == 0) {
            PDFReference pDFReference = this.getCurrentPageRef(transaction);
            if (pDFReference != this.vLastMostVisiblePage.pdfReferenceValue(transaction)) {
                this.performPendingPageCloseAction(transaction);
            }
            Painting painting = this.getVPainting().paintingValue(transaction);
        }
    }

    public void scrollTo(Transaction transaction, Point point) throws Exception {
        this.suspendNavigation(transaction);
        this.scrollerLogic.vHInValue.setIntValue(transaction, point.x);
        this.scrollerLogic.vVInValue.setIntValue(transaction, point.y);
        this.resumeNavigation(transaction);
    }

    public void scrollToPageSpaceRect(Transaction transaction, int n, FloatRect floatRect, boolean bl) throws Exception {
        this.suspendNavigation(transaction);
        this.goToPageGalley(transaction, n);
        PDFReference pDFReference = this.getPageRef(n, transaction);
        Dimension dimension = this.getApertureSize(transaction);
        if (bl) {
            AffineTransform affineTransform = VPageProps.getDefaultTransform(pDFReference).affineTransformValue(transaction);
            FloatRect floatRect2 = floatRect.transformRect(affineTransform);
            double d = (double)dimension.width / floatRect2.width();
            double d2 = (double)dimension.height / floatRect2.height();
            float f = (float)Math.min(d, d2);
            this.setScale(transaction, f);
            this.scrollToPageSpaceRect(transaction, n, floatRect, false);
        } else {
            AffineTransform affineTransform = this.getGalleyTransform(n, transaction);
            FloatRect floatRect3 = floatRect.transformRect(affineTransform);
            int n2 = (int)(floatRect3.getxMin() + (floatRect3.width() - (double)dimension.width) / 2.0);
            int n3 = (int)(floatRect3.getyMin() + (floatRect3.height() - (double)dimension.height) / 2.0);
            this.scrollTo(transaction, new Point(n2, n3));
        }
        this.resumeNavigation(transaction);
    }

    void setDisplayComponent(Component component) {
        this.component = component;
    }

    void setMouseHoverPosition(Transaction transaction, Point point) throws Exception {
        this.vMouseHoverPosition.setPointValue(transaction, point);
        if (point != null) {
            OrnamentList ornamentList = this.vOrnaments.ornamentListValue(transaction);
            Enumeration enumeration = ornamentList.getOrnaments();
            while (enumeration.hasMoreElements()) {
                Ornament ornament = (Ornament)enumeration.nextElement();
                Rectangle rectangle = ornament.getVBounds().rectangleValue(transaction);
                if (rectangle == null || !rectangle.contains(point) || !ornament.mouseHover(transaction, point)) continue;
                this.vHoveredOverOrnament.setOrnamentValue(transaction, ornament);
                return;
            }
            this.vHoveredOverOrnament.setOrnamentValue(transaction, null);
        }
    }

    void setMouseHoverPosition(final Point point) {
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                PageView.this.setMouseHoverPosition(transaction, point);
            }
        };
        this.mouseSynchronizer.setTransactor(null, transactor);
    }

    public void setPageLayout(Transaction transaction, String string) throws Exception {
        if (this.getNumPages(transaction) <= 1) {
            string = SinglePage_K;
        }
        if (!string.equals(this.vPageLayout.stringValue(transaction))) {
            Rectangle rectangle;
            float f = 0.0f;
            Rectangle rectangle2 = this.getAperture(transaction);
            Point point = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            int n = this.findPage(point, transaction);
            this.suspendNavigation(transaction);
            if (n >= 0) {
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x -= rectangle.x;
                    point.y -= rectangle.y;
                }
                f = this.getScale(transaction);
            }
            this.vPageLayout.setStringValue(transaction, string);
            if (n >= 0) {
                f = this.getScale(transaction) / f;
                point.x = Math.round(f * (float)point.x) - rectangle2.width / 2;
                point.y = Math.round(f * (float)point.y) - rectangle2.height / 2;
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x += rectangle.x;
                    point.y += rectangle.y;
                }
                this.goToPageGalley(transaction, n);
                this.scrollTo(transaction, point);
            }
            this.resumeNavigation(transaction);
        }
    }

    public void setScale(Transaction transaction, float f) throws Exception {
        if (f != this.vInScale.floatValue(transaction) || !FixedZoom_K.equals(this.vInScaleType.stringValue(transaction))) {
            Rectangle rectangle;
            float f2 = 0.0f;
            Rectangle rectangle2 = this.getAperture(transaction);
            Point point = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            int n = this.findPage(point, transaction);
            this.suspendNavigation(transaction);
            if (n >= 0) {
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x -= rectangle.x;
                    point.y -= rectangle.y;
                }
                f2 = this.getScale(transaction);
            }
            this.vInScaleType.setStringValue(transaction, FixedZoom_K);
            this.vInScale.setFloatValue(transaction, f);
            if (n >= 0) {
                f2 = this.getScale(transaction) / f2;
                point.x = Math.round(f2 * (float)point.x) - rectangle2.width / 2;
                point.y = Math.round(f2 * (float)point.y) - rectangle2.height / 2;
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x += rectangle.x;
                    point.y += rectangle.y;
                }
                this.goToPageGalley(transaction, n);
                this.scrollTo(transaction, point);
            }
            this.resumeNavigation(transaction);
        }
    }

    void setScaleType(Transaction transaction, String string) throws Exception {
        if (!string.equals(this.vInScaleType.stringValue(transaction))) {
            Rectangle rectangle;
            float f = 0.0f;
            Rectangle rectangle2 = this.getAperture(transaction);
            Point point = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            int n = this.findPage(point, transaction);
            this.suspendNavigation(transaction);
            if (n >= 0) {
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x -= rectangle.x;
                    point.y -= rectangle.y;
                }
                f = this.getScale(transaction);
            }
            this.vInScaleType.setStringValue(transaction, string);
            if (n >= 0) {
                f = this.getScale(transaction) / f;
                point.x = Math.round(f * (float)point.x) - rectangle2.width / 2;
                point.y = Math.round(f * (float)point.y) - rectangle2.height / 2;
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x += rectangle.x;
                    point.y += rectangle.y;
                }
                this.goToPageGalley(transaction, n);
                this.scrollTo(transaction, point);
            }
            this.resumeNavigation(transaction);
        }
    }

    public void setSelection(Transaction transaction, Selection selection) throws Exception {
        this.vSelection.setSelectionValue(transaction, selection);
    }

    public void setZoomValueSpec(Transaction transaction, ZoomValueSpec zoomValueSpec) throws Exception {
        if (zoomValueSpec.zoomLevel != this.vInScale.floatValue(transaction) || !zoomValueSpec.zoomType.equals(this.vInScaleType.stringValue(transaction))) {
            Rectangle rectangle;
            float f = 0.0f;
            Rectangle rectangle2 = this.getAperture(transaction);
            Point point = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            int n = this.findPage(point, transaction);
            this.suspendNavigation(transaction);
            if (n >= 0) {
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x -= rectangle.x;
                    point.y -= rectangle.y;
                }
                f = this.getScale(transaction);
            }
            this.vInScaleType.setStringValue(transaction, zoomValueSpec.zoomType);
            this.vInScale.setFloatValue(transaction, zoomValueSpec.zoomLevel);
            if (n >= 0) {
                f = this.getScale(transaction) / f;
                point.x = Math.round(f * (float)point.x) - rectangle2.width / 2;
                point.y = Math.round(f * (float)point.y) - rectangle2.height / 2;
                rectangle = this.getPageRectangle(n, transaction);
                if (rectangle != null) {
                    point.x += rectangle.x;
                    point.y += rectangle.y;
                }
                this.goToPageGalley(transaction, n);
                this.scrollTo(transaction, point);
            }
            this.resumeNavigation(transaction);
        }
    }

    public void suspendNavigation(Transaction transaction) throws Exception {
        int n = this.vNavigationSuspensionCounter.intValue(transaction);
        if (n == 0) {
            PDFReference pDFReference;
            int n2 = this.getCurrentPage(transaction);
            if (n2 != -1) {
                PDFObjStore pDFObjStore = this.getPDFObjStore(transaction);
                pDFReference = VPageRefByNum.getVPageRefByNum(pDFObjStore, n2).pdfReferenceValue(transaction);
            } else {
                pDFReference = null;
            }
            this.vLastMostVisiblePage.setReferenceValue(transaction, pDFReference);
        }
        this.vNavigationSuspensionCounter.setIntValue(transaction, n + 1);
    }

    private class VScale
    extends VFloat {
        VScale() {
        }

        protected final float computeFloat(Requester requester) throws Exception {
            String string = PageView.this.vInScaleType.stringValue(requester);
            float f = 1.0f;
            if (PageView.this.getNumPages(requester) == 0) {
                f = 1.0f;
            } else if (string.equals(PageView.FixedZoom_K)) {
                f = PageView.this.vInScale.floatValue(requester);
            } else {
                Dimension dimension = ((PageView)PageView.this).scrollerLogic.vInterior.dimensionValue(requester);
                int n = ((PageView)PageView.this).scrollerLogic.vVscrollbar.getSize().width;
                int n2 = ((PageView)PageView.this).scrollerLogic.vHscrollbar.getSize().height;
                int n3 = PageView.this.vGalleySpecUserSpace.numColumns(requester);
                int n4 = 10 + (n3 - 1) * 6 + n3 * 5;
                int n5 = 15;
                double d = PageView.this.vGalleySpecUserSpace.totalWidth(requester);
                double d2 = PageView.this.vGalleySpecUserSpace.totalHeight(requester);
                double d3 = PageView.this.vGalleySpecUserSpace.maxHeight(requester);
                if (d <= 0.0 || d2 <= 0.0) {
                    return 1.0f;
                }
                if (string.equals(PageView.FitPage_K) || string.equals(PageView.FitVisible_K)) {
                    double d4 = (double)(dimension.width - n4) / d;
                    double d5 = (double)(dimension.height - n5) / d3;
                    f = (float)Math.min(d4, d5);
                    int n6 = (int)Math.ceil(d2 * (double)f) + n5;
                    if (n6 > dimension.height) {
                        d4 = (double)(dimension.width - n4 - n) / d;
                        f = (float)Math.min(d4, d5);
                    }
                } else if (string.equals(PageView.FitWidth_K) || string.equals(PageView.FitVisibleWidth_K)) {
                    double d6 = (double)(dimension.width - n4) / d;
                    int n7 = (int)Math.ceil(d2 * d6) + n5;
                    if (n7 > dimension.height) {
                        d6 = (double)(dimension.width - n4 - n) / d;
                    }
                    f = (float)d6;
                } else if (string.equals(PageView.FitHeight_K) || string.equals(PageView.FitVisibleHeight_K)) {
                    double d7 = (double)(dimension.height - n5) / d3;
                    int n8 = (int)Math.ceil(d * d7) + n4;
                    int n9 = (int)Math.ceil(d2 * d7) + n5;
                    if (n9 > dimension.height) {
                        n8 += n;
                    }
                    if (n8 > dimension.width) {
                        d7 = (double)(dimension.height - n5 - n2) / d3;
                    }
                    f = (float)d7;
                } else {
                    throw new IllegalArgumentException("Unknown fit type");
                }
            }
            if (f < kMinimumZoom) {
                f = kMinimumZoom;
            }
            if (f > kMaximumZoom) {
                f = kMaximumZoom;
            }
            return f;
        }
    }

    private class VCurrPage
    extends VInt {
        VCurrPage() {
        }

        protected final int computeInt(Requester requester) throws Exception {
            int n = PageView.this.getNumPages(requester);
            int n2 = PageView.this.vInCurrPage.intValue(requester);
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= n) {
                n2 = n - 1;
            }
            return n2;
        }
    }

    private class VGalleySpecUserSpace
    extends VValue {
        private VPageRectUserSpace[] vPageRect = null;
        private double[] columnWidth;
        private double totalWidth;
        private double[] rowHeight;
        private double totalHeight;
        private double maxHeight;
        private int numPages;
        private int numColumns;
        private int startColumn;
        private int numRows;

        VGalleySpecUserSpace() {
        }

        double NthColumnWidth(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.columnWidth[n];
        }

        double NthRowHeight(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.rowHeight[n];
        }

        protected final void compute(Requester requester) throws Exception {
            FloatRect floatRect;
            String string;
            int n;
            this.numPages = PageView.this.getNumPages(requester);
            if (this.vPageRect == null || this.numPages > 0 && this.vPageRect.length != this.numPages) {
                this.vPageRect = new VPageRectUserSpace[this.numPages];
                n = 0;
                while (n < this.numPages) {
                    this.vPageRect[n] = new VPageRectUserSpace(n);
                    ++n;
                }
            }
            this.numColumns = (string = PageView.this.vPageLayout.stringValue(requester)).equals(PageView.SinglePage_K) || string.equals(PageView.OneColumn_K) || this.numPages < 2 ? 1 : 2;
            this.startColumn = (string.equals(PageView.TwoColumn_K) || string.equals(PageView.TwoColumnRight_K)) && this.numPages > 2 ? 1 : 0;
            this.numRows = this.numPages == 0 || string.equals(PageView.SinglePage_K) ? 1 : (this.numPages + this.startColumn + this.numColumns - 1) / this.numColumns;
            this.columnWidth = MemUtil.allocDouble(this.numColumns);
            this.rowHeight = MemUtil.allocDouble(this.numRows);
            this.rowHeight[0] = 0.0;
            this.columnWidth[0] = 0.0;
            if (string.equals(PageView.SinglePage_K)) {
                n = PageView.this.getTopLeftPage(requester);
                if (n >= 0) {
                    floatRect = this.vPageRect[n].floatRectValue(requester);
                    this.columnWidth[0] = floatRect.width();
                    this.rowHeight[0] = floatRect.height();
                }
            } else {
                n = this.columnWidth.length;
                while (n-- > 0) {
                    this.columnWidth[n] = 0.0;
                }
                n = this.rowHeight.length;
                while (n-- > 0) {
                    this.rowHeight[n] = 0.0;
                }
                int n2 = 0;
                int n3 = this.startColumn;
                n = 0;
                while (n < this.numPages) {
                    floatRect = this.vPageRect[n].floatRectValue(requester);
                    this.columnWidth[n3] = Math.max(floatRect.width(), this.columnWidth[n3]);
                    this.rowHeight[n2] = Math.max(floatRect.height(), this.rowHeight[n2]);
                    if (++n3 == this.numColumns) {
                        n3 = 0;
                        ++n2;
                    }
                    ++n;
                }
            }
            this.totalWidth = 0.0;
            n = this.numColumns;
            while (n-- > 0) {
                this.totalWidth += this.columnWidth[n];
            }
            this.totalHeight = 0.0;
            this.maxHeight = 0.0;
            n = this.numRows;
            while (n-- > 0) {
                this.totalHeight += this.rowHeight[n];
                this.maxHeight = Math.max(this.rowHeight[n], this.maxHeight);
            }
        }

        double maxHeight(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.maxHeight;
        }

        int numColumns(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.numColumns;
        }

        int numRows(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.numRows;
        }

        int startColumn(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.startColumn;
        }

        double totalHeight(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.totalHeight;
        }

        double totalWidth(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.totalWidth;
        }
    }

    private class VPageRectUserSpace
    extends VFloatRect {
        private int pageNum;

        VPageRectUserSpace(int n) {
            this.pageNum = n;
        }

        protected final FloatRect computeFloatRect(Requester requester) throws Exception {
            PDFReference pDFReference = PageView.this.getPageRef(this.pageNum, requester);
            FloatRect floatRect = VPageProps.getCropBox(pDFReference).floatRectValue(requester);
            AffineTransform affineTransform = VPageProps.getDefaultTransform(pDFReference).affineTransformValue(requester);
            return floatRect.transformRect(affineTransform);
        }
    }

    private class VGalleySpecDeviceSpace
    extends VValue {
        private int[] columnStart;
        private int totalWidth;
        private int[] rowStart;
        private int totalHeight;

        VGalleySpecDeviceSpace() {
        }

        int NthColumnStart(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.columnStart[n];
        }

        int NthColumnWidth(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.columnStart[n + 1] - this.columnStart[n];
        }

        int NthRowHeight(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.rowStart[n + 1] - this.rowStart[n];
        }

        int NthRowStart(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.rowStart[n];
        }

        protected final void compute(Requester requester) throws Exception {
            int n = PageView.this.getNumPages(requester);
            int n2 = PageView.this.vGalleySpecUserSpace.numColumns(requester);
            int n3 = PageView.this.vGalleySpecUserSpace.startColumn(requester);
            int n4 = PageView.this.vGalleySpecUserSpace.numRows(requester);
            double d = PageView.this.vScale.floatValue(requester);
            this.columnStart = MemUtil.allocInt(n2 + 1);
            this.rowStart = MemUtil.allocInt(n4 + 1);
            if (n == 0) {
                this.totalWidth = 0;
                this.columnStart[1] = 0;
                this.columnStart[0] = 0;
                this.totalHeight = 0;
                this.rowStart[1] = 0;
                this.rowStart[0] = 0;
            } else {
                int n5 = 0;
                int n6 = 0;
                while (n6 < n2) {
                    this.columnStart[n6] = n5;
                    n5 = n6 == 0 ? (n5 += 5) : (n5 += 3);
                    n5 += (int)Math.ceil(PageView.this.vGalleySpecUserSpace.NthColumnWidth(n6, requester) * d);
                    n5 += 4;
                    n5 = n6 == n2 - 1 ? (n5 += 5) : (n5 += 3);
                    ++n6;
                }
                this.columnStart[n6] = this.totalWidth = n5;
                n5 = 0;
                n6 = 0;
                while (n6 < n4) {
                    this.rowStart[n6] = n5;
                    n5 = n6 == 0 ? (n5 += 5) : (n5 += 3);
                    n5 += (int)Math.ceil(PageView.this.vGalleySpecUserSpace.NthRowHeight(n6, requester) * d);
                    n5 += 4;
                    n5 = n6 == n4 - 1 ? (n5 += 5) : (n5 += 3);
                    ++n6;
                }
                this.rowStart[n6] = this.totalHeight = n5;
            }
        }

        int totalHeight(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.totalHeight;
        }

        int totalWidth(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.totalWidth;
        }
    }

    private class VGalleyOrnaments
    extends VOrnamentList {
        VGalleyOrnaments() {
        }

        protected final OrnamentList computeOrnamentList(Requester requester) throws Exception {
            OrnamentList ornamentList = new OrnamentList();
            OrnamentFactory.invokeFactories(ornamentList, PageView.this, requester);
            return ornamentList;
        }
    }

    class VVisiblePagesRectangle
    extends VRectangle {
        VVisiblePagesRectangle() {
        }

        protected final Rectangle computeRectangle(Requester requester) throws Exception {
            int n;
            Rectangle rectangle = PageView.this.getAperture(requester);
            if (rectangle.width < 1 && rectangle.height < 1) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n2 = PageView.this.vGalleySpecUserSpace.numRows(requester);
            int n3 = PageView.this.vGalleySpecUserSpace.numColumns(requester);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                n = PageView.this.vGalleySpecDeviceSpace.NthColumnStart(n8, requester);
                if (n <= rectangle.x) {
                    n4 = n8;
                }
                if (n >= rectangle.x + rectangle.width) break;
                n5 = n8++;
            }
            n = 0;
            while (n < n2) {
                int n9 = PageView.this.vGalleySpecDeviceSpace.NthRowStart(n, requester);
                if (n9 <= rectangle.y) {
                    n6 = n;
                }
                if (n9 >= rectangle.y + rectangle.height) break;
                n7 = n++;
            }
            if (n4 <= n5 && n6 <= n7) {
                Rectangle rectangle2 = new Rectangle(n4, n6, n5 - n4 + 1, n7 - n6 + 1);
                PageView.this.releaseInvisiblePages(rectangle2, requester);
                return rectangle2;
            }
            return new Rectangle(0, 0, 0, 0);
        }
    }

    private class VVisiblePages
    extends VValue {
        private Vector visiblePages = null;

        VVisiblePages() {
        }

        VisiblePage NthVisiblePage(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            return (VisiblePage)this.visiblePages.elementAt(n);
        }

        protected final void compute(Requester requester) throws Exception {
            Rectangle rectangle = PageView.this.getVisiblePagesRectangle(requester);
            int n = PageView.this.getTopLeftPage(requester);
            int n2 = PageView.this.vGalleySpecUserSpace.numColumns(requester);
            int n3 = PageView.this.getNumPages(requester);
            Vector<VisiblePage> vector = new Vector<VisiblePage>();
            int n4 = rectangle.y;
            while (n4 < rectangle.y + rectangle.height) {
                int n5 = rectangle.x;
                while (n5 < rectangle.x + rectangle.width) {
                    int n6 = n4 * n2 + n5 + n;
                    if (n6 >= 0 && n6 < n3) {
                        PDFReference pDFReference = PageView.this.getPageRef(n6, requester);
                        VisiblePage visiblePage = PageView.this.getVisiblePage(n6);
                        if (visiblePage != null) {
                            vector.addElement(visiblePage);
                        }
                    }
                    ++n5;
                }
                ++n4;
            }
            this.visiblePages = vector;
        }

        VisiblePage forPage(int n, Requester requester) throws Exception {
            this.handleRequest(requester);
            int n2 = this.visiblePages.size();
            while (n2-- > 0) {
                VisiblePage visiblePage = (VisiblePage)this.visiblePages.elementAt(n2);
                if (visiblePage.pageNum != n) continue;
                return visiblePage;
            }
            return null;
        }

        int numVisiblePages(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.visiblePages.size();
        }
    }

    private class VHoveredOverOrnament
    extends VOrnament {
        private Ornament value;

        public VHoveredOverOrnament() {
        }

        public VHoveredOverOrnament(Ornament ornament) {
            this.value = ornament;
            this.initializeSettable();
        }

        public Ornament computeOrnament(Requester requester) {
            return this.value;
        }

        public Ornament ornamentValue(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.value;
        }

        public void setOrnamentValue(Transaction transaction, Ornament ornament) throws WriteLockException {
            VHoveredOverOrnamentChange vHoveredOverOrnamentChange = new VHoveredOverOrnamentChange(ornament, this);
            transaction.registerChange(vHoveredOverOrnamentChange);
        }

        class VHoveredOverOrnamentChange
        extends VChange {
            private Ornament newValue;
            private Ornament oldValue;

            VHoveredOverOrnamentChange(Ornament ornament, VHoveredOverOrnament vHoveredOverOrnament2) {
                super(vHoveredOverOrnament2);
                this.oldValue = vHoveredOverOrnament2.value;
                this.newValue = ornament;
            }

            public void apply() {
                VHoveredOverOrnament.this.value = this.newValue;
            }

            public boolean isNoOp() {
                return this.newValue == this.oldValue;
            }

            public VChange mergeChange(VChange vChange) {
                VHoveredOverOrnamentChange vHoveredOverOrnamentChange = new VHoveredOverOrnamentChange(this.newValue, VHoveredOverOrnament.this);
                vHoveredOverOrnamentChange.oldValue = ((VHoveredOverOrnamentChange)vChange).oldValue;
                return vHoveredOverOrnamentChange;
            }

            public void repeal() {
                VHoveredOverOrnament.this.value = this.oldValue;
            }
        }
    }

    private class VPageViewCursor
    extends VCursor {
        VPageViewCursor() {
        }

        protected final Cursor computeCursor(Requester requester) throws Exception {
            Tool tool = PageView.this.getAcroViewContext().getVTool().toolValue(requester);
            return tool.getCursor(PageView.this, requester);
        }
    }

    private class VGalleySize
    extends VInt {
        private boolean horizontal;

        VGalleySize(boolean bl) {
            this.horizontal = bl;
        }

        protected int computeInt(Requester requester) throws Exception {
            if (this.horizontal) {
                return PageView.this.vGalleySpecDeviceSpace.totalWidth(requester);
            }
            return PageView.this.vGalleySpecDeviceSpace.totalHeight(requester);
        }
    }
}

