/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.GroupBox;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PrintServerSetupDialog
extends BasicDialog
implements ItemListener {
    private Container pMain;
    private Container pServer;
    private Container pUse;
    private GridBagLayout gMain;
    private GridBagLayout gServer;
    private GridBagLayout gUse;
    private GridBagConstraints cMain;
    private GridBagConstraints cServer;
    private GridBagConstraints cUse;
    private TextField serverHome;
    private TextField serverPrint;
    private TextField serverPrinters;
    private Checkbox useServer;

    public PrintServerSetupDialog(AcroViewContext acroViewContext, Transaction transaction) {
        super(PEUtil.getFrame(acroViewContext.getRootComponent()), Util.getDialogString("PrintServer:Title"), true);
        this.setLayout(new BorderLayout(5, 5));
        this.createGridPanels();
        this.createServerElements();
        this.createUseElements();
        this.addRowFill(this.pMain, this.gMain, this.cMain, this.pUse, 1);
        this.addRowFill(this.pMain, this.gMain, this.cMain, this.pServer, 15);
        this.add((Component)this.pMain, "Center");
        this.add((Component)this.okCancelPanel, "East");
        this.pack();
        this.setResizable(false);
        this.preFill();
        this.setVisible(true);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(string, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(string, 2);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRowFill(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, int n) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, 4, 1, 4);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected void arrangeButtons() {
        this.buttons.setLayout(new GridLayout(2, 1, 5, 5));
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
    }

    private void createGridPanels() {
        this.pServer = new GroupBox(Util.getDialogString("PrintServer:ServerGroup"));
        this.gServer = new GridBagLayout();
        this.cServer = new GridBagConstraints();
        this.pServer.setLayout(this.gServer);
        this.cServer.insets = new Insets(1, 4, 1, 4);
        this.cServer.fill = 1;
        this.pUse = new LightWeightPanel();
        this.gUse = new GridBagLayout();
        this.cUse = new GridBagConstraints();
        this.pUse.setLayout(this.gUse);
        this.cUse.insets = new Insets(1, 4, 1, 4);
        this.cUse.fill = 1;
        this.pMain = new LightWeightPanel();
        this.gMain = new GridBagLayout();
        this.cMain = new GridBagConstraints();
        this.pMain.setLayout(this.gMain);
        this.cMain.insets = new Insets(1, 4, 1, 4);
        this.cMain.fill = 1;
    }

    private void createServerElements() {
        this.serverHome = new TextField(30);
        this.serverPrint = new TextField(30);
        this.serverPrinters = new TextField(30);
        this.addRow(this.pServer, this.gServer, this.cServer, Util.getDialogString("PrintServer:Host"), this.serverHome);
        this.addRow(this.pServer, this.gServer, this.cServer, Util.getDialogString("PrintServer:PrintProgram"), this.serverPrint);
        this.addRow(this.pServer, this.gServer, this.cServer, Util.getDialogString("PrintServer:PrintersProgram"), this.serverPrinters);
    }

    private void createUseElements() {
        this.useServer = new Checkbox(Util.getDialogString("PrintServer:UseServer"));
        this.useServer.addItemListener(this);
        this.addRow(this.pUse, this.gUse, this.cUse, this.useServer);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.useServer) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.serverHome.setEnabled(bl);
            this.serverPrint.setEnabled(bl);
            this.serverPrinters.setEnabled(bl);
        }
    }

    public void ok() {
        this.save();
        super.ok();
    }

    private void preFill() {
        this.serverHome.setText(ReaderPrefs.fPrintServerPath);
        this.serverPrint.setText(ReaderPrefs.fPrintServerPrint);
        this.serverPrinters.setText(ReaderPrefs.fPrintServerGetPrinters);
        boolean bl = ReaderPrefs.fUsePrintServer;
        this.useServer.setState(bl);
        this.serverHome.setEnabled(bl);
        this.serverPrint.setEnabled(bl);
        this.serverPrinters.setEnabled(bl);
    }

    private void save() {
        ReaderPrefs.fPrintServerPath = this.serverHome.getText().trim();
        ReaderPrefs.fPrintServerPrint = this.serverPrint.getText().trim();
        ReaderPrefs.fPrintServerGetPrinters = this.serverPrinters.getText().trim();
        ReaderPrefs.fUsePrintServer = this.useServer.getState();
    }
}

