/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.Highlight;
import com.adobe.acrobat.gui.PageOrnamentFactory;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.Selection;
import com.adobe.acrobat.gui.TextSelectionOrnamentFactory;
import com.adobe.acrobat.gui.VHighlight;
import com.adobe.acrobat.pdf.VPageTextWordy;
import com.adobe.acrobat.pdf.Wordy;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class TextSelection
extends Selection {
    private static TextSelection gEmptyTextSelection = new TextSelection();
    PDFReference pageRef = null;
    PageView pv;
    int start;
    int length;
    private TextSelection plus = null;
    VHighlight vTextHighlight = new VHighlight(){

        protected final Highlight computeHighlight(Requester requester) throws Exception {
            Highlight highlight;
            Highlight highlight2 = highlight = TextSelection.this.plus == null ? null : TextSelection.this.plus.getHighlight(requester);
            if (TextSelection.this.pageRef != null) {
                Wordy wordy = VPageTextWordy.getVPageTextWordy(TextSelection.this.pageRef).wordyValue(requester);
                BezierPath bezierPath = wordy.getPageHighlight(TextSelection.this.start, TextSelection.this.length);
                highlight = new Highlight(highlight, bezierPath, TextSelection.this.pageRef);
            }
            return highlight;
        }
    };

    private TextSelection() {
    }

    public TextSelection(PageView pageView, PDFReference pDFReference, int n, int n2) {
        this.pageRef = pDFReference;
        this.pv = pageView;
        this.start = n;
        this.length = n2;
    }

    public TextSelection addToSelection(PageView pageView, PDFReference pDFReference, int n, int n2, Requester requester) throws Exception {
        TextSelection textSelection = this;
        int n3 = pageView.getPageNum(pDFReference, requester);
        TextSelection textSelection2 = this;
        TextSelection textSelection3 = null;
        while (textSelection2 != null) {
            if (textSelection2.pageRef == null) {
                if (textSelection3 != null) {
                    textSelection3.plus = textSelection2.plus;
                }
            } else {
                int n4 = pageView.getPageNum(textSelection2.pageRef, requester);
                if (n3 < n4 || n3 == n4 && n + n2 < textSelection2.start) {
                    TextSelection textSelection4 = new TextSelection(this.pv, pDFReference, n, n2);
                    textSelection4.plus = textSelection2;
                    if (textSelection3 != null) {
                        textSelection3.plus = textSelection4;
                    } else {
                        textSelection = textSelection4;
                    }
                    return textSelection;
                }
                if (n3 == n4 && n <= textSelection2.start + textSelection2.length && textSelection2.start <= n + n2) {
                    int n5 = Math.min(n, textSelection2.start);
                    n2 = Math.max(n + n2, textSelection2.start + textSelection2.length) - n5;
                    n = n5;
                    if (textSelection3 != null) {
                        textSelection3.plus = textSelection2.plus;
                    } else {
                        textSelection = textSelection2.plus;
                        textSelection3 = textSelection2;
                    }
                } else {
                    textSelection3 = textSelection2;
                }
            }
            textSelection2 = textSelection2.plus;
        }
        TextSelection textSelection5 = new TextSelection(this.pv, pDFReference, n, n2);
        if (textSelection3 != null) {
            textSelection3.plus = textSelection5;
        } else {
            textSelection = textSelection5;
        }
        return textSelection;
    }

    public boolean canCopy(Requester requester) throws Exception {
        return this.pageRef != null;
    }

    public Transferable copy(Transaction transaction) throws Exception {
        return this.makeStringSelection(transaction);
    }

    public FloatRect getBBoxForPage(PDFReference pDFReference, Requester requester) throws Exception {
        if (this.pageRef == null) {
            return null;
        }
        Highlight highlight = this.getHighlight(requester);
        return highlight.getBounds(pDFReference);
    }

    public static TextSelection getEmptyTextSelection() {
        return gEmptyTextSelection;
    }

    Highlight getHighlight(Requester requester) throws Exception {
        return this.vTextHighlight.highlightValue(requester);
    }

    public int getSelectionEnd(PDFReference pDFReference) {
        TextSelection textSelection = this;
        int n = -1;
        while (textSelection != null) {
            if (this.pageRef == pDFReference) {
                n = n == -1 ? this.start + this.length - 1 : Math.max(this.start + this.length - 1, n);
            }
            textSelection = textSelection.plus;
        }
        return n;
    }

    public int getSelectionStart(PDFReference pDFReference) {
        TextSelection textSelection = this;
        int n = -1;
        while (textSelection != null) {
            if (textSelection.pageRef == pDFReference) {
                n = n == -1 ? this.start : Math.min(this.start, n);
            }
            textSelection = textSelection.plus;
        }
        return n;
    }

    public boolean includesPage(PDFReference pDFReference) {
        return this.pageRef == pDFReference || this.plus != null && this.plus.includesPage(pDFReference);
    }

    public boolean isEmpty() {
        return this.pageRef == null;
    }

    private String makeString(Requester requester) throws Exception {
        String string = "";
        TextSelection textSelection = this;
        while (textSelection != null) {
            if (textSelection.pageRef != null) {
                Wordy wordy = VPageTextWordy.getVPageTextWordy(textSelection.pageRef).wordyValue(requester);
                string = string.length() == 0 ? wordy.getSubstring(this.start, this.length) : String.valueOf(string) + " " + wordy.getSubstring(this.start, this.length);
            }
            textSelection = textSelection.plus;
        }
        return string;
    }

    private StringSelection makeStringSelection(Requester requester) throws Exception {
        String string = this.makeString(requester);
        return new StringSelection(string);
    }

    public static void register() {
        PageOrnamentFactory.registerFactory(new TextSelectionOrnamentFactory());
    }
}

