/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ComboBox;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.TransactionDialog;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Label;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class URLDialog
extends TransactionDialog {
    private URL url;
    private ComboBox urlText = new ComboBox(this);

    public URLDialog(AcroViewContext acroViewContext) {
        super(PEUtil.getFrame(acroViewContext.getRootComponent()), Util.getDialogString("OpenURL:Title"));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.urlText, "Center");
        this.add((Component)new Label(Util.getDialogString("OpenURL:EnterURL"), 0), "North");
        this.add((Component)this.okCancelPanel, "South");
        this.setResizable(false);
    }

    public URL getURL() {
        return this.url;
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getComponent().getParent() == this.urlText && keyEvent.getKeyCode() == 10) {
            this.ok();
        } else {
            super.keyReleased(keyEvent);
        }
    }

    protected void ok() {
        try {
            this.url = new URL(Util.encodeURL(Util.decodeURL(this.urlText.getText())));
            ((Component)this.frame).setCursor(Cursor.getPredefinedCursor(3));
            super.ok();
            ((Component)this.frame).setCursor(Cursor.getDefaultCursor());
        }
        catch (MalformedURLException malformedURLException) {
            this.urlText.setText("Invalid URL. Please try again.");
            this.urlText.selectAll();
            this.urlText.requestFocus();
        }
    }

    protected void populate() throws Exception {
        this.urlText.removeAll();
        Vector vector = ReaderPrefs.getHistory();
        int n = 0;
        while (n < vector.size()) {
            this.urlText.addItem(Util.decodeURL((String)vector.elementAt(n)));
            ++n;
        }
        if (vector.size() > 0) {
            this.urlText.setText(Util.decodeURL((String)vector.elementAt(0)));
        }
    }

    public void setVisible(boolean bl) {
        if (bl && this.urlText.getText().length() > 0) {
            this.urlText.selectAll();
            this.urlText.requestFocus();
        }
        super.setVisible(bl);
    }
}

