/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.PrintUI;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.gui.Tool;
import com.adobe.acrobat.gui.VNavigationUIElements;
import com.adobe.acrobat.gui.VTocUIElements;
import com.adobe.acrobat.gui.ViewModes;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.UIElement;
import com.adobe.pe.awt.UIElementGroup;
import com.adobe.pe.awt.UIElementVerb;
import com.adobe.pe.awt.VImage;
import com.adobe.pe.awt.VUIElement;
import com.adobe.pe.notify.Requester;

public class VViewerToolBar
extends VUIElement
implements ViewerCommand {
    private AcroViewContext context;

    public VViewerToolBar(AcroViewContext acroViewContext) {
        this.context = acroViewContext;
    }

    protected final UIElement computeUIElement(Requester requester) throws Exception {
        UIElementGroup uIElementGroup = new UIElementGroup(0);
        uIElementGroup.addUIElement(this.createFileGroup(requester));
        uIElementGroup.addUIElement(VTocUIElements.getVTocUIElements(this.context).uiElementValue(requester));
        uIElementGroup.addUIElement(this.createToolsGroup(requester));
        uIElementGroup.addUIElement(VNavigationUIElements.getVNavigationUIElements(this.context, false).uiElementValue(requester));
        uIElementGroup.addUIElement(ViewModes.getVZoomUIElementGroup(this.context, 1).uiElementValue(requester));
        uIElementGroup.addUIElement(this.createFindGroup(requester));
        return uIElementGroup;
    }

    private UIElement createAuxViewGroup(Requester requester) throws Exception {
        UIElementVerb uIElementVerb;
        UIElementGroup uIElementGroup = new UIElementGroup(1);
        if (CommandRegistry.isCommandAllowed("PageOnly")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(13, this.context), null, null, "pageonly.gif");
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("ShowBookmarks")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(14, this.context), null, null, "bookmarks.gif");
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("Thumbnails")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(16, this.context), null, null, "thumbnails.gif");
            uIElementGroup.addUIElement(uIElementVerb);
        }
        return uIElementGroup;
    }

    private UIElement createFileGroup(Requester requester) throws Exception {
        UIElementVerb uIElementVerb;
        UIElementGroup uIElementGroup = new UIElementGroup(2);
        if (CommandRegistry.isCommandAllowed("Open")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(2, this.context), Util.getMenuVString("Open"), null, "open.gif");
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("OpenURL")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(3, this.context), Util.getMenuVString("OpenURL"), null, "openurl.gif");
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("Reload")) {
            uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(17, this.context), Util.getMenuVString("Reload"), null, "reload.gif");
            uIElementGroup.addUIElement(uIElementVerb);
        }
        if (CommandRegistry.isCommandAllowed("Print")) {
            uIElementVerb = PrintUI.getPrintUIElement(this.context);
            uIElementGroup.addUIElement(uIElementVerb);
        }
        return uIElementGroup;
    }

    private UIElement createFindGroup(Requester requester) throws Exception {
        UIElementGroup uIElementGroup = new UIElementGroup(1);
        if (CommandRegistry.isCommandAllowed("Find")) {
            UIElementVerb uIElementVerb = new UIElementVerb(0, new SimpleUIVerb(18, this.context), Util.getMenuVString("Find"), null, "find.gif");
            uIElementGroup.addUIElement(uIElementVerb);
        }
        return uIElementGroup;
    }

    private UIElement createToolsGroup(Requester requester) throws Exception {
        UIElementGroup uIElementGroup = new UIElementGroup(2, Util.getMenuVString("Tools"));
        UIElement uIElement = Tool.getVToolUIElementGroup(this.context).uiElementValue(requester);
        uIElementGroup.addUIElement(uIElement);
        return uIElementGroup;
    }

    private VImage createVImage(String string) {
        return new VImage(Util.getResourceImage(string));
    }
}

