/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.Viewer;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.VViewerMenus;
import com.adobe.acrobat.gui.ViewerPanel;
import com.adobe.acrobat.pdf.Document;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.PEFrame;
import com.adobe.pe.awt.VMenuBar;
import com.adobe.pe.awt.VMenuBarObserver;
import com.adobe.pe.awt.VUIElement;
import com.adobe.pe.awt.VWindowTitleObserver;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VString;
import com.adobe.util.ImageUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;

public class ViewerFrame
extends PEFrame {
    private boolean closed = false;
    AcroViewContext context;

    public ViewerFrame(AcroViewContext acroViewContext, ViewerPanel viewerPanel, Requester requester) throws Exception {
        this(acroViewContext, true, requester);
        this.addPanel(viewerPanel);
    }

    public ViewerFrame(AcroViewContext acroViewContext, Requester requester) throws Exception {
        this(acroViewContext, true, requester);
        ViewerPanel viewerPanel = new ViewerPanel(acroViewContext);
        this.addPanel(viewerPanel);
    }

    private ViewerFrame(AcroViewContext acroViewContext, boolean bl, Requester requester) throws Exception, WriteLockException {
        super(true);
        this.setLayout(new BorderLayout());
        ImageUtil.registerRootComponent(this);
        Viewer.registerViewerWindow(this);
        VUIElement vUIElement = VViewerMenus.getVViewerMenus(acroViewContext);
        VMenuBar vMenuBar = new VMenuBar(vUIElement, acroViewContext);
        VMenuBarObserver vMenuBarObserver = new VMenuBarObserver(this, vMenuBar);
        VAcroDocTitle vAcroDocTitle = new VAcroDocTitle();
        VWindowTitleObserver vWindowTitleObserver = new VWindowTitleObserver(this, vAcroDocTitle);
        this.registerStrobes(vWindowTitleObserver, vMenuBarObserver);
        this.context = acroViewContext;
        this.setIconImage(Util.getMyImage("icons/default/icon16.gif"));
        this.setSizeAndLocation(requester);
        this.addWindowListener(this);
    }

    private void addPanel(ViewerPanel viewerPanel) {
        this.add((Component)viewerPanel, "Center");
    }

    public void close(Transaction transaction) {
        if (!this.context.getFullScreenVerb().getChecked()) {
            ReaderPrefs.setLocation(this.getLocation());
            ReaderPrefs.setWidth(this.getSize().width);
            ReaderPrefs.setHeight(this.getSize().height);
        }
        ImageUtil.unregisterRootComponent(this);
        Viewer.unregisterViewerWindow(this);
        this.dispose();
    }

    public AcroViewContext getContext() {
        return this.context;
    }

    public void setLocation(int n, int n2) {
        if (!this.context.getFullScreenVerb().getChecked()) {
            super.setLocation(n, n2);
        }
    }

    public void setLocation(Point point) {
        if (!this.context.getFullScreenVerb().getChecked()) {
            super.setLocation(point);
        }
    }

    private void setSizeAndLocation(Requester requester) throws WriteLockException {
        try {
            Dimension dimension = new Dimension(ReaderPrefs.fWidth.intValue(requester), ReaderPrefs.fHeight.intValue(requester));
            Point point = new Point(ReaderPrefs.fXOrg.intValue(requester), ReaderPrefs.fYOrg.intValue(requester));
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (dimension.height > dimension2.height) {
                dimension.height = dimension2.height;
            }
            if (dimension.width > dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (point.x > dimension2.width - dimension.width) {
                point.x = dimension2.width - dimension.width;
            }
            if (point.y > dimension2.height - dimension.height) {
                point.y = dimension2.height - dimension.height;
            }
            ((Component)this).setSize(dimension);
            this.setLocation(point);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            Log.clog("ViewerFrame: " + exception.toString());
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        int n = this.getComponentCount();
        if (n > 0) {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof ViewerPanel) {
                    component.requestFocus();
                    break;
                }
                ++n2;
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                ViewerFrame.this.close(transaction);
            }
        };
        try {
            transactor.commit(this.context);
        }
        catch (Exception exception) {}
    }

    class VAcroDocTitle
    extends VString {
        VAcroDocTitle() {
        }

        protected final String computeString(Requester requester) throws Exception {
            String string = null;
            ByteArraySource byteArraySource = ViewerFrame.this.context.getVByteArraySource().byteArraySourceValue(requester);
            if (byteArraySource != null) {
                string = byteArraySource.getTitle();
            }
            if (string == null || string.length() == 0) {
                try {
                    PDFObjStore pDFObjStore = ViewerFrame.this.context.getPDFObjStore(requester);
                    if (pDFObjStore != null) {
                        string = Document.getDocTitle(pDFObjStore).stringValue(requester);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {}
            }
            if (string == null || string.length() == 0) {
                string = Util.getDialogString("Main:ViewerName");
            } else {
                int n;
                int n2 = string.lastIndexOf(47);
                if (n2 >= 0) {
                    string = string.substring(n2 + 1);
                }
                if ((n = string.length()) > 4 && string.substring(n - 4, n).equalsIgnoreCase(".pdf")) {
                    string = string.substring(0, n - 4);
                }
                string = Util.getDialogString("Main:WindowTitle", string);
            }
            return string;
        }
    }
}

