/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.OrnamentFactory;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.Tool;
import com.adobe.acrobat.gui.ZoomMouseTransactionClient;
import com.adobe.acrobat.gui.ZoomToolOrnamentFactory;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.awt.VRectangle;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.util.Assert;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ZoomTool
extends Tool {
    public static final double defaultZoomRatio = Math.sqrt(2.0);
    static final String ZoomIn_K = "ZoomIn";
    static final String ZoomOut_K = "ZoomOut";
    static final String VZoomTrackingRectangle_K = "VZoomTrackingRectangle";
    static Tool gZoomInTool = new ZoomTool(true);
    static Tool gZoomOutTool = new ZoomTool(false);
    boolean zoomIn;

    private ZoomTool(boolean bl) {
        super(Util.getMenuVString(bl ? ZoomIn_K : ZoomOut_K), bl ? "zoomin.gif" : "zoomout.gif");
        this.zoomIn = bl;
    }

    public Cursor getCursor(PageView pageView, Requester requester) throws Exception {
        Cursor cursor = super.getCursor(pageView, requester);
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(1);
        }
        return cursor;
    }

    public String getStatusString(PageView pageView, Requester requester) throws Exception {
        float f;
        Rectangle rectangle = ZoomTool.getVZoomTrackingRectangle(pageView).rectangleValue(requester);
        if (rectangle == null || rectangle.width == 0 && rectangle.height == 0) {
            f = pageView.getScale(requester);
            f = this.zoomIn ? (float)((double)f * defaultZoomRatio) : (float)((double)f / defaultZoomRatio);
        } else {
            float f2 = pageView.getScale(requester);
            Rectangle rectangle2 = pageView.getAperture(requester);
            float f3 = (float)rectangle2.width * f2 / (float)rectangle.width;
            float f4 = (float)rectangle2.height * f2 / (float)rectangle.height;
            f = Math.min(f3, f4);
            if (!this.zoomIn) {
                f = f2 * f2 / f;
            }
        }
        f = Math.max(PageView.kMinimumZoom, f);
        f = Math.min(PageView.kMaximumZoom, f);
        return Util.getAcroViewContextString("StatusText:ZoomTo", new Integer(Math.round(f * 100.0f)));
    }

    static VRectangle getVZoomTrackingRectangle(PageView pageView) {
        return (VRectangle)pageView.getExtensionData(VZoomTrackingRectangle_K);
    }

    public static Tool getZoomInTool() {
        return gZoomInTool;
    }

    public static Tool getZoomOutTool() {
        return gZoomOutTool;
    }

    public static void register() {
        ExtensionDataProvider extensionDataProvider = new ExtensionDataProvider(){

            public Object provide(String string, Extensible extensible) {
                if (string.equals(ZoomTool.VZoomTrackingRectangle_K)) {
                    Assert.notFalse(extensible instanceof PageView);
                    return new VRectangle(null);
                }
                throw new ProviderNotFoundException(string);
            }
        };
        Extension.registerProvider(VZoomTrackingRectangle_K, extensionDataProvider);
        Tool.registerTool(ZoomIn_K, ZoomTool.getZoomInTool());
        Tool.registerTool(ZoomOut_K, ZoomTool.getZoomOutTool());
        OrnamentFactory.registerFactory(new ZoomToolOrnamentFactory());
    }

    public MouseTransactionClient wantsMouseTransactionControl(Transaction transaction, PageView pageView, MouseEvent mouseEvent) {
        return new ZoomMouseTransactionClient(pageView, this.zoomIn);
    }
}

