/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.util.Util;
import java.io.Serializable;
import java.text.NumberFormat;

public class ZoomValueSpec
implements Serializable {
    private String uiString;
    public String zoomType;
    public float zoomLevel;
    private static final String FixedZoom_K = "FixedZoom";
    public static final ZoomValueSpec[] zoomValuesTable = new ZoomValueSpec[]{new ZoomValueSpec("800", 8.0), new ZoomValueSpec("400", 4.0), new ZoomValueSpec("200", 2.0), new ZoomValueSpec("150", 1.5), new ZoomValueSpec("125", 1.25), new ZoomValueSpec("100", 1.0), new ZoomValueSpec("75", 0.75), new ZoomValueSpec("67", 0.6666666666666666), new ZoomValueSpec("50", 0.5), new ZoomValueSpec("33", 0.3333333333333333), new ZoomValueSpec("25", 0.25), new ZoomValueSpec("12", 0.125), new ZoomValueSpec("8", 0.08333333333333333), null, new ZoomValueSpec("Zoom:FitPage", "FitPage"), new ZoomValueSpec("Zoom:FitWidth", "FitWidth")};

    public ZoomValueSpec(double d) {
        this(String.valueOf(Math.round(d * 100.0)), FixedZoom_K, d);
    }

    public ZoomValueSpec(String string) {
        this.zoomLevel = 1.0f;
        this.zoomType = string;
        this.uiString = string.equals("FitPage") ? "Zoom:FitPage" : (string.equals("FitWidth") ? "Zoom:FitWidth" : (string.equals("FitVisibleWidth") ? "Zoom:FitVisibleWidth" : (string.equals("FitHeight") ? "Zoom:FitHeight" : (string.equals("FitVisibleHeight") ? "Zoom:FitVisibleHeight" : (string.equals("FitVisible") ? "Zoom:FitVisible" : "100")))));
    }

    private ZoomValueSpec(String string, double d) {
        this(string, FixedZoom_K, d);
    }

    private ZoomValueSpec(String string, String string2) {
        this(string, string2, 1.0);
    }

    public ZoomValueSpec(String string, String string2, double d) {
        this.uiString = string;
        this.zoomType = string2;
        this.zoomLevel = (float)d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ZoomValueSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ZoomValueSpec zoomValueSpec = (ZoomValueSpec)object;
        if (!zoomValueSpec.zoomType.equals(this.zoomType)) {
            return false;
        }
        return !this.zoomType.equals(FixedZoom_K) || zoomValueSpec.zoomLevel != this.zoomLevel;
    }

    public static String formatZoomLevel(float f, boolean bl) {
        if (bl) {
            NumberFormat numberFormat = NumberFormat.getPercentInstance();
            numberFormat.setMinimumIntegerDigits(1);
            numberFormat.setMaximumIntegerDigits(4);
            numberFormat.setMaximumFractionDigits(0);
            return numberFormat.format((double)Math.round(f * 100.0f) * 0.01);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(4);
        numberFormat.setMaximumFractionDigits(0);
        return numberFormat.format(Math.round(100.0f * f));
    }

    public String getMenuItemString() {
        return this.uiString;
    }

    public String getUIString(boolean bl) {
        return !this.zoomType.equals(FixedZoom_K) ? Util.getDialogString(this.uiString) : ZoomValueSpec.formatZoomLevel(this.zoomLevel, bl);
    }

    public static final ZoomValueSpec validateSpec(String string, boolean bl) throws Exception {
        int n = zoomValuesTable.length;
        while (n-- > 0) {
            ZoomValueSpec zoomValueSpec = zoomValuesTable[n];
            if (zoomValueSpec == null || !zoomValueSpec.getUIString(bl).equals(string)) continue;
            return zoomValueSpec;
        }
        double d = NumberFormat.getNumberInstance().parse(string).doubleValue();
        if ((d /= 100.0) < (double)PageView.kMinimumZoom || d > (double)PageView.kMaximumZoom) {
            throw new NumberFormatException();
        }
        return new ZoomValueSpec(d);
    }
}

