/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui.tree;

import com.adobe.acrobat.gui.tree.Tree;
import com.adobe.acrobat.gui.tree.TreeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;

public class TreeLayoutManager
implements LayoutManager {
    private Tree tree;
    private Vector children;
    private Dimension minSize;
    private Dimension prefSize;

    public TreeLayoutManager(Tree tree) {
        this.tree = tree;
        this.children = new Vector();
        this.minSize = new Dimension();
        this.prefSize = new Dimension();
    }

    public void addLayoutComponent(String string, Component component) {
        this.children.addElement(component);
    }

    public void layoutContainer(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.children.size()) {
            TreeNode treeNode = (TreeNode)container.getComponent(n3);
            Dimension dimension = treeNode.getPreferredSize();
            int n4 = n3 * dimension.height;
            treeNode.setBounds(0, n4, dimension.width, dimension.height);
            n += dimension.height;
            n2 = Math.max(n2, dimension.width);
            ++n3;
        }
        this.prefSize.setSize(n2, n);
        this.minSize.setSize(n2, n);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.minSize;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.prefSize;
    }

    public void removeLayoutComponent(Component component) {
        this.children.removeElement(component);
    }
}

