/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.PSCalculatorOperator;
import com.adobe.util.MemUtil;

public class PSCalculatorStack {
    public static final int PSboolean = 1;
    public static final int PSinteger = 2;
    public static final int PSnumber = 3;
    public static final int PSsubroutine = 4;
    public static final int stackMax = 100;
    int[] operandType = MemUtil.allocInt(100);
    int[] intValue = MemUtil.allocInt(100);
    double[] numberValue = MemUtil.allocDouble(100);
    boolean[] booleanValue = new boolean[100];
    PSCalculatorOperator[] subroutineValue = new PSCalculatorOperator[100];
    int top = -1;

    public void checkAccess(int n) throws Exception {
        int n2 = this.top + n;
        if (n2 < 0) {
            throw new Exception("stackunderflow");
        }
        if (n2 >= 100) {
            throw new Exception("stackoverflow");
        }
    }

    public void copy(int n, int n2) {
        int n3 = this.top + n;
        int n4 = this.top + n2;
        this.operandType[n4] = this.operandType[n3];
        this.booleanValue[n4] = this.booleanValue[n3];
        this.intValue[n4] = this.intValue[n3];
        this.numberValue[n4] = this.numberValue[n3];
        this.subroutineValue[n4] = this.subroutineValue[n3];
    }

    public boolean getBooleanValue(int n) throws Exception {
        int n2 = this.top + n;
        if (this.operandType[n2] == 1) {
            return this.booleanValue[n2];
        }
        throw new Exception("typecheck");
    }

    public int getIntValue(int n) throws Exception {
        int n2 = this.top + n;
        if (this.operandType[n2] == 2) {
            return this.intValue[n2];
        }
        throw new Exception("typecheck");
    }

    public double getNumberValue(int n) throws Exception {
        int n2 = this.top + n;
        int n3 = this.operandType[n2];
        if (n3 == 3) {
            return this.numberValue[n2];
        }
        if (n3 == 2) {
            return this.intValue[n2];
        }
        throw new Exception("typecheck");
    }

    public PSCalculatorOperator getSubroutineValue(int n) throws Exception {
        int n2 = this.top + n;
        if (this.operandType[n2] == 4) {
            return this.subroutineValue[n2];
        }
        throw new Exception("typecheck");
    }

    public int getType(int n) {
        return this.operandType[this.top + n];
    }

    public void pop() throws Exception {
        if (this.top-- < 0) {
            throw new Exception("stackunderflow");
        }
    }

    public void pop(int n) throws Exception {
        this.top -= n;
        if (this.top < -1) {
            throw new Exception("stackunderflow");
        }
    }

    public void push() throws Exception {
        if (++this.top >= 100) {
            throw new Exception("stackoverflow");
        }
    }

    public void reset() {
        this.top = -1;
        int n = 0;
        while (n < 100) {
            this.subroutineValue[n] = null;
            ++n;
        }
    }

    public void setBooleanValue(boolean bl) {
        this.operandType[this.top] = 1;
        this.booleanValue[this.top] = bl;
    }

    public void setIntOrNumberValue(double d) throws Exception {
        if (d >= -2.147483648E9 && d <= 2.147483647E9) {
            this.operandType[this.top] = 2;
            this.intValue[this.top] = (int)d;
        } else {
            this.operandType[this.top] = 3;
            this.numberValue[this.top] = d;
            if (d != d) {
                throw new Exception("undefinedresult");
            }
        }
    }

    public void setIntValue(double d) throws Exception {
        if (!(d >= -2.147483648E9) || !(d <= 2.147483647E9)) {
            throw new Exception("rangecheck");
        }
        this.operandType[this.top] = 2;
        this.intValue[this.top] = (int)d;
    }

    public void setIntValue(int n) {
        this.operandType[this.top] = 2;
        this.intValue[this.top] = n;
    }

    public void setNumberValue(double d) throws Exception {
        this.operandType[this.top] = 3;
        this.numberValue[this.top] = d;
        if (d != d) {
            throw new Exception("undefinedresult");
        }
    }

    public void setSubroutineValue(PSCalculatorOperator pSCalculatorOperator) {
        this.operandType[this.top] = 4;
        this.subroutineValue[this.top] = pSCalculatorOperator;
    }

    public int stackSize() {
        return this.top + 1;
    }
}

