/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.Shading;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.GraphicsUtils;
import com.adobe.acrobat.sidecar.MultiPath;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.acrobat.util.Log;
import com.adobe.util.MemUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class Pattern
implements Cloneable {
    public static final int TILING = 1;
    public static final int SHADING = 2;
    public static final int COLORED = 1;
    public static final int UNCOLORED = 2;
    private static final int CONSTANT = 1;
    private static final int NoDISTORTION = 2;
    private static final int FASTER = 3;
    private int patternType;
    private AffineTransform matrix;
    private GState gState;
    private FloatRect bBox;
    private int tilingType;
    private float xStep;
    private float yStep;
    private ContentArray content;
    private SidecarImage tile;
    private AffineTransform toDev;
    private FloatPoint stepInX;
    private FloatPoint stepInY;
    private Shading shade;

    protected Pattern() {
    }

    public Pattern(int n, int n2, float f, float f2, FloatRect floatRect, AffineTransform affineTransform, GState gState, ContentArray contentArray) {
        this.patternType = 1;
        this.tilingType = n2;
        this.xStep = (float)Math.abs(f != 0.0f ? (double)f : floatRect.width());
        this.yStep = (float)Math.abs(f2 != 0.0f ? (double)f2 : floatRect.height());
        this.bBox = floatRect;
        this.matrix = affineTransform;
        this.gState = gState;
        this.content = contentArray;
        this.tile = null;
        this.toDev = null;
        if (affineTransform == null) {
            affineTransform = AffineTransform.getIdentityMatrix();
        }
    }

    public Pattern(Shading shading, AffineTransform affineTransform, GState gState) {
        this.patternType = 2;
        this.shade = shading;
        this.matrix = affineTransform;
        this.gState = gState;
    }

    public FloatRect getBBox() {
        return this.bBox;
    }

    public ContentArray getContentArray() {
        return this.content;
    }

    private void getTile(AffineTransform affineTransform) throws Exception {
        ClipShape clipShape;
        Cloneable cloneable;
        if (this.tile != null && affineTransform.equals(this.toDev)) {
            return;
        }
        this.tile = null;
        PolygonADV polygonADV = new PolygonADV(this.bBox);
        polygonADV.transform(affineTransform);
        FloatRect floatRect = polygonADV.getBoundingBox();
        double d = floatRect.getxMin();
        double d2 = floatRect.getyMin();
        double d3 = floatRect.getxMax();
        double d4 = floatRect.getyMax();
        switch (this.tilingType) {
            case 1: 
            case 3: {
                affineTransform = affineTransform.translate(-d, -d2);
                affineTransform = affineTransform.scale((double)Math.round(d3 - d) / (d3 - d), (double)Math.round(d4 - d2) / (d4 - d2));
                affineTransform = affineTransform.translate(Math.round(d), Math.round(d2));
                cloneable = affineTransform.translate(-affineTransform.getx(), -affineTransform.gety());
                this.stepInX = new FloatPoint(this.xStep, 0.0).deltaTransform((AffineTransform)cloneable);
                this.stepInX.x = Math.round(this.stepInX.x);
                this.stepInX.y = Math.round(this.stepInX.y);
                this.stepInY = new FloatPoint(0.0, this.yStep).deltaTransform((AffineTransform)cloneable);
                this.stepInY.x = Math.round(this.stepInY.x);
                this.stepInY.y = Math.round(this.stepInY.y);
                break;
            }
            case 2: {
                affineTransform = affineTransform.translate((double)Math.round(d) - d, (double)Math.round(d2) - d2);
                cloneable = affineTransform.translate(-affineTransform.getx(), -affineTransform.gety());
                this.stepInX = new FloatPoint(this.xStep, 0.0).deltaTransform((AffineTransform)cloneable);
                this.stepInY = new FloatPoint(0.0, this.yStep).deltaTransform((AffineTransform)cloneable);
                break;
            }
        }
        this.toDev = affineTransform;
        polygonADV = new PolygonADV(this.bBox);
        polygonADV.transform(affineTransform);
        floatRect = polygonADV.getBoundingBox();
        cloneable = floatRect.toRect();
        if (polygonADV.isRectangular()) {
            clipShape = new ClipShape((Rectangle)cloneable, null);
        } else {
            clipShape = new ClipShape(null);
            clipShape.setClip(new MultiPath(polygonADV, 2));
        }
        AWTGraphics aWTGraphics = null;
        try {
            try {
                this.tile = this.tilingType == 2 ? (SidecarImage)GraphicsUtils.createClipImage(cloneable.width, cloneable.height) : (SidecarImage)GraphicsUtils.createImage(cloneable.width, cloneable.height);
                this.tile.setOrigin(cloneable.x, cloneable.y);
                aWTGraphics = new AWTGraphics(this.tile);
                DrawContext drawContext = new DrawContext(aWTGraphics, this.toDev, clipShape);
                this.content.draw(drawContext);
            }
            catch (Exception exception) {
                Log.logStackTrace(exception);
            }
            Object var18_13 = null;
            if (aWTGraphics != null) {
                aWTGraphics.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var18_14 = null;
            if (aWTGraphics != null) {
                aWTGraphics.dispose();
            }
            throw throwable;
        }
    }

    public AffineTransform getTransform() {
        return this.matrix;
    }

    public boolean isUncolored() {
        return this.patternType == 1 && this.tilingType == 2;
    }

    public SidecarImage patternImage(ColorValue colorValue, AffineTransform affineTransform, Rectangle rectangle) throws Exception {
        AffineTransform affineTransform2 = this.matrix.appendTransform(affineTransform);
        if (this.patternType == 2) {
            return this.shade.shadingImage(affineTransform2, rectangle);
        }
        this.getTile(affineTransform2);
        if (this.tile != null) {
            SidecarImage sidecarImage;
            Object object;
            int n = rectangle.width;
            int n2 = rectangle.height;
            if (this.patternType == 2) {
                object = MemUtil.allocByte(n * n2);
                sidecarImage = new SidecarImage(n, n2, (ColorModel)this.tile.getColorModel(), (byte[])object, 0, n);
            } else {
                object = MemUtil.allocInt(n * n2);
                sidecarImage = new SidecarImage(n, n2, (ColorModel)this.tile.getColorModel(), (int[])object, 0, n);
            }
            sidecarImage.erase();
            sidecarImage.setOrigin(rectangle.x, rectangle.y);
            object = this.toDev.getInverse();
            FloatRect floatRect = new FloatRect(rectangle).transformRect((AffineTransform)object);
            int n3 = (int)Math.floor((floatRect.getxMin() - this.bBox.getxMax()) / (double)this.xStep);
            int n4 = (int)Math.ceil((floatRect.getxMax() - this.bBox.getxMin()) / (double)this.xStep);
            int n5 = (int)Math.floor((floatRect.getyMin() - this.bBox.getyMax()) / (double)this.yStep);
            int n6 = (int)Math.ceil((floatRect.getyMax() - this.bBox.getyMin()) / (double)this.yStep);
            Point point = this.tile.getOrigin();
            int n7 = n3;
            while (n7 < n4) {
                int n8 = n5;
                while (n8 < n6) {
                    sidecarImage.insertTile(this.tile, point.x + (int)((double)n7 * this.stepInX.x + (double)n8 * this.stepInY.x + 0.5), point.y + (int)((double)n7 * this.stepInX.y + (double)n8 * this.stepInY.y + 0.5));
                    ++n8;
                }
                ++n7;
            }
            return sidecarImage;
        }
        return null;
    }
}

