/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.pdf.TextRun;
import com.adobe.acrobat.pdf.Wordafier;
import com.adobe.acrobat.pdf.WordyReader;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.EncodingVector;
import com.adobe.acrobat.sidecar.FastHash;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.UnicodeTransliterater;
import com.adobe.pe.util.ReaderFactory;
import com.adobe.util.MemUtil;
import java.awt.Point;
import java.io.Reader;
import java.util.Vector;

public class Wordy {
    public static final char ZeroWidthNoBreakSpace = '\ufeff';
    private static FastHash ligatureTable = null;
    private static final String[] SuffixList = new String[]{"superior", "inferior", "small", "centered", "oldstyle", "left", "right", "base", "swash", "alt", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "slash", "periodcentered"};
    static FastHash charReduction = null;
    Wordafier wordafier;
    ReaderFactory readerFactory;
    Vector wordList;
    private int length;
    StringBuffer strBuf;
    StringBuffer lowerStrBuf;

    public Wordy(Wordafier wordafier) throws Exception {
        Object object;
        this.wordafier = wordafier;
        Wordy.initCharReduction();
        this.wordList = new Vector(100, 100);
        wordafier.resetWordafier();
        while ((object = wordafier.nextRun()) != null) {
            this.wordList.addElement(new TextRun(object));
        }
        this.strBuf = null;
        this.lowerStrBuf = null;
        this.readerFactory = null;
        this.getTextBuffer();
        this.length = this.strBuf.length();
    }

    private void addHighlight(BezierPath bezierPath, int n, int n2, int n3) {
        TextRun textRun;
        FloatRect floatRect;
        if (n2 <= n3 && (floatRect = this.runBBox(textRun = (TextRun)this.wordList.elementAt(n), n2, n3)) != null && !floatRect.isEmpty()) {
            double d = floatRect.getxMin();
            double d2 = floatRect.getxMax();
            double d3 = floatRect.getyMin();
            double d4 = floatRect.getyMax();
            if (d < d2 && d3 < d4) {
                FloatPoint floatPoint = new FloatPoint(d, d4);
                FloatPoint floatPoint2 = new FloatPoint(d2, d4);
                FloatPoint floatPoint3 = new FloatPoint(d2, d3);
                FloatPoint floatPoint4 = new FloatPoint(d, d3);
                AffineTransform affineTransform = this.wordafier.getCtm(textRun.runObject);
                affineTransform.transformPoint(floatPoint);
                affineTransform.transformPoint(floatPoint2);
                affineTransform.transformPoint(floatPoint3);
                affineTransform.transformPoint(floatPoint4);
                bezierPath.moveTo(floatPoint.x, floatPoint.y);
                bezierPath.lineTo(floatPoint2.x, floatPoint2.y);
                bezierPath.lineTo(floatPoint3.x, floatPoint3.y);
                bezierPath.lineTo(floatPoint4.x, floatPoint4.y);
                bezierPath.closePath();
            }
        }
    }

    private void buildBuffer() throws Exception {
        String string;
        int n = 0;
        int n2 = 0;
        while (n2 < this.wordList.size()) {
            string = this.wordafier.getText(((TextRun)this.wordList.elementAt((int)n2)).runObject);
            n += string.length() + 1;
            ++n2;
        }
        this.strBuf = MemUtil.allocStringBuffer(n);
        TextRun textRun = null;
        PDFFont pDFFont = null;
        int n3 = 0;
        while (n3 < this.wordList.size()) {
            Object object;
            TextRun textRun2 = (TextRun)this.wordList.elementAt(n3);
            string = this.wordafier.getText(textRun2.runObject);
            double[] dArray = this.wordafier.getCharOffsets(textRun2.runObject);
            PDFFont pDFFont2 = this.wordafier.getFont(((TextRun)this.wordList.elementAt((int)n3)).runObject);
            int n4 = pDFFont2.getWMode();
            boolean bl = pDFFont2.isCIDFont();
            double d = this.wordafier.getWordSpacing(textRun2.runObject);
            UnicodeTransliterater unicodeTransliterater = pDFFont2.getUnicodeTransliterater();
            StringBuffer stringBuffer = unicodeTransliterater.transliterateString(string);
            if (this.strBuf.length() > 0 && this.strBuf.charAt(this.strBuf.length() - 1) != '-' && stringBuffer.length() > 0 && n4 == 0 && pDFFont.getWMode() == 0 && !bl && !pDFFont.isCIDFont()) {
                FloatRect floatRect = this.wordafier.getFontBBox(textRun.runObject);
                double[] dArray2 = this.wordafier.getCharOffsets(textRun.runObject);
                floatRect = new FloatRect(floatRect.getxMin() + (dArray2.length > 1 ? dArray2[dArray2.length - 2] / 1000.0 : 0.0), floatRect.getyMin(), dArray2[dArray2.length - 1] / 1000.0 + this.wordafier.getWordSpacing(textRun.runObject) * 0.33 / 1000.0, floatRect.getyMax());
                floatRect = floatRect.transformRect(this.wordafier.getCtm(textRun.runObject));
                object = this.wordafier.getFontBBox(textRun2.runObject);
                object = new FloatRect(((FloatRect)object).getxMin() - d * 0.33 / 1000.0, ((FloatRect)object).getyMin(), dArray[0] / 1000.0, ((FloatRect)object).getyMax());
                if (!floatRect.overlap((FloatRect)(object = ((FloatRect)object).transformRect(this.wordafier.getCtm(textRun2.runObject))))) {
                    this.strBuf.append('\ufeff');
                }
            }
            textRun2.index = this.strBuf.length();
            if (textRun != null) {
                textRun.length = textRun2.index - textRun.index;
            }
            d *= 0.66;
            MemUtil.ensureStringBufferCapacity(this.strBuf, this.strBuf.length() + stringBuffer.length());
            int n5 = 0;
            while (n5 < stringBuffer.length()) {
                char c = stringBuffer.charAt(n5);
                object = Wordy.expandLigature(c);
                if (object != null) {
                    this.strBuf.append((String)object);
                } else {
                    this.strBuf.append(c);
                }
                if (!bl && n4 == 0) {
                    double d2 = pDFFont2.getLogicalCharWidth(null, c);
                    d2 = n5 == 0 ? dArray[0] - d2 : dArray[n5] - dArray[n5 - 1] - d2;
                    if (d2 >= d) {
                        this.strBuf.append('\ufeff');
                    }
                }
                ++n5;
            }
            textRun = textRun2;
            pDFFont = pDFFont2;
            ++n3;
        }
        if (textRun != null) {
            textRun.length = this.strBuf.length() - textRun.index;
        }
    }

    private static String expandLigature(char c) {
        if (ligatureTable == null) {
            Wordy.initLigatureTable();
        }
        return (String)ligatureTable.getObject(c);
    }

    public int findCharAt(FloatPoint floatPoint) {
        int n = -1;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = this.wordList.size();
        while (n2-- > 0) {
            try {
                TextRun textRun = (TextRun)this.wordList.elementAt(n2);
                FloatRect floatRect = this.runBBox(textRun, 0, Integer.MAX_VALUE);
                FloatPoint floatPoint2 = new FloatPoint();
                if (floatRect == null || floatRect.isEmpty()) continue;
                AffineTransform affineTransform = this.wordafier.getCtm(textRun.runObject);
                AffineTransform affineTransform2 = affineTransform.getInverse();
                affineTransform2.transformPoint(floatPoint, floatPoint2);
                if (floatRect.ptInRect(floatPoint2)) {
                    int n3;
                    int n4 = n3 = this.wordafier.getText(textRun.runObject).length();
                    while (n4-- > 1) {
                        floatRect = this.runBBox(textRun, n4, n4);
                        if (!floatRect.ptInRect(floatPoint2)) continue;
                        return this.runIndexToWordyCharacter(textRun, n4);
                    }
                    return this.runIndexToWordyCharacter(textRun, 0);
                }
                double d3 = (floatRect = floatRect.transformRect(affineTransform)).getxMin() - floatPoint.x;
                if (!(d3 >= 0.0)) continue;
                double d4 = floatPoint.y - floatRect.getyMax();
                if (d4 <= 0.0) {
                    if (!(floatPoint.y > floatRect.getyMin()) || n >= 0 && !(d3 < d2)) continue;
                    n = this.runIndexToWordyCharacter(textRun, 0);
                    d2 = d3;
                    d = 0.0;
                    continue;
                }
                if (n >= 0 && !(d4 < d) && (d4 != d || !(d3 < d2))) continue;
                n = this.runIndexToWordyCharacter(textRun, 0);
                d2 = d3;
                d = d4;
            }
            catch (AffineException affineException) {}
        }
        if (n < 0) {
            return this.getLength();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public Point findString(String var1_1, int var2_2, int var3_3, boolean var4_4, boolean var5_5) {
        block31: {
            block30: {
                var9_6 = var5_5 != false ? this.getTextBuffer() : this.getLowerTextBuffer();
                var10_7 = MemUtil.allocStringBuffer(var1_1.length());
                var10_7.append(var1_1);
                var6_8 = 0;
                var7_9 = 0;
                while (var7_9 < var10_7.length()) {
                    block29: {
                        block28: {
                            var11_10 = var10_7.charAt(var7_9);
                            if (!Character.isISOControl(var11_10) && !Character.isWhitespace(var11_10)) break block28;
                            var11_10 = ' ';
                            if (var6_8 == 0 || var10_7.charAt(var6_8 - 1) == ' ') break block29;
                        }
                        var10_7.setCharAt(var6_8++, var11_10);
                    }
                    ++var7_9;
                }
                while (var6_8 > 0 && var10_7.charAt(var6_8 - 1) == ' ') {
                    --var6_8;
                }
                if (var6_8 == 0) {
                    return null;
                }
                var10_7.setLength(var6_8);
                if (!var5_5) {
                    var10_7 = this.reduceStringBuffer(var10_7);
                }
                var11_10 = var9_6.length();
                var12_11 = var10_7.length();
                var13_12 = new int[var12_11];
                var14_13 = var11_10 - var12_11;
                v0 = var16_14 = var2_2 <= var3_3;
                if (var16_14) break block30;
                var2_2 = Math.min(var14_13, var2_2);
                var3_3 = Math.max(0, var3_3);
                var6_8 = var12_11;
                while (var6_8-- > 0) {
                    var17_15 = var10_7.charAt(var6_8);
                    var7_9 = var6_8 + 1;
                    while (var7_9 < var12_11 && var17_15 != var10_7.charAt(var7_9)) {
                        ++var7_9;
                    }
                    var13_12[var6_8] = 1 + var6_8 - var7_9;
                }
                var6_8 = var2_2;
                while (var6_8 >= var3_3) {
                    var15_17 = 0;
                    var7_9 = var12_11;
                    while (var7_9-- > 0) {
                        var17_15 = var9_6.charAt(var6_8 + var7_9);
                        var18_19 = var10_7.charAt(var7_9);
                        if (var17_15 == '\ufeff' || Character.isWhitespace(var17_15) || Character.isISOControl(var17_15)) {
                            var17_15 = ' ';
                        }
                        if (var17_15 != var18_19) {
                            if (var6_8 > var3_3 && var7_9 != 0 && var7_9 != var12_11 - 1 && var17_15 == '-' && var9_6.charAt(var6_8 + var7_9 - 1) == var18_19 && Character.isLetterOrDigit(var9_6.charAt(var6_8 + var7_9 + 1)) && Character.isLetterOrDigit(var9_6.charAt(var6_8 + var7_9 - 1))) {
                                --var6_8;
                                ++var15_17;
                                continue;
                            }
                            if (var17_15 == ' ' && var7_9 < var12_11 - 1 && var10_7.charAt(var7_9 + 1) == ' ') {
                                --var6_8;
                                ++var15_17;
                            } else {
                                var6_8 += var13_12[var7_9];
                                break;
                            }
                        }
                        if (var7_9 != 0) continue;
                        if (!var4_4 || Wordy.testWholeWord(var9_6, var6_8, var6_8 + var12_11 + var15_17 - 1)) {
                            return new Point(var6_8, var12_11 + var15_17);
                        }
                        var6_8 += var13_12[var7_9];
                        break;
                    }
                    --var6_8;
                }
                break block31;
            }
            var2_2 = Math.max(0, var2_2);
            var3_3 = Math.min(var14_13, var3_3);
            var6_8 = 0;
            while (var6_8 < var12_11) {
                var17_16 = var10_7.charAt(var6_8);
                var7_9 = var6_8 - 1;
                while (var7_9 >= 0 && var17_16 != var10_7.charAt(var7_9)) {
                    --var7_9;
                }
                var13_12[var6_8] = var6_8 - var7_9 - 1;
                ++var6_8;
            }
            var6_8 = var2_2;
            while (var6_8 <= var3_3) {
                var15_18 = 0;
                var7_9 = 0;
                while (var7_9 < var12_11) {
                    var17_16 = var9_6.charAt(var6_8 + var7_9);
                    var18_20 = var10_7.charAt(var7_9);
                    if (var17_16 == '\ufeff' || Character.isWhitespace(var17_16) || Character.isISOControl(var17_16)) {
                        var17_16 = ' ';
                    }
                    if (var17_16 == var18_20) ** GOTO lbl103
                    if (var6_8 < var3_3 && var7_9 != 0 && var7_9 != var12_11 - 1 && var17_16 == '-' && var9_6.charAt(var6_8 + var7_9 + 1) == var18_20 && Character.isLetterOrDigit(var9_6.charAt(var6_8 + var7_9 + 1)) && Character.isLetterOrDigit(var9_6.charAt(var6_8 + var7_9 - 1))) {
                        ++var6_8;
                        ++var15_18;
                    } else if (var17_16 == ' ' && var7_9 > 0 && var10_7.charAt(var7_9 - 1) == ' ') {
                        ++var6_8;
                        ++var15_18;
                    } else {
                        var6_8 += var13_12[var7_9];
                        break;
lbl103:
                        // 1 sources

                        if (var7_9 == var12_11 - 1) {
                            if (!var4_4 || Wordy.testWholeWord(var9_6, var6_8 - var15_18, var6_8 + var12_11 - 1)) {
                                return new Point(var6_8 - var15_18, var12_11 + var15_18);
                            }
                            var6_8 += var13_12[var7_9];
                            break;
                        }
                    }
                    ++var7_9;
                }
                ++var6_8;
            }
        }
        return null;
    }

    public StringBuffer getAnyTextBuffer() {
        StringBuffer stringBuffer = this.lowerStrBuf;
        if (stringBuffer == null) {
            stringBuffer = this.strBuf;
        }
        if (stringBuffer == null) {
            stringBuffer = this.getTextBuffer();
        }
        return stringBuffer;
    }

    public int getLength() {
        return this.length;
    }

    public StringBuffer getLowerTextBuffer() {
        if (this.lowerStrBuf == null) {
            this.lowerStrBuf = this.reduceStringBuffer(this.getTextBuffer());
            this.strBuf = null;
        }
        return this.lowerStrBuf;
    }

    public BezierPath getPageHighlight(int n, int n2) {
        boolean bl = false;
        int n3 = this.runForCharacter(n);
        int n4 = this.wordyCharacterToRunIndex(n3, n);
        int n5 = n + n2 - 1;
        if (n5 >= this.getLength()) {
            n5 = this.getLength() - 1;
        }
        int n6 = this.runForCharacter(n5);
        int n7 = this.wordyCharacterToRunIndex(n6, n5);
        BezierPath bezierPath = new BezierPath(30);
        bezierPath.setWinding();
        int n8 = n4;
        while (n3 < n6) {
            this.addHighlight(bezierPath, n3++, n8, Integer.MAX_VALUE);
            n8 = 0;
        }
        if (n3 == n6) {
            this.addHighlight(bezierPath, n3, n8, n7);
        }
        return bezierPath;
    }

    public ReaderFactory getReaderFactory() {
        if (this.readerFactory == null) {
            this.readerFactory = new WordyReaderFactory();
        }
        return this.readerFactory;
    }

    public String getSubstring(int n, int n2) {
        int n3 = Math.min(this.getLength() - n, n2);
        if (n3 > 0) {
            char[] cArray = new char[n3];
            this.getTextBuffer().getChars(n, n + n3, cArray, 0);
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray[n4];
                if (c == '\ufeff' || Character.isISOControl(c) || Character.isWhitespace(c)) {
                    cArray[n4] = 32;
                }
                ++n4;
            }
            return new String(cArray);
        }
        return "";
    }

    public synchronized StringBuffer getTextBuffer() {
        block2: {
            if (this.strBuf != null) break block2;
            try {
                this.buildBuffer();
            }
            catch (Exception exception) {
                this.strBuf = new StringBuffer();
            }
        }
        return this.strBuf;
    }

    private static void initCharReduction() {
        if (charReduction == null) {
            charReduction = FastHash.newIntIntHash(50);
            FastHash fastHash = EncodingVector.hostGlyphs;
            int n = fastHash.size();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String string = (String)fastHash.getObjectKeyByIndex(n2);
                int n4 = fastHash.getInt(string);
                if (n4 != (n3 = Wordy.reduceOneGlyph(string)) && n3 != 0) {
                    charReduction.put(n4, n3);
                }
                ++n2;
            }
            charReduction.put(fastHash.getInt("quoteleft"), 39);
            charReduction.put(fastHash.getInt("quoteright"), 39);
            charReduction.put(fastHash.getInt("quotesinglbase"), 39);
        }
    }

    private static void initLigatureTable() {
        if (ligatureTable == null) {
            ligatureTable = FastHash.newIntObjectHash(43);
            ligatureTable.put(64256, (Object)"ff");
            ligatureTable.put(64257, (Object)"fi");
            ligatureTable.put(64258, (Object)"fl");
            ligatureTable.put(64259, (Object)"ffi");
            ligatureTable.put(64260, (Object)"ffl");
            ligatureTable.put(61014, (Object)"ff");
            ligatureTable.put(61017, (Object)"ffi");
            ligatureTable.put(61018, (Object)"ffl");
            ligatureTable.put(198, (Object)"AE");
            ligatureTable.put(230, (Object)"ae");
            ligatureTable.put(482, (Object)"AE");
            ligatureTable.put(483, (Object)"ae");
            ligatureTable.put(508, (Object)"AE");
            ligatureTable.put(509, (Object)"ae");
            ligatureTable.put(306, (Object)"IJ");
            ligatureTable.put(307, (Object)"ij");
            ligatureTable.put(338, (Object)"OE");
            ligatureTable.put(339, (Object)"oe");
            ligatureTable.put(630, (Object)"OE");
            ligatureTable.put(418, (Object)"OI");
            ligatureTable.put(419, (Object)"oi");
            ligatureTable.put(223, (Object)"ss");
            ligatureTable.put(329, (Object)"'n");
            ligatureTable.put(405, (Object)"hv");
            ligatureTable.put(422, (Object)"yr");
            ligatureTable.put(452, (Object)"DZ");
            ligatureTable.put(453, (Object)"Dz");
            ligatureTable.put(454, (Object)"dz");
            ligatureTable.put(497, (Object)"DZ");
            ligatureTable.put(498, (Object)"Dz");
            ligatureTable.put(499, (Object)"dz");
            ligatureTable.put(675, (Object)"dz");
            ligatureTable.put(677, (Object)"dz");
            ligatureTable.put(678, (Object)"ts");
            ligatureTable.put(680, (Object)"tc");
            ligatureTable.put(455, (Object)"LJ");
            ligatureTable.put(456, (Object)"Lj");
            ligatureTable.put(456, (Object)"lj");
            ligatureTable.put(458, (Object)"Nj");
            ligatureTable.put(459, (Object)"Nj");
            ligatureTable.put(460, (Object)"nj");
            ligatureTable.put(64261, (Object)"Sst");
            ligatureTable.put(64262, (Object)"sst");
        }
    }

    public static boolean isBreakCharacter(char c) {
        return Character.isLetterOrDigit(c) ^ true;
    }

    private static int reduceOneGlyph(String string) {
        FastHash fastHash = EncodingVector.hostGlyphs;
        int n = string.length();
        int n2 = -1;
        int n3 = SuffixList.length;
        while (n3-- > 0) {
            String string2 = SuffixList[n3];
            int n4 = string2.length();
            if (n4 >= n || !string.endsWith(string2)) continue;
            n2 = Wordy.reduceOneGlyph(string.substring(0, n - n4));
            if (n2 < 0) break;
            return n2;
        }
        n2 = fastHash.getInt(string.toLowerCase());
        if (!fastHash.wasFound()) {
            n2 = fastHash.getInt(string);
            if (!fastHash.wasFound()) {
                n2 = -1;
            }
        }
        return n2;
    }

    private StringBuffer reduceStringBuffer(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            int n = stringBuffer.length();
            while (n-- > 0) {
                char c = stringBuffer.charAt(n);
                if (charReduction.contains(c)) {
                    c = (char)charReduction.getInt(c);
                }
                stringBuffer.setCharAt(n, Character.toLowerCase(c));
            }
        }
        return stringBuffer;
    }

    public FloatRect runBBox(TextRun textRun, int n, int n2) {
        double d;
        double d2;
        FloatRect floatRect = this.wordafier.getFontBBox(textRun.runObject);
        PDFFont pDFFont = this.wordafier.getFont(textRun.runObject);
        double[] dArray = this.wordafier.getCharOffsets(textRun.runObject);
        String string = this.wordafier.getText(textRun.runObject);
        if (n < 0) {
            n = 0;
        }
        if (n2 >= string.length()) {
            n2 = string.length() - 1;
        }
        if (n > n2) {
            return null;
        }
        double d3 = floatRect.getxMin();
        double d4 = floatRect.getyMin();
        if (pDFFont.isCIDFont()) {
            if (pDFFont.getwMode() == 1) {
                if (n > 0) {
                    d4 += dArray[4 * (n - 1) + 1] / 1000.0;
                }
            } else if (n > 0) {
                d3 += dArray[4 * (n - 1)] / 1000.0;
            }
        } else if (n > 0) {
            d3 += dArray[n - 1] / 1000.0;
        }
        if (pDFFont.isCIDFont()) {
            if (pDFFont.getwMode() == 1) {
                d2 = floatRect.getxMax();
                d = floatRect.getyMin() + dArray[4 * n2 + 1] / 1000.0;
            } else {
                d2 = floatRect.getxMin() + dArray[4 * n2] / 1000.0;
                d = floatRect.getyMax();
            }
        } else {
            d2 = floatRect.getxMin() + dArray[n2] / 1000.0;
            d = floatRect.getyMax();
        }
        return new FloatRect(d3, d4, d2, d);
    }

    int runForCharacter(int n) {
        int n2 = this.wordList.size() - 1;
        int n3 = 0;
        while (n2 >= n3) {
            int n4 = n3 + n2 >> 1;
            TextRun textRun = (TextRun)this.wordList.elementAt(n4);
            if (n < textRun.index) {
                n2 = n4 - 1;
                continue;
            }
            if (n >= textRun.index + textRun.length) {
                n3 = n4 + 1;
                continue;
            }
            return n4;
        }
        return this.wordList.size() - 1;
    }

    /*
     * Unable to fully structure code
     */
    int runIndexToWordyCharacter(TextRun var1_1, int var2_2) {
        var3_3 = this.getAnyTextBuffer();
        var4_4 = this.wordafier.getText(var1_1.runObject);
        var5_5 = 0;
        var6_6 = var1_1.index;
        ** GOTO lbl13
        {
            ++var6_6;
            do {
                if (var3_3.charAt(var6_6) == '\ufeff') continue block0;
                if ((var8_8 = Wordy.expandLigature(var7_7 = var4_4.charAt(var5_5++))) != null) {
                    var6_6 += var8_8.length();
                    continue;
                }
                ++var6_6;
lbl13:
                // 3 sources

            } while (var2_2-- > 0);
        }
        while (var6_6 < this.getLength() && var3_3.charAt(var6_6) == '\ufeff') {
            ++var6_6;
        }
        return var6_6;
    }

    private static boolean testWholeWord(StringBuffer stringBuffer, int n, int n2) {
        boolean bl = true;
        if (n > 0) {
            bl = Wordy.isBreakCharacter(stringBuffer.charAt(n - 1));
        }
        if (bl && n2 + 1 < stringBuffer.length()) {
            bl = Wordy.isBreakCharacter(stringBuffer.charAt(n2 + 1));
        }
        return bl;
    }

    int wordyCharacterToRunIndex(int n, int n2) {
        TextRun textRun = (TextRun)this.wordList.elementAt(n);
        StringBuffer stringBuffer = this.getAnyTextBuffer();
        String string = this.wordafier.getText(textRun.runObject);
        int n3 = 0;
        int n4 = textRun.index;
        while (n4 < n2 && n3 < string.length()) {
            char c;
            String string2;
            if (stringBuffer.charAt(n4) == '\ufeff') {
                ++n4;
                continue;
            }
            if ((string2 = Wordy.expandLigature(c = string.charAt(n3++))) != null) {
                n4 += string2.length();
                continue;
            }
            ++n4;
        }
        if (n4 > n2) {
            --n3;
        }
        if (n3 > string.length()) {
            n3 = string.length();
        }
        return n3;
    }

    class WordyReaderFactory
    extends ReaderFactory {
        WordyReaderFactory() {
        }

        public Reader getReader() {
            return new WordyReader(Wordy.this);
        }
    }
}

