/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;

public class DeviceRGBColorModel
extends PDFColorModel {
    private byte[] red;
    private byte[] green;
    private byte[] blue;
    private boolean alphaPremultiplied = false;
    public static final PDFColorModel DefaultColorModel = new DeviceRGBColorModel();
    public static final PDFColorModel AlphaPremultipliedColorModel = new DeviceRGBColorModel();

    static {
        ((DeviceRGBColorModel)DeviceRGBColorModel.AlphaPremultipliedColorModel).alphaPremultiplied = true;
    }

    public DeviceRGBColorModel() {
        this(new PDFColorParams(0));
    }

    public DeviceRGBColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        float[] fArray = pDFColorParams.getDecode();
        if (fArray != null && fArray.length >= 6 && (fArray[0] != 0.0f || fArray[1] != 1.0f || fArray[2] != 0.0f || fArray[3] != 1.0f || fArray[4] != 0.0f || fArray[5] != 1.0f)) {
            this.red = MemUtil.allocByte(256);
            float f = fArray[0];
            float f2 = fArray[1] - f;
            int n = 0;
            while (n < 256) {
                this.red[n] = (byte)Math.max(0, Math.min(255, Math.round(f + (float)n * f2)));
                ++n;
            }
            this.green = MemUtil.allocByte(256);
            f = fArray[2];
            f2 = fArray[3] - f;
            int n2 = 0;
            while (n2 < 256) {
                this.green[n2] = (byte)Math.max(0, Math.min(255, Math.round(f + (float)n2 * f2)));
                ++n2;
            }
            this.blue = MemUtil.allocByte(256);
            f = fArray[4];
            f2 = fArray[5] - f;
            int n3 = 0;
            while (n3 < 256) {
                this.blue[n3] = (byte)Math.max(0, Math.min(255, Math.round(f + (float)n3 * f2)));
                ++n3;
            }
        }
    }

    public boolean getAlphaPremultiplied() {
        return this.alphaPremultiplied;
    }

    public float[] getBlack() {
        float[] fArray = new float[3];
        fArray[2] = 0.0f;
        fArray[1] = 0.0f;
        fArray[0] = 0.0f;
        return fArray;
    }

    public ColorModel getJavaColorModel() {
        return ColorModel.getRGBdefault();
    }

    public int getRGB(float f, float f2, float f3) {
        int n = Math.max(0, Math.min(255, Math.round(255.0f * f)));
        int n2 = Math.max(0, Math.min(255, Math.round(255.0f * f2)));
        int n3 = Math.max(0, Math.min(255, Math.round(255.0f * f3)));
        return -16777216 + (n << 16) + (n2 << 8) + n3;
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 3) {
            return this.getRGB(fArray[0], fArray[1], fArray[2]);
        }
        throw new RuntimeException("DeviceRGBColorModel.getRGB(c[]) -- arrayToShort");
    }

    public void toRGB(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int[] nArray2 = this.params.getAlphaMask();
        int n11 = 0;
        while (n11 < n3) {
            n4 = byArray[n] & 0xFF;
            n5 = byArray[n + 1] & 0xFF;
            n6 = byArray[n + 2] & 0xFF;
            n += 3;
            if (n4 == n8 && n5 == n9 && n6 == n10) {
                nArray[n2 + n11] = n7;
            } else if (nArray2 != null && nArray2[0] <= n4 && n4 <= nArray2[1] && nArray2[2] <= n5 && n5 <= nArray2[3] && nArray2[4] <= n6 && n6 <= nArray2[5]) {
                n8 = n4;
                n9 = n5;
                n10 = n6;
                n7 = 0;
                nArray[n2 + n11] = 0;
            } else if (this.red != null) {
                n8 = n4;
                n9 = n5;
                n10 = n6;
                nArray[n2 + n11] = n7 = -16777216 + ((this.red[n4] & 0xFF) << 16) + ((this.green[n5] & 0xFF) << 8) + (this.blue[n6] & 0xFF);
            } else {
                n8 = n4;
                n9 = n5;
                n10 = n6;
                nArray[n2 + n11] = n7 = -16777216 + (n4 << 16) + (n5 << 8) + n6;
            }
            ++n11;
        }
    }

    public String toString() {
        return "DeviceRGB";
    }
}

