/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.Function;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.ListSortable;
import java.awt.Rectangle;
import java.util.Enumeration;

public class ShadeEdge
implements ListSortable,
Cloneable {
    double leftX0;
    double leftXSlope;
    double rightX0;
    double rightXSlope;
    ColorValue leftColor;
    ColorValue rightColor;
    float[] leftColorSlope;
    float[] rightColorSlope;
    FloatRect bbox;
    ShadeEdge next;
    double U;
    double V;

    private ShadeEdge() {
    }

    public ShadeEdge(FloatPoint floatPoint, FloatPoint floatPoint2, FloatPoint floatPoint3, ColorValue colorValue, ColorValue colorValue2, ColorValue colorValue3, double d, double d2, ShadeEdge shadeEdge) {
        ColorValue colorValue4;
        FloatPoint floatPoint4;
        this.U = d;
        this.V = d2;
        this.next = shadeEdge;
        if (floatPoint.y > floatPoint2.y || floatPoint.y == floatPoint2.y && floatPoint.x > floatPoint2.x) {
            floatPoint4 = floatPoint;
            colorValue4 = colorValue;
            floatPoint = floatPoint2;
            colorValue = colorValue2;
            floatPoint2 = floatPoint4;
            colorValue2 = colorValue4;
        }
        if (floatPoint.y > floatPoint3.y || floatPoint.y == floatPoint3.y && floatPoint.x > floatPoint3.x) {
            floatPoint4 = floatPoint;
            colorValue4 = colorValue;
            floatPoint = floatPoint3;
            colorValue = colorValue3;
            floatPoint3 = floatPoint4;
            colorValue3 = colorValue4;
        }
        if (floatPoint2.y > floatPoint3.y || floatPoint2.y == floatPoint3.y && floatPoint2.x > floatPoint3.x) {
            floatPoint4 = floatPoint2;
            colorValue4 = colorValue2;
            floatPoint2 = floatPoint3;
            colorValue2 = colorValue3;
            floatPoint3 = floatPoint4;
            colorValue3 = colorValue4;
        }
        float[] fArray = colorValue.accessColor();
        float[] fArray2 = colorValue2.accessColor();
        float[] fArray3 = colorValue3.accessColor();
        int n = fArray.length;
        this.leftColorSlope = new float[n];
        this.rightColorSlope = new float[n];
        if (floatPoint.y < floatPoint2.y) {
            double d3 = floatPoint.y;
            double d4 = floatPoint2.y;
            this.leftX0 = this.rightX0 = floatPoint.x;
            this.leftColor = this.rightColor = colorValue;
            double d5 = floatPoint2.y - floatPoint.y;
            this.leftXSlope = (float)((floatPoint2.x - floatPoint.x) / d5);
            int n2 = 0;
            while (n2 < n) {
                this.leftColorSlope[n2] = (float)((double)(fArray2[n2] - fArray[n2]) / d5);
                ++n2;
            }
            double d6 = floatPoint3.y - floatPoint.y;
            this.rightXSlope = (float)((floatPoint3.x - floatPoint.x) / d6);
            int n3 = 0;
            while (n3 < n) {
                this.rightColorSlope[n3] = (float)((double)(fArray3[n3] - fArray[n3]) / d6);
                ++n3;
            }
            if (floatPoint2.y < floatPoint3.y) {
                FloatPoint floatPoint5 = new FloatPoint(this.rightX0 + this.rightXSlope * d5, floatPoint2.y);
                float[] fArray4 = new float[n];
                int n4 = 0;
                while (n4 < n) {
                    fArray4[n4] = (float)((double)fArray[n4] + (double)this.rightColorSlope[n4] * d5);
                    ++n4;
                }
                ColorValue colorValue5 = new ColorValue(colorValue);
                colorValue5.setColor(fArray4);
                this.next = new ShadeEdge(floatPoint5, floatPoint2, floatPoint3, colorValue5, colorValue2, colorValue3, d, d2, shadeEdge);
                if (this.leftXSlope > this.rightXSlope) {
                    double d7 = this.leftXSlope;
                    this.leftXSlope = this.rightXSlope;
                    this.rightXSlope = d7;
                    float[] fArray5 = this.leftColorSlope;
                    this.leftColorSlope = this.rightColorSlope;
                    this.rightColorSlope = fArray5;
                }
            }
            double d8 = this.leftXSlope >= 0.0 ? floatPoint.x : floatPoint.x + this.leftXSlope * d5;
            double d9 = this.rightXSlope <= 0.0 ? floatPoint.x : floatPoint.x + this.rightXSlope * d5;
            this.bbox = new FloatRect(d8, d3, d9, d4);
        } else {
            double d10 = floatPoint.y;
            double d11 = floatPoint3.y;
            this.leftX0 = floatPoint.x;
            this.rightX0 = floatPoint2.x;
            this.leftColor = colorValue;
            this.rightColor = colorValue2;
            double d12 = floatPoint3.y - floatPoint.y;
            this.leftXSlope = (float)((floatPoint3.x - floatPoint.x) / d12);
            int n5 = 0;
            while (n5 < n) {
                this.leftColorSlope[n5] = (float)((double)(fArray3[n5] - fArray[n5]) / d12);
                ++n5;
            }
            d12 = floatPoint3.y - floatPoint2.y;
            this.rightXSlope = (float)((floatPoint3.x - floatPoint2.x) / d12);
            int n6 = 0;
            while (n6 < n) {
                this.rightColorSlope[n6] = (float)((double)(fArray3[n6] - fArray2[n6]) / d12);
                ++n6;
            }
            double d13 = Math.min(floatPoint.x, floatPoint2.x);
            double d14 = Math.max(floatPoint2.x, floatPoint3.x);
            this.bbox = new FloatRect(d13, d10, d14, d11);
        }
    }

    public boolean Compare(ListSortable listSortable, ListSortable listSortable2) {
        ShadeEdge shadeEdge = (ShadeEdge)listSortable;
        ShadeEdge shadeEdge2 = (ShadeEdge)listSortable2;
        if (shadeEdge.V != shadeEdge2.V) {
            return shadeEdge.V < shadeEdge2.V;
        }
        return shadeEdge.U < shadeEdge2.U;
    }

    public Rectangle computeBBox() {
        return this.getBoundingBox().toEnclosingRect();
    }

    public static void fillRGBrect(int[] nArray, Rectangle rectangle, Enumeration enumeration, PDFColorModel pDFColorModel, Function[] functionArray) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = n + rectangle.width;
        int n4 = n2 + rectangle.height;
        int n5 = pDFColorModel.getNumComponents();
        int n6 = functionArray == null ? n5 : 1;
        float[] fArray = new float[n6];
        float[] fArray2 = new float[n6];
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[n6];
        float[] fArray5 = new float[n5];
        while (!Thread.interrupted() && enumeration.hasMoreElements()) {
            ShadeEdge shadeEdge = (ShadeEdge)enumeration.nextElement();
            double d = shadeEdge.bbox.getxMin();
            double d2 = shadeEdge.bbox.getyMin();
            double d3 = shadeEdge.bbox.getxMax();
            double d4 = shadeEdge.bbox.getyMax();
            int n7 = Math.max((int)Math.floor(d), n);
            int n8 = Math.max((int)Math.floor(d2), n2);
            int n9 = Math.min((int)Math.ceil(d3), n3);
            int n10 = Math.min((int)Math.ceil(d4), n4);
            if (n10 <= n8 || n9 <= n7) continue;
            float[] fArray6 = shadeEdge.leftColor.accessColor();
            float[] fArray7 = shadeEdge.rightColor.accessColor();
            double d5 = Math.max(0.0, (double)n8 - d2);
            int n11 = (n8 - n2) * rectangle.width;
            double d6 = shadeEdge.leftX0 + d5 * shadeEdge.leftXSlope;
            double d7 = shadeEdge.rightX0 + d5 * shadeEdge.rightXSlope;
            int n12 = 0;
            while (n12 < n6) {
                fArray[n12] = (float)((double)fArray6[n12] + d5 * (double)shadeEdge.leftColorSlope[n12]);
                fArray2[n12] = (float)((double)fArray7[n12] + d5 * (double)shadeEdge.rightColorSlope[n12]);
                ++n12;
            }
            while (n8 < n10) {
                int n13 = Math.max((int)Math.floor(d6), n);
                int n14 = Math.min((int)Math.ceil(d7), n3);
                int n15 = n11 + n13 - n;
                double d8 = d7 - d6;
                double d9 = Math.max(0.0, (double)n13 - d6);
                if (d8 == 0.0) {
                    n12 = 0;
                    while (n12 < n6) {
                        fArray4[n12] = fArray[n12];
                        ++n12;
                    }
                } else {
                    n12 = 0;
                    while (n12 < n6) {
                        fArray3[n12] = (float)((double)(fArray2[n12] - fArray[n12]) / d8);
                        fArray4[n12] = (float)((double)fArray[n12] + d9 * (double)fArray3[n12]);
                        ++n12;
                    }
                }
                while (n13 < n14) {
                    int n16;
                    if (functionArray != null) {
                        if (functionArray.length == 1) {
                            n16 = pDFColorModel.getRGB(functionArray[0].value(fArray4));
                        } else {
                            n12 = 0;
                            while (n12 < n5) {
                                fArray5[n12] = functionArray[n12].value(fArray4)[0];
                                ++n12;
                            }
                            n16 = pDFColorModel.getRGB(fArray5);
                        }
                    } else {
                        n16 = pDFColorModel.getRGB(fArray4);
                    }
                    nArray[n15++] = n16;
                    if ((double)n13 < d6) {
                        d9 = (double)n13 - d6;
                        n12 = 0;
                        while (n12 < n6) {
                            fArray4[n12] = (float)((double)fArray[n12] + d9 * (double)fArray3[n12]);
                            ++n12;
                        }
                    }
                    if (++n13 >= n14) continue;
                    n12 = 0;
                    while (n12 < n6) {
                        int n17 = n12;
                        fArray4[n17] = fArray4[n17] + fArray3[n12];
                        ++n12;
                    }
                }
                if ((double)n8 < d2) {
                    d5 = (double)n8 - d2;
                    d6 = shadeEdge.leftX0 + d5 * shadeEdge.leftXSlope;
                    d7 = shadeEdge.rightX0 + d5 * shadeEdge.rightXSlope;
                    n12 = 0;
                    while (n12 < n6) {
                        fArray[n12] = (float)((double)fArray6[n12] + d5 * (double)shadeEdge.leftColorSlope[n12]);
                        fArray2[n12] = (float)((double)fArray7[n12] + d5 * (double)shadeEdge.rightColorSlope[n12]);
                        ++n12;
                    }
                }
                if (++n8 >= n10) continue;
                d6 += shadeEdge.leftXSlope;
                d7 += shadeEdge.rightXSlope;
                n12 = 0;
                while (n12 < n6) {
                    int n18 = n12;
                    fArray[n18] = fArray[n18] + shadeEdge.leftColorSlope[n12];
                    int n19 = n12;
                    fArray2[n19] = fArray2[n19] + shadeEdge.rightColorSlope[n12];
                    ++n12;
                }
                n11 += rectangle.width;
            }
        }
        if (functionArray != null) {
            int n20 = functionArray.length;
            while (n20-- > 0) {
                functionArray[n20].flush();
            }
        }
    }

    public FloatRect getBoundingBox() {
        double d = this.bbox.getxMin();
        double d2 = this.bbox.getyMin();
        double d3 = this.bbox.getxMax();
        double d4 = this.bbox.getyMax();
        ShadeEdge shadeEdge = this.next;
        while (shadeEdge != null) {
            double d5 = shadeEdge.bbox.getxMin();
            double d6 = shadeEdge.bbox.getyMin();
            double d7 = shadeEdge.bbox.getxMax();
            double d8 = shadeEdge.bbox.getyMax();
            if (d > d5) {
                d = d5;
            }
            if (d2 > d6) {
                d2 = d6;
            }
            if (d3 < d7) {
                d3 = d7;
            }
            if (!(d4 < d8)) continue;
            d4 = d8;
        }
        return new FloatRect(d, d2, d3, d4);
    }

    public ListSortable getLink() {
        return this.next;
    }

    public void setLink(ListSortable listSortable) {
        this.next = (ShadeEdge)listSortable;
    }
}

