/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.DeviceRGBColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;

public class SmoothBitsImageFilter
extends ImageFilter {
    private int oldWidth;
    private int oldHeight;
    private int newWidth;
    private int newHeight;
    private PDFColorModel pdfModel;
    private boolean smooth;
    private byte[] byteOutputRow;
    private int[] colCount;
    private int[] alphaRow;
    private long[] redRow;
    private long[] greenRow;
    private long[] blueRow;
    private float xIncr;
    private float yIncr;
    private int thisY;
    private boolean noConvert;
    private boolean alphaOnly;
    private boolean somePixels;

    public SmoothBitsImageFilter(int n, int n2, boolean bl) {
        this.newWidth = n;
        this.newHeight = n2;
        this.smooth = bl;
        this.oldHeight = 0;
        this.oldWidth = 0;
        this.pdfModel = null;
        this.somePixels = false;
        this.alphaOnly = false;
    }

    public ImageFilter getFilterInstance(ImageConsumer imageConsumer) {
        SmoothBitsImageFilter smoothBitsImageFilter = (SmoothBitsImageFilter)this.clone();
        smoothBitsImageFilter.consumer = imageConsumer;
        return smoothBitsImageFilter;
    }

    public synchronized void imageComplete(int n) {
        if (this.somePixels) {
            this.sendPixels();
        }
        this.consumer.imageComplete(n);
        this.oldHeight = -1;
        this.oldWidth = -1;
        this.byteOutputRow = null;
        this.alphaRow = null;
        this.colCount = null;
        this.blueRow = null;
        this.greenRow = null;
        this.redRow = null;
        this.pdfModel = null;
    }

    private void initialize() {
        this.xIncr = (float)this.oldWidth / (float)this.newWidth;
        this.yIncr = (float)this.oldHeight / (float)this.newHeight;
        if (this.pdfModel == null) {
            this.pdfModel = this.smooth ? DeviceRGBColorModel.AlphaPremultipliedColorModel : DeviceRGBColorModel.DefaultColorModel;
        }
        boolean bl = this.noConvert = this.oldWidth == this.newWidth && this.oldHeight == this.newHeight;
        if (!this.noConvert) {
            if (this.smooth) {
                this.alphaRow = MemUtil.allocInt(this.newWidth + 1);
                this.colCount = MemUtil.allocInt(this.newWidth + 1);
                this.alphaOnly = this.pdfModel.canBlend();
                if (this.alphaOnly) {
                    this.byteOutputRow = MemUtil.allocByte(this.newWidth + 1);
                } else {
                    this.redRow = MemUtil.allocLong(this.newWidth + 1);
                    this.greenRow = MemUtil.allocLong(this.newWidth + 1);
                    this.blueRow = MemUtil.allocLong(this.newWidth + 1);
                }
            } else {
                boolean bl2 = this.alphaOnly = this.pdfModel.getNumComponents() == 1;
                if (this.alphaOnly) {
                    this.byteOutputRow = MemUtil.allocByte(this.newWidth + 1);
                } else {
                    this.colCount = MemUtil.allocInt(this.newWidth + 1);
                }
            }
            this.thisY = -1;
            this.somePixels = false;
        }
        if (!this.noConvert && !this.alphaOnly) {
            this.pdfModel = DeviceRGBColorModel.AlphaPremultipliedColorModel;
        }
        this.consumer.setColorModel(this.pdfModel);
    }

    private void sendPixels() {
        int n;
        int n2;
        if (this.alphaOnly) {
            n2 = 0;
            while (n2 < this.newWidth) {
                n = this.colCount[n2];
                this.byteOutputRow[n2] = n > 1 ? (byte)(this.alphaRow[n2] / n) : (byte)this.alphaRow[n2];
                ++n2;
            }
            this.consumer.setPixels(0, this.thisY, this.newWidth, 1, (ColorModel)this.pdfModel, this.byteOutputRow, 0, this.newWidth);
        } else {
            n2 = 0;
            while (n2 < this.newWidth) {
                int n3;
                n = this.colCount[n2];
                this.colCount[n2] = n > 0 ? ((n3 = this.alphaRow[n2] / n) == 0 ? 0 : (n3 << 24) + ((int)(this.redRow[n2] / (long)(n *= 255)) << 16) + ((int)(this.greenRow[n2] / (long)n) << 8) + (int)(this.blueRow[n2] / (long)n)) : 0;
                ++n2;
            }
            this.consumer.setPixels(0, this.thisY, this.newWidth, 1, (ColorModel)this.pdfModel, this.colCount, 0, this.newWidth);
        }
        n2 = 0;
        while (n2 < this.newWidth) {
            this.colCount[n2] = 0;
            this.alphaRow[n2] = 0;
            if (!this.alphaOnly) {
                this.blueRow[n2] = 0L;
                this.greenRow[n2] = 0L;
                this.redRow[n2] = 0L;
            }
            ++n2;
        }
        this.somePixels = false;
    }

    private void sendPixelsResample() {
        if (this.alphaOnly) {
            this.consumer.setPixels(0, this.thisY, this.newWidth, 1, (ColorModel)this.pdfModel, this.byteOutputRow, 0, this.newWidth);
        } else {
            this.consumer.setPixels(0, this.thisY, this.newWidth, 1, (ColorModel)this.pdfModel, this.colCount, 0, this.newWidth);
        }
        this.somePixels = false;
    }

    public void setColorModel(ColorModel colorModel) {
        if (this.pdfModel == null) {
            if (colorModel instanceof PDFColorModel) {
                this.pdfModel = (PDFColorModel)colorModel;
            }
            if (this.oldWidth > 0) {
                this.initialize();
            }
        }
    }

    public void setDimensions(int n, int n2) {
        if (this.oldWidth <= 0 || this.oldHeight <= 0) {
            this.oldWidth = n;
            this.oldHeight = n2;
            if (this.pdfModel != null) {
                this.initialize();
            }
        }
        this.consumer.setDimensions(this.newWidth, this.newHeight);
    }

    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.noConvert) {
            this.consumer.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
        } else if (this.smooth) {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = (int)((float)(n2 + n7) / this.yIncr);
                if (this.somePixels && n8 != this.thisY) {
                    this.sendPixels();
                }
                this.thisY = n8;
                this.somePixels = true;
                int n9 = (int)((float)n / this.xIncr);
                int n10 = (int)((float)(n9 + 1) * this.xIncr) - n;
                int n11 = 0;
                while (n11 < n3) {
                    if (n11 >= n10) {
                        n10 = (int)((float)(++n9 + 1) * this.xIncr) - n;
                    }
                    int n12 = n9;
                    this.colCount[n12] = this.colCount[n12] + 1;
                    if (this.alphaOnly) {
                        int n13 = n9;
                        this.alphaRow[n13] = this.alphaRow[n13] + (byArray[n5 + n11] & 0xFF);
                    } else {
                        int n14 = colorModel.getRGB(byArray[n5 + n11] & 0xFF);
                        int n15 = n14 >>> 24;
                        int n16 = n9;
                        this.alphaRow[n16] = this.alphaRow[n16] + n15;
                        int n17 = n9;
                        this.redRow[n17] = this.redRow[n17] + (long)(n15 * (n14 >>> 16 & 0xFF));
                        int n18 = n9;
                        this.greenRow[n18] = this.greenRow[n18] + (long)(n15 * (n14 >>> 8 & 0xFF));
                        int n19 = n9;
                        this.blueRow[n19] = this.blueRow[n19] + (long)(n15 * (n14 & 0xFF));
                    }
                    ++n11;
                }
                n5 += n6;
                ++n7;
            }
        } else {
            int n20 = 0;
            while (n20 < n4) {
                int n21 = (int)((float)(n2 + n20) / this.yIncr);
                if (n21 != this.thisY) {
                    this.thisY = n21;
                    this.somePixels = true;
                    float f = 0.0f;
                    int n22 = 0;
                    while (n22 < this.newWidth) {
                        int n23 = (int)f;
                        if (n23 >= n && n23 < n + n3) {
                            if (this.alphaOnly) {
                                this.byteOutputRow[n22] = byArray[n5 + n23];
                            } else {
                                this.colCount[n22] = colorModel.getRGB(byArray[n5 + n23] & 0xFF);
                            }
                        } else if (this.alphaOnly) {
                            this.byteOutputRow[n22] = 0;
                        } else {
                            this.colCount[n22] = 0;
                        }
                        f += this.xIncr;
                        ++n22;
                    }
                    this.sendPixelsResample();
                }
                n5 += n6;
                ++n20;
            }
        }
    }

    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.noConvert) {
            this.consumer.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        } else if (this.smooth) {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = (int)((float)(n2 + n7) / this.yIncr);
                if (this.somePixels && n8 != this.thisY) {
                    this.sendPixels();
                }
                this.thisY = n8;
                this.somePixels = true;
                int n9 = (int)((float)n / this.xIncr);
                int n10 = (int)((float)(n9 + 1) * this.xIncr) - n;
                int n11 = 0;
                while (n11 < n3) {
                    if (n11 >= n10) {
                        n10 = (int)((float)(++n9 + 1) * this.xIncr) - n;
                    }
                    int n12 = colorModel.getRGB(nArray[n5 + n11]);
                    int n13 = n9;
                    this.colCount[n13] = this.colCount[n13] + 1;
                    int n14 = n12 >>> 24;
                    int n15 = n9;
                    this.alphaRow[n15] = this.alphaRow[n15] + n14;
                    if (!this.alphaOnly) {
                        int n16 = n9;
                        this.redRow[n16] = this.redRow[n16] + (long)(n14 * (n12 >>> 16 & 0xFF));
                        int n17 = n9;
                        this.greenRow[n17] = this.greenRow[n17] + (long)(n14 * (n12 >>> 8 & 0xFF));
                        int n18 = n9;
                        this.blueRow[n18] = this.blueRow[n18] + (long)(n14 * (n12 & 0xFF));
                    }
                    ++n11;
                }
                n5 += n6;
                ++n7;
            }
        } else {
            int n19 = 0;
            while (n19 < n4) {
                int n20 = (int)((float)(n2 + n19) / this.yIncr);
                if (n20 != this.thisY) {
                    this.thisY = n20;
                    this.somePixels = true;
                    float f = 0.0f;
                    int n21 = 0;
                    while (n21 < this.newWidth) {
                        int n22 = (int)f;
                        this.colCount[n21] = n22 >= n && n22 < n + n3 ? colorModel.getRGB(nArray[n5 + n22]) : 0;
                        f += this.xIncr;
                        ++n21;
                    }
                    this.sendPixelsResample();
                }
                n5 += n6;
                ++n19;
            }
        }
    }
}

