/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFInteger;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReal;
import com.adobe.acrobat.pdfobjstore.UnexpectedTypeException;
import com.adobe.acrobat.tokenize.Tokenizer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.WriteLockException;
import java.io.InputStream;

public class LinearizerInfo {
    private static final String obj_K = "obj";
    private static final String endobj_K = "endobj";
    private static final String Linearized_K = "Linearized";
    private static final String L_K = "L";
    private static final String H_K = "H";
    private static final String O_K = "O";
    private static final String E_K = "E";
    private static final String N_K = "N";
    private static final String T_K = "T";
    private static final String P_K = "P";
    private boolean linearized;
    private int xrefStart;
    private int linLength;
    private int h1Offset;
    private int h1Length;
    private boolean h2Present;
    private int h2Offset;
    private int h2Length;
    private int firstPageObjNum;
    private int firstPageEndOffset;
    private int numPages;
    private int mainXRefTableOffset;
    private int firstPageNum;

    LinearizerInfo(Requester requester, PDFObjStore pDFObjStore) throws Exception {
        Tokenizer tokenizer;
        block3: {
            this.linearized = false;
            this.xrefStart = -1;
            ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(requester);
            if (byteArray == null) {
                return;
            }
            InputStream inputStream = byteArray.getByteStream(0);
            tokenizer = new Tokenizer(inputStream);
            try {
                this.loadLinearizationInfo(requester, pDFObjStore, tokenizer, byteArray);
                if (!this.linearized) break block3;
                this.xrefStart = tokenizer.numBytesConsumed();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                tokenizer.close();
                throw throwable;
            }
        }
        Object var7_6 = null;
        tokenizer.close();
    }

    public int getFileLength() {
        return this.linLength;
    }

    public int getFirstPageID() {
        return this.firstPageObjNum;
    }

    public int getFirstPageNum() {
        return this.firstPageNum;
    }

    public int getNumPages() {
        return this.numPages;
    }

    int getXRefStart() {
        return this.xrefStart;
    }

    public boolean isLinearized() {
        return this.linearized;
    }

    private void loadLinearizationInfo(Requester requester, PDFObjStore pDFObjStore, Tokenizer tokenizer, ByteArray byteArray) throws Exception {
        PDFObj pDFObj;
        int n;
        try {
            int n2 = tokenizer.numBytesConsumed();
            tokenizer.nextToken();
            if (tokenizer.type() != 2) {
                return;
            }
            int n3 = tokenizer.integerValue();
            tokenizer.nextToken();
            if (tokenizer.type() != 2) {
                return;
            }
            n = tokenizer.integerValue();
            tokenizer.nextToken();
            if (tokenizer.type() != 5 || !tokenizer.literalValue().equals(obj_K)) {
                return;
            }
            tokenizer.nextToken();
            pDFObj = PDFObj.read(pDFObjStore, tokenizer, byteArray, 0, false);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            return;
        }
        try {
            int n4;
            Object object;
            if (!(pDFObj instanceof PDFDict)) {
                return;
            }
            PDFDict pDFDict = (PDFDict)pDFObj;
            PDFObj pDFObj2 = pDFDict.get(Linearized_K);
            if (pDFObj2 instanceof PDFInteger) {
                n = ((PDFInteger)pDFObj2).integerValue();
                boolean bl = false;
            } else if (pDFObj2 instanceof PDFReal) {
                object = String.valueOf(((PDFReal)pDFObj2).floatValue());
                n = Integer.parseInt((String)object);
                n4 = ((String)object).lastIndexOf(46);
                int n5 = n4 == -1 ? 0 : Integer.parseInt(((String)object).substring(n4 + 1));
            } else {
                return;
            }
            if (n != 1) {
                return;
            }
            pDFObj2 = pDFDict.get(L_K);
            if (!(pDFObj2 instanceof PDFInteger)) {
                throw new UnexpectedTypeException(2);
            }
            this.linLength = ((PDFInteger)pDFObj2).integerValue();
            if (this.linLength != byteArray.getLength()) {
                return;
            }
            pDFObj2 = pDFDict.get(H_K);
            if (!(pDFObj2 instanceof PDFDirectObj)) {
                throw new UnexpectedTypeException(7);
            }
            if (!((pDFObj2 = ((PDFDirectObj)pDFObj2).resolve()) instanceof PDFArray)) {
                throw new UnexpectedTypeException(7);
            }
            object = (PDFArray)pDFObj2;
            n4 = ((PDFArray)object).size();
            if (n4 != 2 && n4 != 4) {
                return;
            }
            this.h1Offset = ((PDFArray)object).get(0).integerValue(requester);
            this.h1Length = ((PDFArray)object).get(1).integerValue(requester);
            boolean bl = this.h2Present = n4 == 4;
            if (this.h2Present) {
                this.h2Offset = ((PDFArray)object).get(0).integerValue(requester);
                this.h2Length = ((PDFArray)object).get(1).integerValue(requester);
            }
            this.firstPageObjNum = pDFDict.get(O_K).integerValue(requester);
            this.firstPageEndOffset = pDFDict.get(E_K).integerValue(requester);
            this.numPages = pDFDict.get(N_K).integerValue(requester);
            this.mainXRefTableOffset = pDFDict.get(T_K).integerValue(requester);
            this.firstPageNum = 0;
            if (pDFDict.hasKey(P_K) && (pDFObj2 = pDFDict.get(P_K)) instanceof PDFInteger) {
                this.firstPageNum = pDFObj2.integerValue(requester);
            }
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            return;
        }
        this.linearized = true;
    }
}

