/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdfobjstore.BadXRefTableException;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjMap;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.XRefSection;
import com.adobe.acrobat.pdfobjstore.XRefTableRebuilder;
import com.adobe.acrobat.tokenize.Tokenizer;
import com.adobe.pe.notify.Requester;
import java.io.InputStream;

class XRefTable {
    private static final String Catalog_K = "Catalog";
    private static final String Info_K = "Info";
    private static final String Prev_K = "Prev";
    private static final String Size_K = "Size";
    private static final String startxref_K = "startxref";
    private static final String trailer_K = "trailer";
    private static final String xref_K = "xref";
    private ByteArray ba;
    private PDFObjStore store;
    private PDFObjMap map;
    private XRefSection lastXRefSection;
    private XRefTableRebuilder rebuildInfo;

    XRefTable(PDFObjStore pDFObjStore, PDFObjMap pDFObjMap, int n, Requester requester) throws Exception {
        this.ba = pDFObjStore.getVByteArray().byteArrayValue(requester);
        this.store = pDFObjStore;
        this.map = pDFObjMap;
        if (this.ba != null) {
            try {
                if (n == -1) {
                    n = XRefTable.findXRefStart(pDFObjStore, requester);
                }
                this.lastXRefSection = new XRefSection(pDFObjStore, pDFObjMap, this.ba, n, true, requester);
            }
            catch (BadXRefTableException badXRefTableException) {
                this.rebuildInfo = new XRefTableRebuilder(this.ba, pDFObjStore, pDFObjMap, requester);
                pDFObjMap.setTrailerRef(this.rebuildInfo.trailer);
            }
        } else {
            PDFDict pDFDict = new PDFDict(new String[0], new PDFObj[0]);
            pDFObjMap.setTrailerRef(new PDFDirectObj(pDFObjStore, pDFDict));
        }
    }

    XRefTable(PDFObjStore pDFObjStore, PDFObjMap pDFObjMap, Requester requester) throws Exception {
        this(pDFObjStore, pDFObjMap, -1, requester);
    }

    private static int findXRefStart(PDFObjStore pDFObjStore, Requester requester) throws Exception {
        int n = -1;
        ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(requester);
        if (byteArray != null) {
            int n2 = byteArray.findString(startxref_K, -1, 1024, false, -1);
            if (n2 == -1) {
                throw new BadXRefTableException();
            }
            InputStream inputStream = byteArray.getByteStream(n2);
            Tokenizer tokenizer = new Tokenizer(inputStream);
            try {
                tokenizer.nextToken();
                if (tokenizer.type() != 5 || !tokenizer.literalValue().equals(startxref_K)) {
                    throw new BadXRefTableException();
                }
                tokenizer.nextToken();
                if (tokenizer.type() != 2) {
                    throw new BadXRefTableException();
                }
                n = tokenizer.integerValue();
            }
            finally {
                Object var8_7 = null;
                tokenizer.close();
            }
        }
        return n;
    }
}

