/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import java.awt.Rectangle;

public class FloatRect {
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private static FloatRect emptyRect = new FloatRect(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
    private static FloatRect fullRect = new FloatRect(-1.7976931348623157E308, -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
    private static final int pinMax = 0x3FFFFFFF;
    private static final int pinMin = -1073741823;

    public FloatRect() {
        this.yMin = Double.MAX_VALUE;
        this.xMin = Double.MAX_VALUE;
        this.yMax = -1.7976931348623157E308;
        this.xMax = -1.7976931348623157E308;
    }

    public FloatRect(double d, double d2, double d3, double d4) {
        this.xMin = d;
        this.xMax = d3;
        this.yMin = d2;
        this.yMax = d4;
    }

    public FloatRect(FloatPoint floatPoint, FloatPoint floatPoint2) {
        this.xMin = Math.min(floatPoint.x, floatPoint2.x);
        this.xMax = Math.max(floatPoint.x, floatPoint2.x);
        this.yMin = Math.min(floatPoint.y, floatPoint2.y);
        this.yMax = Math.max(floatPoint.y, floatPoint2.y);
    }

    public FloatRect(Rectangle rectangle) {
        if (rectangle.width > 0) {
            this.xMin = rectangle.x;
            this.xMax = rectangle.x + rectangle.width;
        } else {
            this.xMin = rectangle.x - rectangle.width;
            this.xMax = rectangle.x;
        }
        if (rectangle.height > 0) {
            this.yMin = rectangle.y;
            this.yMax = rectangle.y + rectangle.height;
        } else {
            this.yMin = rectangle.y - rectangle.height;
            this.yMax = rectangle.y;
        }
    }

    public FloatRect(double[] dArray) {
        this.xMin = dArray[0];
        this.xMax = dArray[2];
        this.yMin = dArray[1];
        this.yMax = dArray[3];
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FloatRect)) {
            return false;
        }
        FloatRect floatRect = (FloatRect)object;
        return floatRect == this || this.isReallyEmpty() && floatRect.isReallyEmpty() || this.xMin == floatRect.xMin && floatRect.xMax == this.xMax && this.yMin == floatRect.yMin && floatRect.yMax == this.yMax;
    }

    public static FloatRect getEmptyRect() {
        return emptyRect;
    }

    public void getFloatRect(double[] dArray) {
        dArray[0] = this.xMin;
        dArray[1] = this.yMin;
        dArray[2] = this.xMax;
        dArray[3] = this.yMax;
    }

    public static FloatRect getFullRect() {
        return fullRect;
    }

    public double getxMax() {
        return this.xMax;
    }

    public double getxMin() {
        return this.xMin;
    }

    public double getyMax() {
        return this.yMax;
    }

    public double getyMin() {
        return this.yMin;
    }

    public FloatRect grow(double d, double d2) {
        return new FloatRect(this.xMin - d, this.yMin - d2, this.xMax + d, this.yMax + d2);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        long l = Double.doubleToLongBits(this.xMin);
        l = (l >>> 1) + Double.doubleToLongBits(this.xMax);
        l = (l >>> 1) + Double.doubleToLongBits(this.yMin);
        l = (l >>> 1) + Double.doubleToLongBits(this.yMax);
        return (int)(l ^ l >>> 32);
    }

    public double height() {
        return this.yMax >= this.yMin ? this.yMax - this.yMin : 0.0;
    }

    public boolean inFloatRect(FloatRect floatRect) {
        return !this.isReallyEmpty() && floatRect != null && !floatRect.isReallyEmpty() && this.xMin >= floatRect.xMin && this.xMax <= floatRect.xMax && this.yMin >= floatRect.yMin && this.yMax <= floatRect.yMax;
    }

    public FloatRect intersect(FloatRect floatRect) {
        if (floatRect == null || floatRect.isReallyEmpty() || this.isReallyEmpty()) {
            return FloatRect.getEmptyRect();
        }
        double d = Math.max(this.xMin, floatRect.xMin);
        double d2 = Math.max(this.yMin, floatRect.yMin);
        double d3 = Math.min(this.xMax, floatRect.xMax);
        double d4 = Math.min(this.yMax, floatRect.yMax);
        if (d <= d3 && d2 <= d4) {
            if (d == this.xMin && d3 == this.xMax && d2 == this.yMin && d4 == this.yMax) {
                return this;
            }
            if (d == floatRect.xMin && d3 == floatRect.xMax && d2 == floatRect.yMin && d4 == floatRect.yMax) {
                return floatRect;
            }
            return new FloatRect(d, d2, d3, d4);
        }
        return FloatRect.getEmptyRect();
    }

    public boolean isEmpty() {
        return this.xMin >= this.xMax || this.yMin >= this.yMax;
    }

    public boolean isReallyEmpty() {
        return this.xMin > this.xMax || this.yMin > this.yMax;
    }

    public boolean overlap(FloatRect floatRect) {
        return !this.isReallyEmpty() && floatRect != null && !floatRect.isReallyEmpty() && this.xMin < floatRect.xMax && floatRect.xMin < this.xMax && this.yMin < floatRect.yMax && floatRect.yMin < this.yMax;
    }

    private int pin(double d) {
        if (d <= -1.073741823E9) {
            return -1073741823;
        }
        if (d >= 1.073741823E9) {
            return 0x3FFFFFFF;
        }
        return (int)d;
    }

    public boolean ptInRect(FloatPoint floatPoint) {
        return floatPoint.x >= this.xMin && floatPoint.x < this.xMax && floatPoint.y >= this.yMin && floatPoint.y < this.yMax;
    }

    public boolean strictlyInFloatRect(FloatRect floatRect) {
        return !this.isReallyEmpty() && floatRect != null && !floatRect.isReallyEmpty() && this.xMin > floatRect.xMin && this.xMax < floatRect.xMax && this.yMin > floatRect.yMin && this.yMax < floatRect.yMax;
    }

    public Rectangle toEnclosingRect() {
        int n = this.pin(Math.floor(this.xMin));
        int n2 = this.pin(Math.ceil(this.xMax));
        int n3 = this.pin(Math.floor(this.yMin));
        int n4 = this.pin(Math.ceil(this.yMax));
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public Rectangle toRect() {
        int n = this.pin(Math.round(this.xMin));
        int n2 = this.pin(Math.round(this.xMax));
        int n3 = this.pin(Math.round(this.yMin));
        int n4 = this.pin(Math.round(this.yMax));
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public String toString() {
        return "(" + Math.round(this.xMin * 100.0) / 100L + ", " + Math.round(this.yMin * 100.0) / 100L + ", " + Math.round(this.xMax * 100.0) / 100L + ", " + Math.round(this.yMax * 100.0) / 100L + ")";
    }

    public FloatRect transformRect(AffineTransform affineTransform) {
        double d = affineTransform.geta();
        double d2 = affineTransform.getb();
        double d3 = affineTransform.getc();
        double d4 = affineTransform.getd();
        double d5 = affineTransform.getx();
        double d6 = affineTransform.gety();
        double d7 = this.xMin;
        double d8 = this.xMax;
        double d9 = this.yMin;
        double d10 = this.yMax;
        double d11 = d * d7 + d3 * d9 + d5;
        double d12 = d2 * d7 + d4 * d9 + d6;
        double d13 = d * d7 + d3 * d10 + d5;
        double d14 = d2 * d7 + d4 * d10 + d6;
        double d15 = d * d8 + d3 * d9 + d5;
        double d16 = d2 * d8 + d4 * d9 + d6;
        double d17 = d * d8 + d3 * d10 + d5;
        double d18 = d2 * d8 + d4 * d10 + d6;
        d7 = Math.min(Math.min(d11, d13), Math.min(d15, d17));
        d8 = Math.max(Math.max(d11, d13), Math.max(d15, d17));
        d9 = Math.min(Math.min(d12, d14), Math.min(d16, d18));
        d10 = Math.max(Math.max(d12, d14), Math.max(d16, d18));
        return new FloatRect(d7, d9, d8, d10);
    }

    public FloatRect union(FloatRect floatRect) {
        if (floatRect == null || floatRect.isReallyEmpty()) {
            return this;
        }
        if (this.isReallyEmpty()) {
            return floatRect;
        }
        double d = Math.min(this.xMin, floatRect.xMin);
        double d2 = Math.min(this.yMin, floatRect.yMin);
        double d3 = Math.max(this.xMax, floatRect.xMax);
        double d4 = Math.max(this.yMax, floatRect.yMax);
        if (d <= d3 && d2 <= d4) {
            if (d == this.xMin && d3 == this.xMax && d2 == this.yMin && d4 == this.yMax) {
                return this;
            }
            if (d == floatRect.xMin && d3 == floatRect.xMax && d2 == floatRect.yMin && d4 == floatRect.yMax) {
                return floatRect;
            }
            return new FloatRect(d, d2, d3, d4);
        }
        return FloatRect.getEmptyRect();
    }

    public FloatRect upright() {
        if (this.xMin <= this.xMax) {
            if (this.yMin <= this.yMax) {
                return this;
            }
            return new FloatRect(this.xMin, this.yMax, this.xMax, this.yMin);
        }
        if (this.yMin <= this.yMax) {
            return new FloatRect(this.xMax, this.yMin, this.xMin, this.yMax);
        }
        return new FloatRect(this.xMax, this.yMax, this.xMin, this.yMin);
    }

    public double width() {
        return this.xMax >= this.xMin ? this.xMax - this.xMin : 0.0;
    }
}

