/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.tokenize;

import com.adobe.acrobat.tokenize.TokenizerException;
import com.adobe.acrobat.util.Util;
import com.adobe.util.MemUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Tokenizer
extends InputStream {
    public static final int EOF = 256;
    public static final int Unknown = 0;
    public static final int String = 1;
    public static final int Integer = 2;
    public static final int Real = 3;
    public static final int Name = 4;
    public static final int Literal = 5;
    private static final String ATMthing = "-|";
    private static double[] tenPow = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10};
    private static String[] oneCharLit = new String[95];
    private static final String angleBracketThing = "<<";
    private static final int E = 1;
    private static final int W = 2;
    private static final int X = 4;
    private static final int O = 8;
    private static final int C = 16;
    private static final int I = 32;
    private static final int R = 64;
    private static final int S = 128;
    private static final int N = 256;
    private static final int j = 0;
    private static int[] chartype;
    private static final int kReadAheadBufSize = 2048;
    private int readAheadByteCount = 0;
    private int readAheadOffset = 0;
    private byte[] readAheadByteArray = MemUtil.allocByte(2048);
    private int peek = 0;
    private int markedReadAheadOffset = -1;
    private int markedCurrPos;
    private int markedPeek;
    protected static final int EOString = -2;
    private int lastPeek;
    private int lastReadAheadOffset = -1;
    boolean bufferInput;
    boolean type1Syntax = false;
    private InputStream stm;
    private int currPos;
    private int currTokenStart;
    private char[] charBuf = MemUtil.allocChar(256);
    private int charBufPos;
    private byte[] byteBuf = MemUtil.allocByte(256);
    private int byteBufPos;
    int currType = 0;
    private byte[] stringVal;
    private String cachedStringRep = null;
    private String nameVal;
    private int integerVal;
    private float realVal;
    private String literalVal;

    static {
        int[] nArray = new int[257];
        nArray[0] = 401;
        nArray[9] = 259;
        nArray[10] = 275;
        nArray[12] = 259;
        nArray[13] = 275;
        nArray[32] = 259;
        nArray[35] = 256;
        nArray[37] = 257;
        nArray[40] = 385;
        nArray[41] = 385;
        nArray[43] = 96;
        nArray[45] = 96;
        nArray[46] = 64;
        nArray[47] = 257;
        nArray[48] = 108;
        nArray[49] = 108;
        nArray[50] = 108;
        nArray[51] = 108;
        nArray[52] = 108;
        nArray[53] = 108;
        nArray[54] = 108;
        nArray[55] = 108;
        nArray[56] = 100;
        nArray[57] = 100;
        nArray[60] = 385;
        nArray[62] = 385;
        nArray[65] = 4;
        nArray[66] = 4;
        nArray[67] = 4;
        nArray[68] = 4;
        nArray[69] = 4;
        nArray[70] = 4;
        nArray[91] = 385;
        nArray[93] = 385;
        nArray[97] = 4;
        nArray[98] = 4;
        nArray[99] = 4;
        nArray[100] = 4;
        nArray[101] = 4;
        nArray[102] = 4;
        nArray[123] = 385;
        nArray[125] = 385;
        nArray[256] = 273;
        chartype = nArray;
    }

    public Tokenizer(InputStream inputStream) throws IOException {
        this(inputStream, false, true);
    }

    public Tokenizer(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        this.stm = inputStream;
        this.currPos = 0;
        this.currTokenStart = 0;
        this.type1Syntax = bl;
        this.bufferInput = bl2;
    }

    private void accumulateAngleBracketThing() throws Exception {
        char c = (char)this.nextByte();
        if (this.peek == 60) {
            this.nextByte();
            this.setLiteralValue(angleBracketThing);
        } else {
            this.setStringValue(this.accumulateHexString());
        }
    }

    private byte[] accumulateHexString() throws Exception {
        boolean bl = false;
        byte[] byArray = this.byteBuf;
        byte[] byArray2 = null;
        this.byteBufPos = 0;
        while (!bl) {
            int n;
            this.skipWhite();
            if (this.peek == 62) {
                this.nextByte();
                break;
            }
            int n2 = this.nextHexDigit();
            this.skipWhite();
            if (this.peek == 62) {
                n = 0;
                this.nextByte();
                bl = true;
            } else {
                n = this.nextHexDigit();
            }
            if (this.byteBufPos == byArray.length) {
                byte[] byArray3 = MemUtil.allocByte(byArray.length + 1024);
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                byArray = byArray3;
            }
            byArray[this.byteBufPos++] = (byte)((n2 << 4) + n);
        }
        byArray2 = MemUtil.allocByte(this.byteBufPos);
        System.arraycopy(byArray, 0, byArray2, 0, this.byteBufPos);
        return byArray2;
    }

    /*
     * Unable to fully structure code
     */
    private void accumulateLiteral() throws Exception {
        block8: {
            this.charBufPos = 0;
            if (this.peek != 60 && this.peek != 62) ** GOTO lbl9
            var1_1 = this.nextByte();
            this.charBuf[this.charBufPos++] = var1_1;
            if (var1_1 != this.peek) break block8;
            this.charBuf[this.charBufPos++] = (char)this.nextByte();
            break block8;
lbl-1000:
            // 1 sources

            {
                this.charBuf[this.charBufPos++] = (char)this.nextByte();
lbl9:
                // 2 sources

                ** while ((Tokenizer.chartype[this.peek] & 1) == 0)
            }
lbl10:
            // 1 sources

            if (this.charBufPos == 0) {
                if (this.peek == 256) {
                    throw new EOFException();
                }
                this.charBuf[this.charBufPos++] = (char)this.nextByte();
            }
        }
        if (this.charBufPos == 1 && (var1_1 = this.charBuf[0] - 33) >= 0 && var1_1 < 95) {
            if (Tokenizer.oneCharLit[var1_1] == null) {
                Tokenizer.oneCharLit[var1_1] = new String(this.charBuf, 0, this.charBufPos);
            }
            this.setLiteralValue(Tokenizer.oneCharLit[var1_1]);
            return;
        }
        this.setLiteralValue(new String(this.charBuf, 0, this.charBufPos));
    }

    private void accumulateName() throws Exception {
        this.charBufPos = 0;
        this.nextByte();
        while (this.charBufPos < 127) {
            if ((chartype[this.peek] & 0x100) == 0) {
                this.charBuf[this.charBufPos++] = (char)this.nextByte();
                continue;
            }
            if (this.peek != 35) break;
            this.nextByte();
            int n = this.nextHexDigit();
            int n2 = this.nextHexDigit();
            char c = (char)((n << 4) + n2);
            if (c == '\u0000') {
                throw new TokenizerException();
            }
            this.charBuf[this.charBufPos++] = c;
        }
        this.setNameValue(new String(this.charBuf, 0, this.charBufPos));
    }

    private void accumulateNumber() throws Exception {
        int n;
        int n2;
        int n3;
        boolean bl;
        boolean bl2;
        block16: {
            bl2 = false;
            boolean bl3 = false;
            bl = false;
            n3 = 0;
            n2 = 0;
            n = 0;
            if (this.peek == 45) {
                if (this.nextBytePeek() == 124) {
                    this.nextByte();
                    this.setLiteralValue(ATMthing);
                    return;
                }
                bl = true;
            } else if (this.peek == 43) {
                this.nextByte();
            }
            while (true) {
                if (this.peek >= 48 && this.peek <= 57) {
                    int n4 = this.nextByte() - 48;
                    if (bl2) {
                        if (++n3 < 10) {
                            n += n << 2;
                            n += n + n4;
                            continue;
                        }
                        --n3;
                        continue;
                    }
                    n2 += n2 << 2;
                    n2 += n2 + n4;
                    continue;
                }
                if (this.peek != 46) break;
                if (!bl2) {
                    this.nextByte();
                    bl2 = true;
                    continue;
                }
                break block16;
                break;
            }
            if (this.type1Syntax && (this.peek == 69 || this.peek == 101)) {
                double d = 0.0;
                boolean bl4 = true;
                double d2 = 1.0;
                this.nextByte();
                if (this.peek == 45) {
                    bl4 = false;
                    this.nextByte();
                } else if (this.peek == 43) {
                    this.nextByte();
                }
                while (this.peek >= 48 && this.peek <= 57) {
                    int n5 = this.peek - 48;
                    d = d * 10.0 + (double)n5;
                    this.nextByte();
                }
                d2 = Math.pow(10.0, bl4 ? d : -d);
                double d3 = (double)n2 + (double)n * tenPow[n3];
                this.setRealValue((float)((bl ? -d3 : d3) * d2));
                return;
            }
        }
        if (bl2) {
            double d = (double)n2 + (double)n * tenPow[n3];
            this.setRealValue((float)(bl ? -d : d));
        } else {
            this.setIntegerValue(bl ? -n2 : n2);
        }
    }

    private void accumulateString() throws Exception {
        int n = this.nextByte();
        byte[] byArray = null;
        byte[] byArray2 = this.byteBuf;
        this.byteBufPos = 0;
        int n2 = 1;
        while (true) {
            n = this.nextStringByte();
            if (this.type1Syntax && n == 40) {
                ++n2;
            } else if (n == -2 && --n2 == 0) break;
            if (this.byteBufPos >= byArray2.length) {
                byte[] byArray3 = MemUtil.allocByte(byArray2.length + 256);
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                byArray2 = byArray3;
            }
            byArray2[this.byteBufPos++] = (byte)n;
        }
        byArray = MemUtil.allocByte(this.byteBufPos);
        System.arraycopy(byArray2, 0, byArray, 0, this.byteBufPos);
        this.setStringValue(byArray);
    }

    private void accumulateToken() throws Exception {
        if ((chartype[this.peek] & 0x40) != 0) {
            this.accumulateNumber();
        } else {
            switch (this.peek) {
                case 256: {
                    this.currType = 256;
                    break;
                }
                case 40: {
                    this.accumulateString();
                    break;
                }
                case 60: {
                    this.accumulateAngleBracketThing();
                    break;
                }
                case 47: {
                    this.accumulateName();
                    break;
                }
                default: {
                    this.accumulateLiteral();
                    break;
                }
            }
        }
    }

    public int available() throws IOException {
        return this.stm.available() + this.readAheadByteCount - this.readAheadOffset;
    }

    public byte[] bytesValue() {
        return this.stringVal;
    }

    public void close() throws IOException {
        this.stm.close();
    }

    private int fillBuf(int n) throws IOException {
        int n2;
        if (n > this.readAheadByteArray.length) {
            n = this.readAheadByteArray.length;
        }
        if ((n2 = this.readAheadByteCount - this.readAheadOffset) < n) {
            int n3;
            if (this.readAheadByteArray.length - this.readAheadOffset < n && this.readAheadOffset > 0) {
                n3 = this.markedReadAheadOffset > 0 ? this.markedReadAheadOffset : this.readAheadOffset;
                this.readAheadByteCount -= n3;
                if (this.readAheadByteCount > 0) {
                    System.arraycopy(this.readAheadByteArray, n3, this.readAheadByteArray, 0, this.readAheadByteCount);
                }
                this.markedReadAheadOffset -= n3;
                this.readAheadOffset -= n3;
            }
            n3 = this.readAheadByteArray.length - this.readAheadByteCount;
            if (!this.bufferInput) {
                n3 = n - n2;
            }
            while (n3 > 0) {
                int n4 = this.stm.read(this.readAheadByteArray, this.readAheadByteCount, n3);
                if (n4 == -1) {
                    if (n2 != 0) break;
                    n2 = -1;
                    break;
                }
                this.readAheadByteCount += n4;
                n2 += n4;
                n3 -= n4;
            }
        }
        return n2;
    }

    private int getEscapeChar() throws Exception {
        if ((chartype[this.peek] & 8) != 0) {
            return this.getOctalChar();
        }
        int n = this.nextByte();
        switch (n) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 98: {
                return 8;
            }
            case 102: {
                return 12;
            }
            case 256: {
                throw new EOFException();
            }
        }
        return n | 0x20000;
    }

    public static int getHexValue(int n) {
        if (n < 65) {
            return n - 48;
        }
        if (n < 97) {
            return n + -55;
        }
        return n + -87;
    }

    private char getOctalChar() throws Exception {
        char c = '\u0000';
        int n = 0;
        while ((chartype[this.peek] & 8) != 0 && n++ < 3) {
            c = (char)((c << 3) + (this.nextByte() - 48));
        }
        return c;
    }

    public int integerValue() {
        if (this.currType == 3) {
            return Math.round(this.realVal);
        }
        return this.integerVal;
    }

    public static boolean isHexDigit(int n) {
        return (chartype[n] & 4) != 0;
    }

    public String literalValue() {
        return this.literalVal;
    }

    private void loadPeek() throws IOException {
        if (this.peek == 256) {
            return;
        }
        if (this.readAheadByteCount <= this.readAheadOffset && this.fillBuf(1) < 0) {
            this.peek = 256;
            return;
        }
        this.peek = this.readAheadByteArray[this.readAheadOffset] & 0xFF;
    }

    public void mark(int n) {
        if (this.readAheadByteArray.length < n) {
            byte[] byArray = MemUtil.allocByte(n);
            if (this.readAheadByteCount > 0) {
                System.arraycopy(this.readAheadByteArray, 0, byArray, 0, this.readAheadByteCount);
            }
            this.readAheadByteArray = byArray;
        }
        this.markedReadAheadOffset = this.readAheadOffset;
        this.markedCurrPos = this.currPos;
        this.markedPeek = this.peek;
    }

    public boolean markSupported() {
        return true;
    }

    public String nameValue() {
        return this.nameVal;
    }

    private final int nextByte() throws IOException {
        int n = this.peek;
        if (this.peek != 256) {
            ++this.currPos;
            ++this.readAheadOffset;
            if (this.readAheadByteCount <= this.readAheadOffset && this.fillBuf(1) < 0) {
                this.peek = 256;
                return n;
            }
            this.peek = this.readAheadByteArray[this.readAheadOffset] & 0xFF;
        }
        return n;
    }

    protected int nextBytePeek() throws IOException {
        if (this.peek != 256) {
            ++this.currPos;
            ++this.readAheadOffset;
            if (this.readAheadByteCount <= this.readAheadOffset && this.fillBuf(1) < 0) {
                this.peek = 256;
                return this.peek;
            }
            this.peek = this.readAheadByteArray[this.readAheadOffset] & 0xFF;
        }
        return this.peek;
    }

    private int nextHexDigit() throws Exception {
        this.skipWhite();
        if (this.peek >= 48 && this.peek <= 57) {
            return this.nextByte() - 48;
        }
        if (this.peek >= 65 && this.peek <= 70) {
            return this.nextByte() + -55;
        }
        if (this.peek >= 97 && this.peek <= 102) {
            return this.nextByte() + -87;
        }
        if (this.peek == 256) {
            throw new EOFException();
        }
        throw new TokenizerException();
    }

    private int nextStringByte() throws Exception {
        int n;
        block3: {
            do {
                if ((n = this.nextByte()) == 256) {
                    throw new EOFException();
                }
                if (n == 41) {
                    return -2;
                }
                if (n != 92) break block3;
            } while (this.skipNewline());
            return this.getEscapeChar();
        }
        return n;
    }

    public void nextToken() throws Exception {
        this.cachedStringRep = null;
        this.loadPeek();
        this.skipWhite();
        this.currTokenStart = this.currPos;
        this.accumulateToken();
    }

    public int numBytesConsumed() {
        return this.currPos;
    }

    public int read() throws IOException {
        if (this.readAheadByteCount <= this.readAheadOffset && this.fillBuf(1) < 0) {
            return -1;
        }
        ++this.currPos;
        return this.readAheadByteArray[this.readAheadOffset++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (byArray.length - n < n2) {
            n2 = byArray.length - n;
        }
        while (n2 > 0) {
            int n4 = this.readAheadByteCount - this.readAheadOffset;
            if (n4 > n2) {
                n4 = n2;
            } else if (n4 <= 0) {
                if (this.fillBuf(n2) < 0) {
                    if (n3 != 0) break;
                    n3 = -1;
                    break;
                }
                n4 = this.readAheadByteCount - this.readAheadOffset;
                if (n4 > n2) {
                    n4 = n2;
                }
            }
            System.arraycopy(this.readAheadByteArray, this.readAheadOffset, byArray, n, n4);
            this.readAheadOffset += n4;
            this.currPos += n4;
            n3 += n4;
            n += n4;
            n2 -= n4;
        }
        return n3;
    }

    public float realValue() {
        if (this.currType == 2) {
            return this.integerVal;
        }
        return this.realVal;
    }

    public void reset() throws IOException {
        if (this.markedReadAheadOffset < 0) {
            throw new IOException("reset to invalid mark");
        }
        this.readAheadOffset = this.markedReadAheadOffset;
        this.currPos = this.markedCurrPos;
        this.peek = this.markedPeek;
    }

    protected void setIntegerValue(int n) {
        this.currType = 2;
        this.integerVal = n;
    }

    protected void setLiteralValue(String string) {
        this.currType = 5;
        this.literalVal = string;
    }

    protected void setNameValue(String string) {
        this.currType = 4;
        this.nameVal = string;
    }

    protected void setRealValue(float f) {
        this.currType = 3;
        this.realVal = f;
    }

    protected void setStringValue(byte[] byArray) {
        this.currType = 1;
        this.stringVal = byArray;
    }

    public long skip(long l) throws IOException {
        if (l > 0L) {
            int n = this.readAheadByteCount - this.readAheadOffset;
            int n2 = l > (long)this.readAheadByteArray.length ? this.readAheadByteArray.length : (int)l;
            if (n > n2) {
                n = n2;
            }
            if (n > 0) {
                this.readAheadOffset += n;
                this.currPos += n;
                return n;
            }
            if (this.markedReadAheadOffset >= 0) {
                if (this.fillBuf(n2) < 0) {
                    return -1L;
                }
                n = this.readAheadByteCount - this.readAheadOffset;
                if (n > n2) {
                    n = n2;
                }
                this.readAheadOffset += n;
                this.currPos += n;
                return n;
            }
            return this.stm.skip(l);
        }
        return 0L;
    }

    public void skipEndstream() throws Exception {
        while (true) {
            if (this.readAheadByteCount - this.readAheadOffset >= 9) {
                int n = this.readAheadOffset;
                if (this.readAheadByteArray[this.readAheadOffset++] == 101 && this.readAheadByteArray[this.readAheadOffset++] == 110 && this.readAheadByteArray[this.readAheadOffset++] == 100 && this.readAheadByteArray[this.readAheadOffset++] == 115 && this.readAheadByteArray[this.readAheadOffset++] == 116 && this.readAheadByteArray[this.readAheadOffset++] == 114 && this.readAheadByteArray[this.readAheadOffset] == 101 && this.readAheadByteArray[this.readAheadOffset + 1] == 97 && this.readAheadByteArray[this.readAheadOffset + 2] == 109) {
                    this.readAheadOffset += 3;
                    this.currPos += this.readAheadOffset - n;
                    return;
                }
                this.currPos += this.readAheadOffset - n;
                continue;
            }
            if (this.fillBuf(9) < 9) break;
        }
    }

    private boolean skipNewline() throws Exception {
        boolean bl = false;
        if (this.peek == 13) {
            this.nextByte();
            bl = true;
        }
        if (this.peek == 10) {
            this.nextByte();
            bl = true;
        }
        return bl;
    }

    public void skipToToken() throws Exception {
        this.loadPeek();
        while ((chartype[this.peek] & 0x111) != 0 && this.peek != 256) {
            this.nextByte();
        }
    }

    public void skipWhite() throws Exception {
        while (true) {
            if ((chartype[this.peek] & 2) != 0) {
                this.nextByte();
                continue;
            }
            if (this.peek != 37) break;
            while ((chartype[this.nextBytePeek()] & 0x10) == 0) {
            }
        }
    }

    public String stringValue() {
        if (this.cachedStringRep == null) {
            switch (this.currType) {
                case 1: {
                    this.cachedStringRep = Util.stringFromRawBytes(this.stringVal);
                    break;
                }
                case 5: {
                    this.cachedStringRep = this.literalVal;
                    break;
                }
                case 4: {
                    this.cachedStringRep = "/" + this.nameVal;
                    break;
                }
                case 2: {
                    this.cachedStringRep = java.lang.Integer.toString(this.integerVal, 10);
                    break;
                }
                case 3: {
                    this.cachedStringRep = Float.toString(this.realVal);
                    break;
                }
            }
        }
        return this.cachedStringRep;
    }

    public int tokenStart() {
        return this.currTokenStart;
    }

    public int type() {
        return this.currType;
    }
}

