/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.util;

import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.pe.awt.VImage;
import com.adobe.pe.vtypes.VString;
import com.adobe.util.MemUtil;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import netscape.security.PrivilegeManager;

public class Util
extends MemUtil {
    private static String baseResourceDir;
    private static ResourceBundle fToolTipStrings;
    private static boolean loadedToolTipStrings;
    private static ResourceBundle fErrorStrings;
    private static boolean loadedErrorStrings;
    private static ResourceBundle fAcroViewContextStrings;
    private static boolean loadedAcroViewContextStrings;
    private static ResourceBundle fMenuStrings;
    private static boolean loadedMenuStrings;
    private static ResourceBundle fDialogStrings;
    private static boolean loadedDialogStrings;
    private static byte[] charMap;
    static /* synthetic */ Class class$com$adobe$acrobat$Viewer;

    static {
        int n;
        baseResourceDir = null;
        fToolTipStrings = null;
        loadedToolTipStrings = false;
        fErrorStrings = null;
        loadedErrorStrings = false;
        fAcroViewContextStrings = null;
        loadedAcroViewContextStrings = false;
        fMenuStrings = null;
        loadedMenuStrings = false;
        fDialogStrings = null;
        loadedDialogStrings = false;
        String string = "$-_.+!*'(),0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        String string2 = ";/?:@=&";
        charMap = new byte[128];
        int n2 = 0;
        while (n2 < charMap.length) {
            Util.charMap[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < string.length()) {
            n = string.charAt(n3);
            Util.charMap[n] = 1;
            ++n3;
        }
        n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            Util.charMap[c] = 2;
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String decodeURL(String var0) {
        var0 = var0.trim();
        var1_1 = new StringBuffer(var0.length());
        var2_2 = 0;
        while (var2_2 < var0.length()) {
            var3_3 = var0.charAt(var2_2);
            if (var3_3 != '%' || var2_2 >= var0.length() - 2) ** GOTO lbl-1000
            var4_4 = var0.charAt(var2_2 + 1);
            var5_5 = var0.charAt(var2_2 + 2);
            if (Util.isHex(var4_4) && Util.isHex(var5_5) && ((var6_6 = (char)((Util.fromHex(var4_4) << 4) + Util.fromHex(var5_5))) >= '\u0080' || Util.charMap[var6_6] != 2)) {
                var1_1.append(var6_6);
                var2_2 += 2;
            } else lbl-1000:
            // 2 sources

            {
                var1_1.append(var3_3);
            }
            ++var2_2;
        }
        return var1_1.toString();
    }

    public static String encodeURL(String string) {
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '\u0080' && charMap[c] != 0) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('%');
                stringBuffer.append(Util.toHex(c >> 4));
                stringBuffer.append(Util.toHex(c));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static int fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 122 + 10;
        }
        return 0;
    }

    public static String getAcroViewContextString(String string) {
        if (!loadedAcroViewContextStrings) {
            fAcroViewContextStrings = Util.getResourceBundle("com.adobe.acrobat.resources.AcroViewContextStrings");
            loadedAcroViewContextStrings = true;
        }
        return Util.getResourceString(fAcroViewContextStrings, string);
    }

    public static String getAcroViewContextString(String string, Object object) {
        return Util.getAcroViewContextString(string, new Object[]{object});
    }

    public static String getAcroViewContextString(String string, Object object, Object object2) {
        return Util.getAcroViewContextString(string, new Object[]{object, object2});
    }

    public static String getAcroViewContextString(String string, Object object, Object object2, Object object3) {
        return Util.getAcroViewContextString(string, new Object[]{object, object2, object3});
    }

    public static String getAcroViewContextString(String string, Object[] objectArray) {
        return MessageFormat.format(Util.getAcroViewContextString(string), objectArray);
    }

    public static String getDialogString(String string) {
        if (!loadedDialogStrings) {
            fDialogStrings = Util.getResourceBundle("com.adobe.acrobat.resources.DialogStrings");
            loadedDialogStrings = true;
        }
        return Util.getResourceString(fDialogStrings, string);
    }

    public static String getDialogString(String string, Object object) {
        return Util.getDialogString(string, new Object[]{object});
    }

    public static String getDialogString(String string, Object object, Object object2) {
        return Util.getDialogString(string, new Object[]{object, object2});
    }

    public static String getDialogString(String string, Object object, Object object2, Object object3) {
        return Util.getDialogString(string, new Object[]{object, object2, object3});
    }

    public static String getDialogString(String string, Object[] objectArray) {
        return MessageFormat.format(Util.getDialogString(string), objectArray);
    }

    public static String getErrorString(String string) {
        if (!loadedErrorStrings) {
            fErrorStrings = Util.getResourceBundle("com.adobe.acrobat.resources.ErrorStrings");
            loadedErrorStrings = true;
        }
        return Util.getResourceString(fErrorStrings, string);
    }

    public static String getErrorString(String string, Object object) {
        return Util.getErrorString(string, new Object[]{object});
    }

    public static String getErrorString(String string, Object object, Object object2) {
        return Util.getErrorString(string, new Object[]{object, object2});
    }

    public static String getErrorString(String string, Object object, Object object2, Object object3) {
        return Util.getErrorString(string, new Object[]{object, object2, object3});
    }

    public static String getErrorString(String string, Object[] objectArray) {
        return MessageFormat.format(Util.getErrorString(string), objectArray);
    }

    public static String getMenuString(String string) {
        if (!loadedMenuStrings) {
            fMenuStrings = Util.getResourceBundle("com.adobe.acrobat.resources.MenuStringsBundle");
            loadedMenuStrings = true;
        }
        return Util.getResourceString(fMenuStrings, string);
    }

    public static VString getMenuVString(String string) {
        return new VString(Util.getMenuString(string));
    }

    public static Image getMyImage(String string) {
        Image image = null;
        try {
            byte[] byArray = Util.getMyResource(string);
            if (byArray == null || byArray.length == 0) {
                Log.log("Image " + string + " not found.");
                byArray = new byte[]{};
            }
            image = Toolkit.getDefaultToolkit().createImage(byArray);
        }
        catch (Exception exception) {
            Log.log("Unable to read image " + string);
            Log.logStackTrace(exception);
            image = null;
        }
        return image;
    }

    public static byte[] getMyResource(String string) {
        byte[] byArray = null;
        try {
            InputStream inputStream = Util.getResourceAsStream(string);
            if (inputStream == null) {
                Log.log("Resource " + string + " not found.");
            } else {
                byArray = Util.readStreamIntoByteArray(inputStream);
            }
        }
        catch (Exception exception) {
            Log.log("Unable to read resource: " + string);
            Log.logStackTrace(exception);
        }
        return byArray;
    }

    public static InputStream getResourceAsStream(String string) {
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            Log.clog("*** " + (baseResourceDir == null ? "resources/" + string : String.valueOf(baseResourceDir) + string));
            InputStream inputStream = null;
            if (baseResourceDir == null) {
                inputStream = (class$com$adobe$acrobat$Viewer != null ? class$com$adobe$acrobat$Viewer : (class$com$adobe$acrobat$Viewer = Util.class$("com.adobe.acrobat.Viewer"))).getResourceAsStream("resources/" + string);
                if (inputStream == null) {
                    inputStream = Util.getResourceFromServer(string);
                }
            } else {
                try {
                    inputStream = new FileInputStream(String.valueOf(baseResourceDir) + string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = Util.getResourceFromServer(string);
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            Log.log("Util.getResourceAsStream: " + exception.toString());
            return null;
        }
    }

    private static ResourceBundle getResourceBundle(String string) {
        ResourceBundle resourceBundle = null;
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Log.log(missingResourceException.getMessage());
        }
        return resourceBundle;
    }

    private static InputStream getResourceFromServer(String string) throws Exception {
        InputStream inputStream;
        block5: {
            String string2 = ReaderPrefs.getProperty("com.adobe.acrobat.resources.Server", "");
            inputStream = null;
            if (string2.equals("")) break block5;
            try {
                Session session = Session.getTheSession();
                if (session.isIE()) {
                    PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                } else if (session.isNetscape()) {
                    PrivilegeManager.enablePrivilege((String)"UniversalConnect");
                }
                URL uRL = new URL(String.valueOf(string2) + "/" + string);
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
            }
            catch (Exception exception) {
                Log.clog("Util.getResourceFromServer: " + exception.toString());
            }
        }
        return inputStream;
    }

    public static Image getResourceImage(String string) {
        return Util.getMyImage(string);
    }

    private static String getResourceString(ResourceBundle resourceBundle, String string) {
        String string2;
        block2: {
            string2 = string;
            if (resourceBundle == null) break block2;
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                Log.log(missingResourceException.getMessage());
            }
        }
        return string2;
    }

    public static VImage getResourceVImage(String string) {
        return new VImage(Util.getMyImage(string));
    }

    public static String getToolTipString(String string) {
        if (!loadedToolTipStrings) {
            fToolTipStrings = Util.getResourceBundle("com.adobe.acrobat.resources.ToolTipStrings");
            loadedToolTipStrings = true;
        }
        return Util.getResourceString(fToolTipStrings, string);
    }

    public static Point globalToLocal(Component component, Point point) {
        Point point2 = new Point(point);
        while (component != null) {
            Point point3 = component.getLocation();
            point2.x -= point3.x;
            point2.y -= point3.y;
        }
        return point2;
    }

    public static Rectangle globalToLocal(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        while (component != null) {
            Point point = component.getLocation();
            rectangle2.translate(-point.x, -point.y);
            component = component.getParent();
        }
        return rectangle2;
    }

    public static boolean hasInternationalFonts() {
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            if (baseResourceDir == null) {
                return Util.getResourceAsStream("Fonts/SMMyungjo-Medium") != null;
            }
            File file = new File(String.valueOf(baseResourceDir) + "Fonts");
            return file.exists() && file.isDirectory() && file.list().length > 0;
        }
        catch (Exception exception) {
            Log.log(exception.toString());
            return false;
        }
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static Point localToGlobal(Component component, Point point) {
        Point point2 = new Point(point);
        while (component != null) {
            Point point3 = component.getLocation();
            point2.x += point3.x;
            point2.y += point3.y;
        }
        return point2;
    }

    public static Rectangle localToGlobal(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        while (component != null) {
            Point point = component.getLocation();
            rectangle2.translate(point.x, point.y);
            component = component.getParent();
        }
        return rectangle2;
    }

    public static byte[] rawBytesFromString(String string) {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            byArray = MemUtil.allocByte(n);
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)string.charAt(n2);
                ++n2;
            }
        }
        return byArray;
    }

    public static byte[] readStreamIntoByteArray(InputStream inputStream) throws Exception {
        byte[] byArray = null;
        if (inputStream != null) {
            int n = inputStream.available();
            if (n == 1) {
                n = 2048;
            }
            byArray = MemUtil.allocByte(n);
            int n2 = 0;
            while (inputStream.available() > 0) {
                int n3;
                if (n2 == byArray.length) {
                    byte[] byArray2 = MemUtil.allocByte(byArray.length + 2048);
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    byArray = byArray2;
                }
                if ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) < 0) break;
                n2 += n3;
            }
            if (n2 < byArray.length) {
                byte[] byArray3 = MemUtil.allocByte(n2);
                System.arraycopy(byArray, 0, byArray3, 0, n2);
                byArray = byArray3;
            }
        }
        return byArray;
    }

    public static void setBaseResourceDirectory(String string) {
        if (string != null && string.length() > 0) {
            baseResourceDir = String.valueOf(string) + File.separatorChar;
        }
    }

    public static String stringFromRawBytes(byte[] byArray) {
        return Util.stringFromRawBytes(byArray, 0, byArray.length);
    }

    public static String stringFromRawBytes(byte[] byArray, int n, int n2) {
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        char[] cArray = MemUtil.allocChar(n2);
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)(byArray[n + n3] & 0xFF);
            ++n3;
        }
        return new String(cArray);
    }

    private static char toHex(int n) {
        if ((n &= 0xF) <= 9) {
            return (char)(n + 48);
        }
        return (char)(n + 65 - 10);
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
    }
}

