/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class MultilineLabel
extends Component {
    private static final int kInset = 2;
    public static final int LEFT = -1;
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    private String text;
    private int alignment;
    private int lbWidth = -1;
    private Vector lineBreaks = new Vector();
    private Dimension prefSize;
    private Dimension minSize;

    public MultilineLabel() {
        this("", -1);
    }

    public MultilineLabel(String string) {
        this(string, -1);
    }

    public MultilineLabel(String string, int n) {
        this.setFont(new Font("SansSerif", 0, 11));
        this.alignment = n;
        this.setText(string);
    }

    private Dimension computeLineBreaks(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (n <= 0) {
            this.lineBreaks.setSize(0);
            return new Dimension(0, 0);
        }
        if (n != this.lbWidth) {
            this.lineBreaks.setSize(0);
            int n2 = 0;
            while (n2 < this.text.length()) {
                int n3 = this.findLineEnd(fontMetrics, n, n2);
                this.lineBreaks.addElement(new Integer(n3));
                n2 = n3 + 1;
            }
            this.lbWidth = n;
        }
        return new Dimension(n, fontMetrics.getHeight() * this.lineBreaks.size() + 4);
    }

    private int findLineEnd(FontMetrics fontMetrics, int n, int n2) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = this.text.indexOf(10, n2);
        n6 = n6 < 0 ? this.text.length() : ++n6;
        while (n5 < n6) {
            n4 = this.findNextWhiteSpace(n5, n6);
            n3 = fontMetrics.stringWidth(this.text.substring(n2, n4));
            if (n3 >= n) break;
            n5 = n4;
        }
        if (n5 == n2) {
            n4 = n2 + 1;
            while (n4 < n6) {
                n3 = fontMetrics.stringWidth(this.text.substring(n2, n4));
                if (n3 > n) break;
                ++n4;
            }
            return Math.max(n2, n4 - 1);
        }
        if (n5 >= n6) {
            n5 = n6 - 1;
        }
        return n5;
    }

    private int findNextNonWhitespace(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (!Character.isWhitespace(this.text.charAt(n3))) {
                return n3;
            }
            ++n3;
        }
        return this.text.length();
    }

    private int findNextWhiteSpace(int n, int n2) {
        int n3 = this.findNextNonWhitespace(n, n2);
        while (n3 < n2) {
            if (Character.isWhitespace(this.text.charAt(n3))) break;
            ++n3;
        }
        return n3;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = this.computeLineBreaks(200);
        }
        return this.minSize;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            int n = this.getParent().getSize().width;
            if (n == 0) {
                return this.getMinimumSize();
            }
            this.prefSize = this.computeLineBreaks(n);
        }
        return this.prefSize;
    }

    public String getText() {
        return this.text;
    }

    private boolean hasRealLines() {
        return this.text.indexOf(10) >= 0;
    }

    public static void main(String[] stringArray) {
        final Frame frame = new Frame("Test Label");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                frame.dispose();
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        MultilineLabel multilineLabel = new MultilineLabel("This is a sample test of the multiline label that should resize when its container is resized.");
        frame.add((Component)multilineLabel, "Center");
        ((Component)frame).setSize(100, 100);
        frame.show();
    }

    public void paint(Graphics graphics) {
        this.computeLineBreaks(this.getSize().width);
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 2 + fontMetrics.getAscent();
        int n2 = this.getSize().width;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.lineBreaks.size()) {
            int n5;
            int n6 = (Integer)this.lineBreaks.elementAt(n4) + 1;
            String string = Character.isWhitespace(this.text.charAt(n6 - 1)) ? this.text.substring(n3, n6 - 1) : this.text.substring(n3, n6);
            if (this.alignment == -1) {
                n5 = 2;
            } else {
                int n7 = fontMetrics.stringWidth(string);
                n5 = this.alignment == 1 ? n2 - 2 - n7 : (n2 - n7) / 2;
            }
            graphics.drawString(string, n5, n);
            n += fontMetrics.getHeight();
            n3 = n6;
            ++n4;
        }
    }

    public void setAlignment(int n) {
        if (this.alignment != n) {
            this.alignment = n;
            this.invalidate();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.prefSize == null) {
            this.getPreferredSize();
            this.invalidate();
        } else if (this.prefSize.width < n3) {
            Dimension dimension = this.computeLineBreaks(n3);
            this.invalidate();
            super.setBounds(n, n2, dimension.width, dimension.height);
        } else {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public void setText(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            n = stringBuffer.charAt(n2);
            if (Character.isWhitespace((char)n)) {
                if (!(bl || n != 13 && n != 10)) {
                    stringBuffer.setCharAt(n2, '\n');
                    bl = true;
                } else {
                    stringBuffer.setCharAt(n2, ' ');
                }
            } else {
                bl = false;
            }
            ++n2;
        }
        n = stringBuffer.length();
        while (n > 0 && Character.isWhitespace(string.charAt(n - '\u0001'))) {
            --n;
        }
        stringBuffer.setLength(n);
        this.text = stringBuffer.toString();
        this.prefSize = null;
        this.invalidate();
    }
}

