/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.pe.awt.VDimension;
import com.adobe.pe.awt.VInsets;
import com.adobe.pe.awt.VRectangle;
import com.adobe.pe.awt.VScrollValue;
import com.adobe.pe.awt.VScrollbar;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.vtypes.VInt;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

public class ScrollerLogic {
    public static final int kPegLeft = -1;
    public static final int kPegTop = -1;
    public static final int kCenter = 0;
    public static final int kPegRight = 1;
    public static final int kPegBottom = 1;
    public VScrollbar vVscrollbar;
    public VScrollbar vHscrollbar;
    public VInt vHInValue;
    public VInt vVInValue;
    VInt vContaineeWidth;
    VInt vContaineeHeight;
    public VDimension vScrollPaneSize;
    public VInsets vScrollPaneInsets;
    int hTooSmallLogic;
    int vTooSmallLogic;
    public VInt vHOutValue;
    public VInt vVOutValue;
    public VDimension vAperture;
    public VDimension vInterior;
    public VRectangle vApertureRectangle;

    public ScrollerLogic(VInt vInt, VInt vInt2, int n, int n2) {
        this.vContaineeWidth = vInt;
        this.vContaineeHeight = vInt2;
        this.hTooSmallLogic = n;
        this.vTooSmallLogic = n2;
        this.vScrollPaneSize = new VDimension(0, 0);
        this.vScrollPaneInsets = new VInsets(new Insets(0, 0, 0, 0));
        this.vInterior = new VScrollPaneInterior();
        this.vAperture = new VScrollPaneAperture();
        if (vInt != null) {
            this.vHInValue = new VInt(0);
            this.vHOutValue = new VScrollValue(this, true);
            this.vHscrollbar = new VScrollbar(this, 0);
        } else {
            this.vHOutValue = new VInt(0);
        }
        if (vInt2 != null) {
            this.vVInValue = new VInt(0);
            this.vVOutValue = new VScrollValue(this, false);
            this.vVscrollbar = new VScrollbar(this, 1);
        } else {
            this.vVOutValue = new VInt(0);
        }
        this.vApertureRectangle = new VApertureRectangle();
    }

    public int getHScrollMax(Requester requester) throws Exception {
        if (this.vContaineeWidth != null) {
            Dimension dimension = this.vAperture.dimensionValue(requester);
            int n = this.vContaineeWidth.intValue(requester);
            if (n > dimension.width) {
                return n - dimension.width;
            }
        }
        return 0;
    }

    public int getVScrollMax(Requester requester) throws Exception {
        if (this.vContaineeHeight != null) {
            Dimension dimension = this.vAperture.dimensionValue(requester);
            int n = this.vContaineeHeight.intValue(requester);
            if (n > dimension.height) {
                return n - dimension.height;
            }
        }
        return 0;
    }

    class VScrollPaneInterior
    extends VDimension {
        VScrollPaneInterior() {
        }

        protected final Dimension computeDimension(Requester requester) throws Exception {
            Dimension dimension = ScrollerLogic.this.vScrollPaneSize.dimensionValue(requester);
            Dimension dimension2 = new Dimension(dimension);
            Insets insets = ScrollerLogic.this.vScrollPaneInsets.insetsValue(requester);
            Dimension dimension3 = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
            dimension2.width -= dimension3.width;
            dimension2.height -= dimension3.height;
            return dimension2;
        }
    }

    class VScrollPaneAperture
    extends VDimension {
        VScrollPaneAperture() {
        }

        protected final Dimension computeDimension(Requester requester) throws Exception {
            boolean bl;
            boolean bl2;
            Dimension dimension = ScrollerLogic.this.vInterior.dimensionValue(requester);
            Dimension dimension2 = new Dimension(dimension);
            int n = ScrollerLogic.this.vContaineeWidth != null ? ScrollerLogic.this.vContaineeWidth.intValue(requester) : 0;
            int n2 = ScrollerLogic.this.vContaineeHeight != null ? ScrollerLogic.this.vContaineeHeight.intValue(requester) : 0;
            Container container = null;
            boolean bl3 = bl2 = n2 > dimension2.height;
            if (ScrollerLogic.this.vVscrollbar != null) {
                container = ScrollerLogic.this.vVscrollbar.getParent();
                ScrollerLogic.this.vVscrollbar.setVisible(bl2);
                if (bl2) {
                    dimension2.width -= ScrollerLogic.this.vVscrollbar.getSize().width;
                }
            }
            boolean bl4 = bl = n > dimension2.width;
            if (ScrollerLogic.this.vHscrollbar != null) {
                container = ScrollerLogic.this.vHscrollbar.getParent();
                ScrollerLogic.this.vHscrollbar.setVisible(bl);
                if (bl) {
                    dimension2.height -= ScrollerLogic.this.vHscrollbar.getSize().height;
                }
                if (!bl2 && ScrollerLogic.this.vVscrollbar != null) {
                    boolean bl5 = bl2 = n2 > dimension2.height;
                    if (bl2) {
                        ScrollerLogic.this.vVscrollbar.setVisible(bl2);
                        dimension2.width -= ScrollerLogic.this.vVscrollbar.getSize().width;
                    }
                }
            }
            if (container != null) {
                container.invalidate();
                container.validate();
            }
            return dimension2;
        }
    }

    class VApertureRectangle
    extends VRectangle {
        VApertureRectangle() {
        }

        protected final Rectangle computeRectangle(Requester requester) throws Exception {
            Dimension dimension = ScrollerLogic.this.vAperture.dimensionValue(requester);
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            if (ScrollerLogic.this.vHOutValue != null) {
                rectangle.x = ScrollerLogic.this.vHOutValue.intValue(requester);
            }
            if (ScrollerLogic.this.vVOutValue != null) {
                rectangle.y = ScrollerLogic.this.vVOutValue.intValue(requester);
            }
            return rectangle;
        }
    }
}

