/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.acrobat.RenderingObserver;
import com.adobe.acrobat.gui.SpinnyButton;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.VPaintingCanvasDrawThread;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.PaintingSampler;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.util.Assert;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.InterruptedIOException;

public class VPaintingCanvas
extends Component
implements VObserver,
StrobeContainer {
    VBoolean vDrawingBoolean = new VBoolean(false);
    private VSynchronizer vDrawingSynchronizer = new VSynchronizer();
    private RenderingObserver rd;
    SpinnyButton spinnyButton;
    private Object drawingMonitor = new Object();
    private Throwable lastException = null;
    private Rectangle oldClipBounds = null;
    VPaintingCanvasDrawThread drawThread = null;
    private VPainting vPainting;
    private int drawingCount = 0;
    private VStrobe strobe;

    public VPaintingCanvas(VPainting vPainting) {
        this.setVPainting(vPainting);
    }

    public void addSpinny(SpinnyButton spinnyButton) {
        this.spinnyButton = spinnyButton;
    }

    private void broadcastDrawing(final boolean bl) {
        if (this.rd != null && !bl) {
            this.rd.renderingDone();
        }
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                vDrawingBoolean.setBooleanValue(transaction, bl);
            }
        };
        this.vDrawingSynchronizer.setTransactor(null, transactor);
    }

    public void change(Requester requester) throws WriteLockException {
        if (this.vPainting != null) {
            try {
                this.stopCurrentDrawThread();
                Painting painting = this.vPainting.paintingValue(requester);
                this.repaint();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Log.clog("VPaintingCanvas.change: " + throwable.toString());
                this.reportError(throwable);
            }
        }
    }

    void decDrawing() {
        boolean bl;
        boolean bl2 = bl = --this.drawingCount == 0;
        if (bl) {
            this.broadcastDrawing(false);
            if (this.spinnyButton != null) {
                this.spinnyButton.setRunning(false);
            }
        }
    }

    private synchronized void drawFromPainting(Graphics graphics) throws Throwable {
        Painting painting = this.vPainting.paintingValue(null);
        if (painting != null) {
            Rectangle rectangle = painting.getBounds();
            Rectangle rectangle2 = graphics.getClipBounds();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            this.incDrawing();
            PaintingSampler paintingSampler = painting.acquireSampler(painting.getBounds());
            if (paintingSampler != null) {
                Dimension dimension = this.getSize();
                Rectangle rectangle3 = new Rectangle(0, 0, dimension.width, dimension.height);
                rectangle = rectangle.intersection(rectangle3);
                Shape shape = graphics.getClip();
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (this.drawThread != null && this.drawThread.isAlive()) {
                    rectangle = rectangle.union(this.drawThread.clipBounds);
                    rectangle = rectangle.intersection(rectangle3);
                    this.stopCurrentDrawThread();
                    graphics.setClip(rectangle);
                }
                if (!paintingSampler.waitAndSample(graphics, true, 0L)) {
                    this.drawThread = new VPaintingCanvasDrawThread(this, paintingSampler, rectangle);
                    this.incDrawing();
                    this.drawThread.start();
                }
                graphics.setClip(shape);
            }
            this.decDrawing();
        }
    }

    public VBoolean getVDrawingBoolean() {
        return this.vDrawingBoolean;
    }

    void incDrawing() {
        boolean bl;
        boolean bl2 = bl = this.drawingCount++ == 0;
        if (bl) {
            this.broadcastDrawing(true);
        }
    }

    public void paint(Graphics graphics) {
        if (this.vPainting == null) {
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            return;
        }
        try {
            this.drawFromPainting(graphics);
        }
        catch (Throwable throwable) {
            Log.logStackTrace(throwable);
            this.reportError(throwable);
        }
    }

    void reportError(Throwable throwable) {
        TransactionExecutionContext transactionExecutionContext;
        if (throwable instanceof WriteLockException || throwable instanceof InterruptedException || throwable instanceof InterruptedIOException) {
            return;
        }
        if (throwable == this.lastException) {
            return;
        }
        this.lastException = throwable;
        Transaction transaction = this.vPainting.getLastOwnerTransaction();
        TransactionExecutionContext transactionExecutionContext2 = transactionExecutionContext = transaction == null ? null : transaction.getExecutionContext();
        if (transactionExecutionContext != null) {
            transactionExecutionContext.reportError(transaction, throwable, false);
        }
    }

    public void setRenderingObserver(RenderingObserver renderingObserver) {
        this.rd = renderingObserver;
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    public void setVPainting(VPainting vPainting) {
        Assert.notFalse(this.vPainting == null);
        this.vPainting = vPainting;
        this.strobe = new VStrobe(this);
    }

    private synchronized void stopCurrentDrawThread() {
        VPaintingCanvasDrawThread vPaintingCanvasDrawThread = this.drawThread;
        try {
            try {
                while (vPaintingCanvasDrawThread != null && vPaintingCanvasDrawThread.isAlive()) {
                    vPaintingCanvasDrawThread.setStop();
                    vPaintingCanvasDrawThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            Object var3_2 = null;
            this.drawThread = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.drawThread = null;
            throw throwable;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

