/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.debug;

import com.adobe.pe.notify.DependencyInspectorFriend;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class DependencyInspector
extends Frame
implements ActionListener,
ItemListener {
    Vector roots;
    Choice rootsChoice;
    List dependeesList;
    Label dependeesLabel;
    List dependentsList;
    Label dependentsLabel;
    Label nodeLabel;
    Label nodeValueLabel;
    Button refreshButton;
    VValue node;
    static final int refreshButtonHeight = 24;
    static final int popupHeight = 24;
    static final int labelHeight = 15;
    static final int margin = 3;

    public DependencyInspector(VValue vValue) {
        super("Dependency Inspector");
        this.setLayout(null);
        this.addNotify();
        this.roots = new Vector();
        this.roots.addElement(vValue);
        this.dependeesList = new List();
        this.dependeesList.addActionListener(this);
        this.dependentsList = new List();
        this.dependentsList.addActionListener(this);
        this.nodeLabel = new Label();
        this.dependeesLabel = new Label("Notifiers", 1);
        this.dependentsLabel = new Label("Observers", 1);
        this.refreshButton = new Button("Refresh");
        this.refreshButton.addActionListener(this);
        this.nodeValueLabel = new Label();
        this.add(this.dependeesList);
        this.add(this.dependentsList);
        this.add(this.nodeLabel);
        this.add(this.nodeValueLabel);
        this.add(this.dependeesLabel);
        this.add(this.dependentsLabel);
        this.add(this.refreshButton);
        this.populateRootsChoice();
        this.setNode(vValue);
        this.setBounds(0, 0, 600, 250);
        ((Component)this).setLocation(705, 200);
        this.addWindowListener(new MyWindowAdapter());
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Requester requester;
        if (actionEvent.getSource() == this.dependentsList && (requester = (Requester)this.node.getObservers().elementAt(this.dependentsList.getSelectedIndex())) instanceof VValue.ComputationRequester) {
            VValue vValue = ((VValue.ComputationRequester)requester).getVValue();
            this.setNode(vValue);
        }
        if (actionEvent.getSource() == this.dependeesList) {
            this.setNode((VValue)this.node.getNotifiers().elementAt(this.dependeesList.getSelectedIndex()));
        }
        if (actionEvent.getSource() == this.refreshButton) {
            this.setNode(this.node);
        }
    }

    public void addRoot(VValue vValue) {
        this.roots.addElement(vValue);
        this.populateRootsChoice();
    }

    public void doLayout() {
        if (this.rootsChoice != null) {
            this.layoutChildren();
        }
    }

    String getShortNameFor(Object object) {
        String string;
        if (object instanceof VValue.ComputationRequester) {
            object = ((VValue.ComputationRequester)object).getVValue();
        }
        if (object instanceof DependencyInspectorFriend) {
            DependencyInspectorFriend dependencyInspectorFriend = (DependencyInspectorFriend)object;
            string = dependencyInspectorFriend.getInfo(1);
        } else {
            string = object.toString();
        }
        return string;
    }

    String getShortNameWithCount(Object object) {
        boolean bl = false;
        if (object instanceof VValue.ComputationRequester) {
            bl = ((Requester)object).isInterrupted();
            object = ((VValue.ComputationRequester)object).getVValue();
        }
        String string = this.getShortNameFor(object);
        if (object instanceof VValue) {
            if (bl) {
                string = "@" + string;
            }
            if (((VValue)object).isDirty()) {
                string = "*" + string;
            }
            string = String.valueOf(string) + " (" + ((VValue)object).countObservers(false) + "," + ((VValue)object).countObservers(true) + ")";
        }
        return string;
    }

    String getValue(Object object) {
        if (object instanceof VValue.ComputationRequester) {
            object = ((VValue.ComputationRequester)object).getVValue();
        }
        String string = null;
        if (object instanceof DependencyInspectorFriend) {
            string = ((DependencyInspectorFriend)object).getInfo(3);
        }
        return string;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.rootsChoice) {
            this.setNode((VValue)this.roots.elementAt(this.rootsChoice.getSelectedIndex()));
        }
    }

    private void layoutChildren() {
        Insets insets = this.getInsets();
        int n = this.getSize().width - (insets.left + insets.right);
        int n2 = this.getSize().height - (insets.bottom + insets.top);
        int n3 = (n - 12) / 3;
        this.rootsChoice.setBounds(insets.left + 6 + n3, insets.top + 3, n3, 24);
        this.dependeesLabel.setBounds(insets.left + 3, insets.top + 3, n3, 15);
        this.dependeesList.setBounds(insets.left + 3, insets.top + 6 + 15, n3, n2 - 15 - 9);
        this.refreshButton.setBounds(insets.left + 9 + 2 * n3, insets.top + 3, n3, 24);
        this.dependentsLabel.setBounds(insets.left + 9 + 2 * n3, insets.top + 6 + 24, n - 12 - 2 * n3, 15);
        this.dependentsList.setBounds(insets.left + 9 + 2 * n3, insets.top + 6 + 24 + 15, n - 12 - 2 * n3, n2 - 9 - 15 - 24);
        this.nodeLabel.setBounds(insets.left + 6 + n3, insets.top + 6 + 24, n3, 15);
        this.nodeValueLabel.setBounds(insets.left + 6 + n3, insets.top + 9 + 24 + 15, n3, n2 - 9 - 24 - 15);
    }

    private void populateDependeesList() {
        this.dependeesList.removeAll();
        VValue vValue = this.node;
        synchronized (vValue) {
            Vector vector = this.node.getNotifiers();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    this.dependeesList.addItem(this.getShortNameWithCount((VValue)vector.elementAt(n)));
                    ++n;
                }
            }
        }
    }

    private void populateDependentsList() {
        this.dependentsList.removeAll();
        Vector vector = this.node.getObservers();
        if (vector != null) {
            VValue vValue = this.node;
            synchronized (vValue) {
                int n = 0;
                while (n < vector.size()) {
                    this.dependentsList.addItem(this.getShortNameWithCount((Requester)vector.elementAt(n)));
                    ++n;
                }
            }
        }
    }

    private void populateRootsChoice() {
        if (this.rootsChoice != null) {
            this.remove(this.rootsChoice);
        }
        this.rootsChoice = new Choice();
        this.rootsChoice.addItemListener(this);
        int n = 0;
        while (n < this.roots.size()) {
            this.rootsChoice.addItem(this.getShortNameFor(this.roots.elementAt(n)));
            ++n;
        }
        this.add(this.rootsChoice);
        this.layoutChildren();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.layoutChildren();
    }

    public void setNode(VValue vValue) {
        this.node = vValue;
        this.nodeLabel.setText(this.getShortNameWithCount(vValue));
        this.nodeValueLabel.setText(this.getValue(vValue));
        this.populateDependeesList();
        this.populateDependentsList();
    }

    class MyWindowAdapter
    extends WindowAdapter {
        MyWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            DependencyInspector.this.dispose();
        }
    }
}

