/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.painting;

import com.adobe.acrobat.sidecar.GraphicsUtils;
import com.adobe.pe.painting.FastPaintingSampler;
import com.adobe.pe.painting.NullPaintingSampler;
import com.adobe.pe.painting.PaintingSampler;
import com.adobe.util.ImageUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.InterruptedIOException;

public abstract class Painting {
    private Rectangle bounds;
    private boolean opaque;
    private boolean fast;
    public Image paintImage;
    public boolean paintImageComplete;
    public Rectangle paintImageBounds;
    public Rectangle paintImageClip;
    private PaintingSampler sampler;
    Thread drawThread;

    public Painting(Rectangle rectangle) {
        this(rectangle, false, true);
    }

    public Painting(Rectangle rectangle, boolean bl, boolean bl2) {
        this.bounds = rectangle;
        this.opaque = bl;
        this.fast = bl2;
        this.paintImage = null;
        this.sampler = null;
        this.paintImageComplete = false;
    }

    public PaintingSampler acquireSampler(Rectangle rectangle) {
        return this.acquireSampler(rectangle, true);
    }

    public synchronized PaintingSampler acquireSampler(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2;
        Rectangle rectangle3 = this.getBounds();
        if (rectangle3 == null || !rectangle.intersects(rectangle3)) {
            return NullPaintingSampler.getNullPaintingSampler();
        }
        rectangle = rectangle.intersection(rectangle3);
        if (this.fast) {
            return new FastPaintingSampler(this, rectangle);
        }
        if (this.paintImageBounds != null && this.paintImageBounds.intersection(rectangle).equals(rectangle)) {
            this.sampler = new CachePaintingSampler(this, rectangle, bl);
            return this.sampler;
        }
        if (this.paintImageBounds != null && !this.paintImageBounds.intersects(rectangle) && this.paintImageBounds.width >= rectangle.width && this.paintImageBounds.height >= rectangle.height) {
            int n = (this.paintImageBounds.width - rectangle.width) / 2;
            int n2 = rectangle.x - n;
            if (n2 < rectangle3.x) {
                n2 = rectangle3.x;
            } else if (n2 + this.paintImageBounds.width > rectangle3.x + rectangle3.width) {
                n2 = rectangle3.x + rectangle3.width - this.paintImageBounds.width;
            }
            int n3 = (this.paintImageBounds.height - rectangle.height) / 2;
            int n4 = rectangle.y - n3;
            if (n4 < rectangle3.y) {
                n4 = rectangle3.y;
            } else if (n4 + this.paintImageBounds.height > rectangle3.y + rectangle3.height) {
                n4 = rectangle3.y + rectangle3.height - this.paintImageBounds.height;
            }
            this.paintImageBounds.x = n2;
            this.paintImageBounds.y = n4;
            this.paintImageClip = this.paintImageBounds;
            this.killSampler();
            this.sampler = new CachePaintingSampler(this, rectangle, bl);
            return this.sampler;
        }
        if (this.paintImageComplete && rectangle.width <= this.paintImageBounds.width && rectangle.y >= this.paintImageBounds.y && rectangle.y + rectangle.height <= this.paintImageBounds.y + this.paintImageBounds.height) {
            int n = (this.paintImageBounds.width - rectangle.width) / 2;
            int n5 = rectangle.x - n;
            if (n5 < rectangle3.x) {
                n5 = rectangle3.x;
            } else if (n5 + this.paintImageBounds.width > rectangle3.x + rectangle3.width) {
                n5 = rectangle3.x + rectangle3.width - this.paintImageBounds.width;
            }
            int n6 = this.paintImageBounds.x - n5;
            Graphics graphics = this.paintImage.getGraphics();
            if (n6 > 0) {
                graphics.copyArea(0, 0, this.paintImageBounds.width - n6, this.paintImageBounds.height, n6, 0);
                this.paintImageBounds.x = n5;
                this.paintImageClip = new Rectangle(this.paintImageBounds.x, this.paintImageBounds.y, n6, this.paintImageBounds.height);
            } else {
                graphics.copyArea(-n6, 0, this.paintImageBounds.width + n6, this.paintImageBounds.height, n6, 0);
                this.paintImageBounds.x = n5;
                this.paintImageClip = new Rectangle(this.paintImageBounds.x + this.paintImageBounds.width + n6, this.paintImageBounds.y, -n6, this.paintImageBounds.height);
            }
            graphics.dispose();
            this.killSampler();
            this.sampler = new CachePaintingSampler(this, rectangle, bl);
            return this.sampler;
        }
        if (this.paintImageComplete && rectangle.height <= this.paintImageBounds.height && rectangle.x >= this.paintImageBounds.x && rectangle.x + rectangle.width <= this.paintImageBounds.x + this.paintImageBounds.width) {
            int n = (this.paintImageBounds.height - rectangle.height) / 2;
            int n7 = rectangle.y - n;
            if (n7 < rectangle3.y) {
                n7 = rectangle3.y;
            } else if (n7 + this.paintImageBounds.height > rectangle3.y + rectangle3.height) {
                n7 = rectangle3.y + rectangle3.height - this.paintImageBounds.height;
            }
            int n8 = this.paintImageBounds.y - n7;
            Graphics graphics = this.paintImage.getGraphics();
            if (n8 > 0) {
                graphics.copyArea(0, 0, this.paintImageBounds.width, this.paintImageBounds.height - n8, 0, n8);
                this.paintImageBounds.y = n7;
                this.paintImageClip = new Rectangle(this.paintImageBounds.x, this.paintImageBounds.y, this.paintImageBounds.width, n8);
            } else {
                graphics.copyArea(0, -n8, this.paintImageBounds.width, this.paintImageBounds.height + n8, 0, n8);
                this.paintImageBounds.y = n7;
                this.paintImageClip = new Rectangle(this.paintImageBounds.x, this.paintImageBounds.y + this.paintImageBounds.height + n8, this.paintImageBounds.width, -n8);
            }
            graphics.dispose();
            this.killSampler();
            this.sampler = new CachePaintingSampler(this, rectangle, bl);
            return this.sampler;
        }
        this.killSampler();
        this.paintImage = null;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(rectangle3.width, dimension.width * 1448 / 1024);
        int n9 = Math.min(rectangle3.height, dimension.height * 1448 / 1024);
        if (rectangle3.width <= n && rectangle3.height <= n9) {
            rectangle2 = rectangle3;
        } else {
            int n10;
            rectangle = new Rectangle(rectangle);
            if (rectangle.width < n) {
                n10 = n - rectangle.width;
                rectangle.x -= n10 / 2;
                if (rectangle.x < rectangle3.x) {
                    rectangle.x = rectangle3.x;
                }
                rectangle.width = n;
            }
            if (rectangle.height < n9) {
                n10 = n9 - rectangle.height;
                rectangle.y -= n10 / 2;
                if (rectangle.y < rectangle3.y) {
                    rectangle.y = rectangle3.y;
                }
                rectangle.height = n9;
            }
            rectangle2 = rectangle;
        }
        this.paintImage = Painting.getNewImage(rectangle2.width, rectangle2.height, this.opaque);
        this.paintImageBounds = rectangle2;
        this.paintImageClip = rectangle2;
        this.sampler = new CachePaintingSampler(this, rectangle, bl);
        return this.sampler;
    }

    public abstract void draw(Graphics var1) throws Exception;

    public final void draw(Graphics graphics, Point point) throws Exception {
        graphics.translate(point.x, point.y);
        try {
            this.draw(graphics);
        }
        finally {
            Object var4_3 = null;
            graphics.translate(-point.x, -point.y);
        }
    }

    public void finalize() throws Throwable {
        this.killSampler();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected static Image getNewImage(int n, int n2, boolean bl) {
        Image image = null;
        image = bl ? ImageUtil.createImage(n, n2) : GraphicsUtils.createImage(n, n2);
        return image;
    }

    public boolean isFast() {
        return this.fast;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    private void killSampler() {
        PaintingSampler paintingSampler = this.sampler;
        this.sampler = null;
        if (paintingSampler != null) {
            paintingSampler.stopDrawing();
        }
    }

    class CachePaintingSampler
    extends PaintingSampler
    implements Runnable {
        CachePaintingSampler(Painting painting2, Rectangle rectangle, boolean bl) {
            super(painting2, rectangle);
            if (bl && Painting.this.drawThread == null) {
                Graphics graphics = Painting.this.paintImage.getGraphics();
                Painting.this.paintImageComplete = false;
                Painting.this.drawThread = new Thread((Runnable)this, "CachePaintingSampler");
                Painting.this.drawThread.start();
                graphics.dispose();
            }
        }

        public void run() {
            Graphics graphics = Painting.this.paintImage.getGraphics();
            try {
                try {
                    graphics.translate(-Painting.this.paintImageBounds.x, -Painting.this.paintImageBounds.y);
                    graphics.setColor(Color.white);
                    graphics.fillRect(Painting.this.paintImageClip.x, Painting.this.paintImageClip.y, Painting.this.paintImageClip.width, Painting.this.paintImageClip.height);
                    graphics.setClip(Painting.this.paintImageClip);
                    Painting.this.draw(graphics);
                    Painting.this.paintImageComplete = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (Throwable throwable) {
                    this.setException(throwable);
                    Painting.this.paintImageComplete = true;
                }
                Object var3_3 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                graphics.dispose();
                throw throwable;
            }
        }

        public void stopDrawing() {
            Thread thread = Painting.this.drawThread;
            Painting.this.drawThread = null;
            while (thread != null && thread.isAlive()) {
                try {
                    thread.interrupt();
                    thread.join(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized boolean waitAndSample(Graphics graphics, boolean bl, long l) throws Throwable {
            Thread thread = Painting.this.drawThread;
            boolean bl2 = true;
            try {
                if (!Painting.this.paintImageComplete) {
                    long l2;
                    if (thread == null || !thread.isAlive()) {
                        thread = Painting.this.drawThread = new Thread((Runnable)this, "CachePaintingSampler");
                        Painting.this.drawThread.start();
                    }
                    if (thread != null && thread.isAlive() && l != 0L && (l2 = l - System.currentTimeMillis()) > 0L) {
                        thread.join(l2);
                    }
                    bl2 = Painting.this.paintImageComplete;
                }
                GraphicsUtils.drawToNative(graphics, Painting.this.paintImage, Painting.this.paintImageBounds.x, Painting.this.paintImageBounds.y);
            }
            catch (InterruptedException interruptedException) {}
            if (this.getException() != null) {
                throw this.getException();
            }
            return bl2;
        }
    }
}

