/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.Map;
import prefuse.action.assignment.ShapeAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.visual.VisualItem;

public class DataShapeAction
extends ShapeAction {
    protected static final int NO_SHAPE = Integer.MIN_VALUE;
    protected String m_dataField;
    protected int[] m_palette;
    protected Map m_ordinalMap;

    public DataShapeAction(String group, String field) {
        super(group, Integer.MIN_VALUE);
        this.m_dataField = field;
    }

    public DataShapeAction(String group, String field, int[] palette) {
        super(group, Integer.MIN_VALUE);
        this.m_dataField = field;
        this.m_palette = palette;
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String field) {
        this.m_dataField = field;
    }

    @Override
    public void setDefaultShape(int defaultShape) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setup() {
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        this.m_ordinalMap = DataLib.ordinalMap(ts, this.m_dataField);
    }

    @Override
    public int getShape(VisualItem item) {
        int shape = super.getShape(item);
        if (shape != Integer.MIN_VALUE) {
            return shape;
        }
        Object v = item.get(this.m_dataField);
        int idx = (Integer)this.m_ordinalMap.get(v);
        if (this.m_palette == null) {
            return idx % 10;
        }
        return this.m_palette[idx % this.m_palette.length];
    }
}

