/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.data.Table;
import prefuse.data.event.TableListener;
import prefuse.visual.VisualItem;

public class DragControl
extends ControlAdapter
implements TableListener {
    private VisualItem activeItem;
    protected String action;
    protected Point2D down = new Point2D.Double();
    protected Point2D temp = new Point2D.Double();
    protected boolean dragged;
    protected boolean wasFixed;
    protected boolean resetItem;
    private boolean fixOnMouseOver = true;
    protected boolean repaint = true;

    public DragControl() {
    }

    public DragControl(boolean repaint) {
        this.repaint = repaint;
    }

    public DragControl(boolean repaint, boolean fixOnMouseOver) {
        this.repaint = repaint;
        this.fixOnMouseOver = fixOnMouseOver;
    }

    public DragControl(String action) {
        this.repaint = false;
        this.action = action;
    }

    public DragControl(String action, boolean fixOnMouseOver) {
        this.repaint = false;
        this.fixOnMouseOver = fixOnMouseOver;
        this.action = action;
    }

    public void setFixPositionOnMouseOver(boolean s) {
        this.fixOnMouseOver = s;
    }

    @Override
    public void itemEntered(VisualItem item, MouseEvent e) {
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getPredefinedCursor(12));
        this.activeItem = item;
        if (this.fixOnMouseOver) {
            this.wasFixed = item.isFixed();
            this.resetItem = true;
            item.setFixed(true);
            item.getTable().addTableListener(this);
        }
    }

    @Override
    public void itemExited(VisualItem item, MouseEvent e) {
        if (this.activeItem == item) {
            this.activeItem = null;
            item.getTable().removeTableListener(this);
            if (this.resetItem) {
                item.setFixed(this.wasFixed);
            }
        }
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void itemPressed(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (!this.fixOnMouseOver) {
            this.wasFixed = item.isFixed();
            this.resetItem = true;
            item.setFixed(true);
            item.getTable().addTableListener(this);
        }
        this.dragged = false;
        Display d = (Display)e.getComponent();
        d.getAbsoluteCoordinate(e.getPoint(), this.down);
    }

    @Override
    public void itemReleased(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (this.dragged) {
            this.activeItem = null;
            item.getTable().removeTableListener(this);
            if (this.resetItem) {
                item.setFixed(this.wasFixed);
            }
            this.dragged = false;
        }
    }

    @Override
    public void itemDragged(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.dragged = true;
        Display d = (Display)e.getComponent();
        d.getAbsoluteCoordinate(e.getPoint(), this.temp);
        double dx = this.temp.getX() - this.down.getX();
        double dy = this.temp.getY() - this.down.getY();
        double x = item.getX();
        double y = item.getY();
        item.setStartX(x);
        item.setStartY(y);
        item.setX(x + dx);
        item.setY(y + dy);
        item.setEndX(x + dx);
        item.setEndY(y + dy);
        if (this.repaint) {
            item.getVisualization().repaint();
        }
        this.down.setLocation(this.temp);
        if (this.action != null) {
            d.getVisualization().run(this.action);
        }
    }

    @Override
    public void tableChanged(Table t, int start, int end, int col, int type) {
        if (this.activeItem == null || type != 0 || col != t.getColumnNumber(VisualItem.FIXED)) {
            return;
        }
        int row = this.activeItem.getRow();
        if (row >= start && row <= end) {
            this.resetItem = false;
        }
    }
}

