/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleManager;
import prefuse.visual.tuple.TableEdgeItem;

public class SpanningTree
extends Tree {
    public static final String SOURCE_EDGE = "source";
    protected static final Schema EDGE_SCHEMA = new Schema();
    protected Graph m_backing;

    static {
        EDGE_SCHEMA.addColumn(DEFAULT_SOURCE_KEY, Integer.TYPE, new Integer(-1));
        EDGE_SCHEMA.addColumn(DEFAULT_TARGET_KEY, Integer.TYPE, new Integer(-1));
        EDGE_SCHEMA.addColumn(SOURCE_EDGE, Integer.TYPE);
    }

    public SpanningTree(Graph g, Node root) {
        super(g.getNodeTable(), EDGE_SCHEMA.instantiate());
        this.m_backing = g;
        TupleManager etm = new TupleManager(this.getEdgeTable(), null, TableEdgeItem.class){

            @Override
            public Tuple getTuple(int row) {
                return SpanningTree.this.m_backing.getEdge(this.m_table.getInt(row, SpanningTree.SOURCE_EDGE));
            }
        };
        this.getEdgeTable().setTupleManager(etm);
        super.setTupleManagers(g.m_nodeTuples, etm);
        this.buildSpanningTree(root);
    }

    public void buildSpanningTree(Node root) {
        super.clearEdges();
        super.setRoot(root);
        LinkedList<Node> q = new LinkedList<Node>();
        BitSet visit = new BitSet();
        q.add(root);
        visit.set(root.getRow());
        Table edges = this.getEdgeTable();
        while (!q.isEmpty()) {
            Node p = (Node)q.removeFirst();
            Iterator iter = p.edges();
            while (iter.hasNext()) {
                Edge e = (Edge)iter.next();
                Node n = e.getAdjacentNode(p);
                if (visit.get(n.getRow())) continue;
                q.add(n);
                visit.set(n.getRow());
                int er = super.addChildEdge(p.getRow(), n.getRow());
                edges.setInt(er, SOURCE_EDGE, e.getRow());
            }
        }
    }

    @Override
    public int addChild(int parent) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public Node addChild(Node parent) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public int addChildEdge(int parent, int child) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public Edge addChildEdge(Node parent, Node child) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public Node addRoot() {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public int addRootRow() {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChild(int node) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChild(Node n) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChildEdge(Edge e) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChildEdge(int edge) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    void setRoot(Node root) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public int addEdge(int s, int t) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public Edge addEdge(Node s, Node t) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public Node addNode() {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public int addNodeRow() {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeEdge(Edge e) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeEdge(int edge) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeNode(int node) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeNode(Node n) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeTuple(Tuple t) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public void setEdgeTable(Table edges) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public void setTupleManagers(TupleManager ntm, TupleManager etm) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }
}

