/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.io.AbstractGraphReader;
import prefuse.data.io.DataIOException;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;

public class TreeMLReader
extends AbstractGraphReader {
    private ParserFactory m_pf = ParserFactory.getDefaultFactory();

    @Override
    public Graph readGraph(InputStream is) throws DataIOException {
        try {
            TreeMLHandler handler = new TreeMLHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
            return handler.getTree();
        }
        catch (Exception e) {
            throw new DataIOException(e);
        }
    }

    public static interface Tokens {
        public static final String TREE = "tree";
        public static final String BRANCH = "branch";
        public static final String LEAF = "leaf";
        public static final String ATTR = "attribute";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String TYPE = "type";
        public static final String DECLS = "declarations";
        public static final String DECL = "attributeDecl";
        public static final String INT = "Int";
        public static final String INTEGER = "Integer";
        public static final String LONG = "Long";
        public static final String FLOAT = "Float";
        public static final String REAL = "Real";
        public static final String STRING = "String";
        public static final String DATE = "Date";
        public static final String CATEGORY = "Category";
        public static final String BOOLEAN = "Boolean";
        public static final String DOUBLE = "Double";
    }

    public class TreeMLHandler
    extends DefaultHandler
    implements Tokens {
        private Table m_nodes = null;
        private Tree m_tree = null;
        private Node m_activeNode = null;
        private boolean m_inSchema = true;

        @Override
        public void startDocument() {
            this.m_tree = new Tree();
            this.m_nodes = this.m_tree.getNodeTable();
        }

        private void schemaCheck() {
            if (this.m_inSchema) {
                this.m_inSchema = false;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("branch") || qName.equals("leaf")) {
                this.m_activeNode = this.m_activeNode.getParent();
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (qName.equals("attributeDecl")) {
                if (!this.m_inSchema) {
                    throw new RuntimeException("All declarations must be done before nodes begin");
                }
                String name = atts.getValue("name");
                String type = atts.getValue("type");
                Class t = this.parseType(type);
                this.m_nodes.addColumn(name, t);
            } else if (qName.equals("branch") || qName.equals("leaf")) {
                this.schemaCheck();
                Node n = this.m_activeNode == null ? this.m_tree.addRoot() : this.m_tree.addChild(this.m_activeNode);
                this.m_activeNode = n;
            } else if (qName.equals("attribute")) {
                this.parseAttribute(atts);
            }
        }

        protected void parseAttribute(Attributes atts) {
            String name = null;
            String value = null;
            int i = 0;
            while (i < atts.getLength()) {
                String alName = atts.getQName(i);
                if (alName.equals("name")) {
                    name = atts.getValue(i);
                } else if (alName.equals("value")) {
                    value = atts.getValue(i);
                }
                ++i;
            }
            if (name == null || value == null) {
                System.err.println("Attribute under-specified");
                return;
            }
            try {
                Object val = this.parse(value, this.m_nodes.getColumnType(name));
                this.m_activeNode.set(name, val);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected Object parse(String s, Class type) throws DataParseException {
            DataParser dp = TreeMLReader.this.m_pf.getParser(type);
            return dp.parse(s);
        }

        protected Class parseType(String type) {
            if ((type = String.valueOf(Character.toUpperCase(type.charAt(0))) + type.substring(1).toLowerCase()).equals("Int") || type.equals("Integer")) {
                return Integer.TYPE;
            }
            if (type.equals("Long")) {
                return Long.TYPE;
            }
            if (type.equals("Float")) {
                return Float.TYPE;
            }
            if (type.equals("Double") || type.equals("Real")) {
                return Double.TYPE;
            }
            if (type.equals("Boolean")) {
                return Boolean.TYPE;
            }
            if (type.equals("String")) {
                return String.class;
            }
            if (type.equals("Date")) {
                return Date.class;
            }
            throw new RuntimeException("Unrecognized data type: " + type);
        }

        public Tree getTree() {
            return this.m_tree;
        }
    }
}

