/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultBoundedRangeModel;
import prefuse.util.ui.ValuedRangeModel;

public class ObjectRangeModel
extends DefaultBoundedRangeModel
implements ValuedRangeModel {
    private Object[] m_objects;
    private Map m_ordinal;

    public ObjectRangeModel(Object[] objects) {
        this.setValueRange(objects);
    }

    public void setValueRange(Object[] objects) {
        if (this.m_objects != null && objects.length == this.m_objects.length) {
            boolean equal = true;
            int i = 0;
            while (i < objects.length) {
                if (objects[i] != this.m_objects[i]) {
                    equal = false;
                    break;
                }
                ++i;
            }
            if (equal) {
                return;
            }
        }
        this.m_objects = new Object[objects.length];
        System.arraycopy(objects, 0, this.m_objects, 0, objects.length);
        if (this.m_ordinal == null) {
            this.m_ordinal = new HashMap();
        } else {
            this.m_ordinal.clear();
        }
        int i = 0;
        while (i < objects.length) {
            this.m_ordinal.put(objects[i], new Integer(i));
            ++i;
        }
        this.setRangeProperties(0, objects.length - 1, 0, objects.length - 1, false);
    }

    public Object getObject(int i) {
        return this.m_objects[i];
    }

    public int getIndex(Object o) {
        Integer idx = (Integer)this.m_ordinal.get(o);
        return idx == null ? -1 : idx;
    }

    @Override
    public Object getMinValue() {
        return this.m_objects[this.getMinimum()];
    }

    @Override
    public Object getMaxValue() {
        return this.m_objects[this.getMaximum()];
    }

    @Override
    public Object getLowValue() {
        return this.m_objects[this.getValue()];
    }

    @Override
    public Object getHighValue() {
        return this.m_objects[this.getValue() + this.getExtent()];
    }
}

