/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import prefuse.data.Tuple;

public class Trie {
    private TrieBranch root = new TrieBranch();
    private boolean caseSensitive = false;

    public Trie(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void addString(String word, Tuple t) {
        TrieLeaf leaf = new TrieLeaf(word, t);
        this.addLeaf(this.root, leaf, 0);
    }

    public void removeString(String word, Tuple t) {
        this.removeLeaf(this.root, word, t, 0);
    }

    private final int getIndex(char[] chars, char c) {
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final char getChar(String s, int i) {
        char c = i < 0 || i >= s.length() ? (char)'\u0000' : s.charAt(i);
        return this.caseSensitive ? c : Character.toLowerCase(c);
    }

    private final TrieNode equalityCheck(String word, TrieLeaf l) {
        if (this.caseSensitive) {
            return l.word.startsWith(word) ? l : null;
        }
        int len = word.length();
        if (len > l.word.length()) {
            return null;
        }
        int i = 0;
        while (i < len) {
            char c2;
            char c1 = Character.toLowerCase(word.charAt(i));
            if (c1 != (c2 = Character.toLowerCase(l.word.charAt(i)))) {
                return null;
            }
            ++i;
        }
        return l;
    }

    private boolean removeLeaf(TrieBranch b, String word, Tuple t, int depth) {
        char c = this.getChar(word, depth);
        int i = this.getIndex(b.chars, c);
        if (i == -1) {
            return false;
        }
        TrieNode n = b.children[i];
        if (n instanceof TrieBranch) {
            TrieBranch tb = (TrieBranch)n;
            boolean rem = this.removeLeaf(tb, word, t, depth + 1);
            if (rem) {
                b.leafCount = b.leafCount - 1;
                if (tb.leafCount == 1) {
                    b.children[i] = tb.children[tb.children[0] != null ? 0 : 1];
                }
            }
            return rem;
        }
        TrieLeaf nl = (TrieLeaf)n;
        if (nl.tuple == t) {
            b.children[i] = nl.next;
            if (nl.next == null) {
                this.repairBranch(b, i);
            }
            b.leafCount = b.leafCount - 1;
            return true;
        }
        TrieLeaf nnl = nl.next;
        while (nnl != null && nnl.tuple != t) {
            nl = nnl;
            nnl = nnl.next;
        }
        if (nnl == null) {
            return false;
        }
        TrieLeaf tl = (TrieLeaf)n;
        while (tl.tuple != t) {
            tl.leafCount = tl.leafCount - 1;
            tl = tl.next;
        }
        nl.next = nnl.next;
        b.leafCount = b.leafCount - 1;
        return true;
    }

    private void repairBranch(TrieBranch b, int i) {
        if (i == 0) {
            b.children[0] = null;
        } else {
            int len = b.chars.length;
            char[] nchars = new char[len - 1];
            TrieNode[] nkids = new TrieNode[len - 1];
            System.arraycopy(b.chars, 0, nchars, 0, i);
            System.arraycopy(b.children, 0, nkids, 0, i);
            System.arraycopy(b.chars, i + 1, nchars, i, len - i - 1);
            System.arraycopy(b.children, i + 1, nkids, i, len - i - 1);
            b.chars = nchars;
            b.children = nkids;
        }
    }

    private void addLeaf(TrieBranch b, TrieLeaf l, int depth) {
        b.leafCount += l.leafCount;
        char c = this.getChar(l.word, depth);
        int i = this.getIndex(b.chars, c);
        if (i == -1) {
            this.addChild(b, l, c);
        } else {
            TrieNode n = b.children[i];
            if (n == null) {
                b.children[i] = l;
            } else if (n instanceof TrieBranch) {
                this.addLeaf((TrieBranch)n, l, depth + 1);
            } else {
                TrieLeaf nl = (TrieLeaf)n;
                if (i == 0 || (this.caseSensitive ? nl.word.equals(l.word) : nl.word.equalsIgnoreCase(l.word))) {
                    while (nl.next != null) {
                        nl.leafCount = nl.leafCount + 1;
                        nl = nl.next;
                    }
                    nl.leafCount = nl.leafCount + 1;
                    nl.next = l;
                } else {
                    TrieBranch nb = new TrieBranch();
                    b.children[i] = nb;
                    this.addLeaf(nb, nl, depth + 1);
                    this.addLeaf(nb, l, depth + 1);
                }
            }
        }
    }

    private void addChild(TrieBranch b, TrieNode n, char c) {
        int len = b.chars.length;
        char[] nchars = new char[len + 1];
        TrieNode[] nkids = new TrieNode[len + 1];
        System.arraycopy(b.chars, 0, nchars, 0, len);
        System.arraycopy(b.children, 0, nkids, 0, len);
        nchars[len] = c;
        nkids[len] = n;
        b.chars = nchars;
        b.children = nkids;
    }

    public TrieNode find(String word) {
        return word.length() < 1 ? null : this.find(word, this.root, 0);
    }

    private TrieNode find(String word, TrieBranch b, int depth) {
        char c = this.getChar(word, depth);
        int i = this.getIndex(b.chars, c);
        if (i == -1) {
            return null;
        }
        if (word.length() - 1 == depth) {
            return b.children[i];
        }
        if (b.children[i] instanceof TrieLeaf) {
            return this.equalityCheck(word, (TrieLeaf)b.children[i]);
        }
        return this.find(word, (TrieBranch)b.children[i], depth + 1);
    }

    public class TrieBranch
    extends TrieNode {
        char[] chars;
        TrieNode[] children;

        public TrieBranch() {
            this.chars = new char[1];
            this.children = new TrieNode[1];
        }
    }

    public class TrieIterator
    implements Iterator {
        private LinkedList queue = new LinkedList();

        public TrieIterator(TrieNode node) {
            this.queue.add(node);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        public Object next() {
            if (this.queue.isEmpty()) {
                throw new NoSuchElementException();
            }
            TrieNode n = (TrieNode)this.queue.removeFirst();
            if (n instanceof TrieLeaf) {
                TrieLeaf l = (TrieLeaf)n;
                Tuple o = l.tuple;
                if (l.next != null) {
                    this.queue.addFirst(l.next);
                }
                return o;
            }
            TrieBranch b = (TrieBranch)n;
            int i = b.chars.length - 1;
            while (i > 0) {
                this.queue.addFirst(b.children[i]);
                --i;
            }
            if (b.children[0] != null) {
                this.queue.addFirst(b.children[0]);
            }
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class TrieLeaf
    extends TrieNode {
        String word;
        Tuple tuple;
        TrieLeaf next;

        public TrieLeaf(String word, Tuple t) {
            this.word = word;
            this.tuple = t;
            this.next = null;
            this.leafCount = 1;
        }
    }

    public class TrieNode {
        boolean isLeaf;
        int leafCount = 0;
    }
}

