/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import prefuse.data.Table;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIntTreeMap;
import prefuse.util.collections.IntIterator;

public class RowManager {
    protected Table m_table;
    private IntIntSortedMap m_openrows;
    private int m_firstid = 0;
    private int m_curid = -1;

    public RowManager(Table table) {
        this.m_table = table;
    }

    public Table getTable() {
        return this.m_table;
    }

    public int getMinimumRow() {
        return this.m_firstid;
    }

    public int getMaximumRow() {
        return this.m_curid;
    }

    public int getRowCount() {
        return 1 + this.m_curid - this.m_firstid - (this.m_openrows == null ? 0 : this.m_openrows.size());
    }

    public boolean isValidRow(int row) {
        return row >= this.m_firstid && row <= this.m_curid && (this.m_openrows == null || !this.m_openrows.containsKey(row));
    }

    public void clear() {
        this.m_openrows = null;
        this.m_firstid = 0;
        this.m_curid = -1;
    }

    public int addRow() {
        int r;
        if (this.m_openrows == null || this.m_openrows.isEmpty()) {
            r = this.m_firstid == 0 ? (this.m_curid = this.m_curid + 1) : (this.m_firstid = this.m_firstid - 1);
        } else {
            int key = this.m_openrows.firstKey();
            r = this.m_openrows.remove(key);
        }
        return r;
    }

    public boolean releaseRow(int row) {
        if (row < 0) {
            return false;
        }
        if (this.m_openrows != null && this.m_openrows.containsKey(row)) {
            return false;
        }
        if (row == this.m_curid) {
            --this.m_curid;
        } else if (row == this.m_firstid) {
            ++this.m_firstid;
        } else {
            if (this.m_openrows == null) {
                this.m_openrows = new IntIntTreeMap(false);
            }
            this.m_openrows.put(row, row);
        }
        return true;
    }

    public int getColumnRow(int row, int col) {
        return this.isValidRow(row) ? row : -1;
    }

    public int getTableRow(int columnRow, int col) {
        return this.isValidRow(columnRow) ? columnRow : -1;
    }

    public IntIterator columnRows(int col) {
        return new ColumnRowIterator(this.rows(), col);
    }

    public IntIterator columnRows(int col, boolean reverse) {
        return new ColumnRowIterator(this.rows(reverse), col);
    }

    public IntIterator columnRows(IntIterator rows, int col) {
        return new ColumnRowIterator(rows, col);
    }

    public IntIterator rows() {
        return new RowIterator(false);
    }

    public IntIterator rows(boolean reverse) {
        return new RowIterator(reverse);
    }

    static /* synthetic */ IntIntSortedMap access$2(RowManager rowManager) {
        return rowManager.m_openrows;
    }

    public class ColumnRowIterator
    extends IntIterator {
        private IntIterator rows;
        private int row;
        private int col;

        public ColumnRowIterator(IntIterator rows, int col) {
            this.rows = rows;
            this.col = col;
        }

        @Override
        public boolean hasNext() {
            return this.rows.hasNext();
        }

        @Override
        public int nextInt() {
            this.row = this.rows.nextInt();
            return RowManager.this.getColumnRow(this.row, this.col);
        }

        @Override
        public void remove() {
            RowManager.this.m_table.removeRow(this.row);
        }
    }

    public class RowIterator
    extends IntIterator {
        boolean reverse;
        int last = -1;
        int next;

        public RowIterator(boolean reverse) {
            this.reverse = reverse;
            this.next = this.advance(reverse ? RowManager.this.m_curid : RowManager.this.m_firstid);
        }

        @Override
        public boolean hasNext() {
            return this.reverse ? this.next >= 0 : this.next <= RowManager.this.m_curid;
        }

        @Override
        public int nextInt() {
            this.last = this.next;
            this.next = this.advance(this.reverse ? (this.next = this.next - 1) : (this.next = this.next + 1));
            return this.last;
        }

        @Override
        public void remove() {
            RowManager.this.m_table.removeRow(this.last);
        }

        /*
         * Unable to fully structure code
         */
        private final int advance(int idx) {
            block3: {
                if (RowManager.access$2(RowManager.this) == null) {
                    return idx;
                }
                if (!this.reverse) ** GOTO lbl9
                while (idx >= 0 && RowManager.access$2(RowManager.this).containsKey(idx)) {
                    --idx;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    ++idx;
lbl9:
                    // 2 sources

                    ** while (idx <= RowManager.access$0((RowManager)RowManager.this) && RowManager.access$2((RowManager)RowManager.this).containsKey((int)idx))
                }
            }
            return idx;
        }
    }
}

