/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import prefuse.util.collections.AbstractLiteralIterator;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LiteralComparator;

public abstract class AbstractTreeMap
implements IntSortedMap {
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected static final Entry NIL;
    protected LiteralComparator cmp = null;
    protected Entry root = NIL;
    protected boolean allowDuplicates;
    protected int size = 0;
    protected int unique = 0;
    protected int modCount = 0;
    protected int lastOrder = 0;

    static {
        AbstractTreeMap.NIL.right = AbstractTreeMap.NIL.p = (NIL = new Entry(Integer.MIN_VALUE));
        AbstractTreeMap.NIL.left = AbstractTreeMap.NIL.p;
    }

    public AbstractTreeMap(LiteralComparator comparator, boolean allowDuplicates) {
        this.cmp = comparator == null ? DefaultLiteralComparator.getInstance() : comparator;
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.root == NIL;
    }

    @Override
    public Comparator comparator() {
        return this.cmp;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public int getMinimum() {
        return this.minimum(this.root).getValue();
    }

    @Override
    public int getMaximum() {
        return this.maximum(this.root).getValue();
    }

    @Override
    public int getMedian() {
        Entry e = this.minimum(this.root);
        int i = 0;
        while (i < this.size / 2) {
            ++i;
            e = this.successor(e);
        }
        return e.getValue();
    }

    @Override
    public int getUniqueCount() {
        return this.unique;
    }

    @Override
    public boolean containsValue(int value) {
        return this.root == NIL ? false : this.containsValue(this.root, value);
    }

    private boolean containsValue(Entry e, int value) {
        if (e.val == value) {
            return true;
        }
        return e.left != NIL && this.containsValue(e.left, value) || e.right != NIL && this.containsValue(e.right, value);
    }

    @Override
    public IntIterator valueIterator(boolean ascend) {
        return new ValueIterator(new EntryIterator(!ascend));
    }

    protected void incrementSize(boolean isUnique) {
        ++this.size;
        ++this.modCount;
        if (isUnique) {
            ++this.unique;
        }
    }

    protected void decrementSize(boolean isUnique) {
        --this.size;
        ++this.modCount;
        if (isUnique) {
            --this.unique;
        }
    }

    protected abstract int compare(Entry var1, Entry var2);

    protected Entry find(Entry x) {
        Entry y = this.root;
        while (y != NIL) {
            int cmp = this.compare(x, y);
            if (cmp == 0) {
                return y;
            }
            y = cmp < 0 ? y.left : y.right;
        }
        return y;
    }

    protected Entry findPredecessor(Entry x) {
        Entry y = this.root;
        while (y != NIL) {
            int cmp = this.compare(x, y);
            if (cmp > 0) {
                if (y.right == NIL) {
                    return y;
                }
                y = y.right;
                continue;
            }
            if (y.left != NIL) {
                y = y.left;
                continue;
            }
            Entry up = y.p;
            Entry c = y;
            while (up != NIL && c == up.left) {
                c = up;
                up = up.p;
            }
            return up;
        }
        return y;
    }

    protected Entry findCeiling(Entry x) {
        Entry y = this.root;
        while (y != NIL) {
            int cmp = this.compare(x, y);
            if (cmp == 0) {
                return y;
            }
            if (cmp < 0) {
                if (y.left != NIL) {
                    y = y.left;
                    continue;
                }
                return y;
            }
            if (y.right != NIL) {
                y = y.right;
                continue;
            }
            Entry up = y.p;
            Entry c = y;
            while (up != NIL && c == up.right) {
                c = up;
                up = up.p;
            }
            return up;
        }
        return y;
    }

    protected Entry minimum(Entry x) {
        while (x.left != NIL) {
            x = x.left;
        }
        return x;
    }

    protected Entry maximum(Entry x) {
        while (x.right != NIL) {
            x = x.right;
        }
        return x;
    }

    protected Entry successor(Entry x) {
        if (x.right != NIL) {
            return this.minimum(x.right);
        }
        Entry y = x.p;
        while (y != NIL && x == y.right) {
            x = y;
            y = y.p;
        }
        return y;
    }

    protected Entry predecessor(Entry x) {
        if (x.left != NIL) {
            return this.maximum(x.left);
        }
        Entry y = x.p;
        while (y != NIL && x == y.left) {
            x = y;
            y = y.p;
        }
        return y;
    }

    protected void rotateLeft(Entry x) {
        Entry y = x.right;
        x.right = y.left;
        if (y.left != NIL) {
            y.left.p = x;
        }
        y.p = x.p;
        if (x.p == NIL) {
            this.root = y;
        } else if (x.p.left == x) {
            x.p.left = y;
        } else {
            x.p.right = y;
        }
        y.left = x;
        x.p = y;
    }

    protected void rotateRight(Entry x) {
        Entry y = x.left;
        x.left = y.right;
        if (y.right != NIL) {
            y.right.p = x;
        }
        y.p = x.p;
        if (x.p == NIL) {
            this.root = y;
        } else if (x.p.right == x) {
            x.p.right = y;
        } else {
            x.p.left = y;
        }
        y.right = x;
        x.p = y;
    }

    protected void fixUpInsert(Entry x) {
        x.color = false;
        while (x != NIL && x != this.root && !x.p.color) {
            Entry y;
            if (x.p == x.p.p.left) {
                y = x.p.p.right;
                if (!y.color) {
                    x.p.color = true;
                    y.color = true;
                    x.p.p.color = false;
                    x = x.p.p;
                    continue;
                }
                if (x == x.p.right) {
                    x = x.p;
                    this.rotateLeft(x);
                }
                x.p.color = true;
                x.p.p.color = false;
                if (x.p.p == NIL) continue;
                this.rotateRight(x.p.p);
                continue;
            }
            y = x.p.p.left;
            if (!y.color) {
                x.p.color = true;
                y.color = true;
                x.p.p.color = false;
                x = x.p.p;
                continue;
            }
            if (x == x.p.left) {
                x = x.p;
                this.rotateRight(x);
            }
            x.p.color = true;
            x.p.p.color = false;
            if (x.p.p == NIL) continue;
            this.rotateLeft(x.p.p);
        }
        this.root.color = true;
    }

    protected void fixUpRemove(Entry x) {
        while (x != this.root && x.color) {
            Entry sib;
            if (x == x.p.left) {
                sib = x.p.right;
                if (!sib.color) {
                    sib.color = true;
                    x.p.color = false;
                    this.rotateLeft(x.p);
                    sib = x.p.right;
                }
                if (sib.left.color && sib.right.color) {
                    sib.color = false;
                    x = x.p;
                    continue;
                }
                if (sib.right.color) {
                    sib.left.color = true;
                    sib.color = false;
                    this.rotateRight(sib);
                    sib = x.p.right;
                }
                sib.color = x.p.color;
                x.p.color = true;
                sib.right.color = true;
                this.rotateLeft(x.p);
                x = this.root;
                continue;
            }
            sib = x.p.left;
            if (!sib.color) {
                sib.color = true;
                x.p.color = false;
                this.rotateRight(x.p);
                sib = x.p.left;
            }
            if (sib.right.color && sib.left.color) {
                sib.color = false;
                x = x.p;
                continue;
            }
            if (sib.left.color) {
                sib.right.color = true;
                sib.color = false;
                this.rotateLeft(sib);
                sib = x.p.left;
            }
            sib.color = x.p.color;
            x.p.color = true;
            sib.left.color = true;
            this.rotateRight(x.p);
            x = this.root;
        }
        x.color = true;
    }

    protected void remove(Entry z) {
        boolean isUnique = !z.keyEquals(z.left) && !z.keyEquals(z.right) && !z.keyEquals(z.p);
        Entry y = z.left != NIL && z.right != NIL ? this.successor(z) : z;
        Entry x = y.left != NIL ? y.left : y.right;
        x.p = y.p;
        if (y.p == NIL) {
            this.root = x;
        } else if (y == y.p.left) {
            y.p.left = x;
        } else {
            y.p.right = x;
        }
        if (y != z) {
            z.copyFields(y);
        }
        if (y.color) {
            this.fixUpRemove(x);
        }
        this.decrementSize(isUnique);
    }

    public static class Entry {
        int val;
        int order;
        Entry left = null;
        Entry right = null;
        Entry p;
        boolean color = true;

        public Entry(int val) {
            this.val = val;
        }

        public Entry(int val, Entry parent, int order) {
            this.val = val;
            this.p = parent;
            this.order = order;
            this.left = NIL;
            this.right = NIL;
        }

        public int getIntKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public long getLongKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public float getFloatKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public double getDoubleKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public Object getKey() {
            return null;
        }

        public int getValue() {
            return this.val;
        }

        public int getOrder() {
            return this.order;
        }

        public int setValue(int value) {
            int old = this.val;
            this.val = value;
            return old;
        }

        public boolean keyEquals(Entry e) {
            Object k = this.getKey();
            return k == null ? k == e.getKey() : k.equals(e.getKey());
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.val == e.val && this.getKey() == e.getKey();
        }

        public int hashCode() {
            int khash = this.getKey().hashCode();
            int vhash = this.val;
            return khash ^ vhash;
        }

        public String toString() {
            return this.getKey() + "=" + this.val;
        }

        public void copyFields(Entry x) {
            this.val = x.val;
            this.order = x.order;
        }
    }

    protected class EntryIterator
    extends AbstractLiteralIterator {
        private int expectedModCount;
        private Entry lastReturned;
        private boolean reverse;
        Entry next;
        Entry end;

        EntryIterator(boolean reverse) {
            this.expectedModCount = AbstractTreeMap.this.modCount;
            this.lastReturned = NIL;
            this.reverse = false;
            this.next = reverse ? AbstractTreeMap.this.maximum(AbstractTreeMap.this.root) : AbstractTreeMap.this.minimum(AbstractTreeMap.this.root);
            this.end = NIL;
        }

        EntryIterator(Entry first, Entry last) {
            this.expectedModCount = AbstractTreeMap.this.modCount;
            this.lastReturned = NIL;
            this.reverse = false;
            this.next = first;
            this.end = last;
            this.reverse = first == NIL ? true : (last == NIL ? false : AbstractTreeMap.this.compare(first, last) > 0);
        }

        @Override
        public boolean hasNext() {
            return this.next != this.end;
        }

        final Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (AbstractTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            Entry entry = this.next = this.reverse ? AbstractTreeMap.this.predecessor(this.next) : AbstractTreeMap.this.successor(this.next);
            if (this.lastReturned == NIL) {
                System.err.println("Encountered NIL in iteration!");
            }
            return this.lastReturned;
        }

        public Object next() {
            return this.nextEntry();
        }

        @Override
        public void remove() {
            if (this.lastReturned == NIL) {
                throw new IllegalStateException();
            }
            if (AbstractTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != NIL && this.lastReturned.right != NIL) {
                this.next = this.lastReturned;
            }
            AbstractTreeMap.this.remove(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = NIL;
        }
    }

    protected class KeyIterator
    extends EntryIterator {
        public KeyIterator() {
            super(false);
        }

        public KeyIterator(Entry start, Entry end) {
            super(start, end);
        }

        @Override
        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    protected class ValueIterator
    extends IntIterator {
        EntryIterator m_iter;

        public ValueIterator(EntryIterator iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public int nextInt() {
            return this.m_iter.nextEntry().val;
        }

        @Override
        public void remove() {
            this.m_iter.remove();
        }
    }
}

