/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.DoubleIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;

public class DoubleIntTreeMap
extends AbstractTreeMap
implements DoubleIntSortedMap {
    private DoubleEntry dummy = new DoubleEntry(Double.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public DoubleIntTreeMap() {
        this(null, false);
    }

    public DoubleIntTreeMap(boolean allowDuplicates) {
        this(null, allowDuplicates);
    }

    public DoubleIntTreeMap(LiteralComparator comparator) {
        this(comparator, false);
    }

    public DoubleIntTreeMap(LiteralComparator comparator, boolean allowDuplicates) {
        super(comparator, allowDuplicates);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public boolean containsKey(double key) {
        return this.find(key, 0) != NIL;
    }

    @Override
    public int get(double key) {
        AbstractTreeMap.Entry ret = this.find(key, 0);
        return ret == NIL ? Integer.MIN_VALUE : ret.val;
    }

    @Override
    public int put(double key, int value) {
        AbstractTreeMap.Entry t = this.root;
        this.lastOrder = 0;
        if (t == NIL) {
            this.incrementSize(true);
            this.root = new DoubleEntry(key, value, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = key;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int cmp;
            if ((cmp = this.compare(this.dummy, t)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != NIL) {
                    t = t.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                t.left = new DoubleEntry(key, value, t, this.lastOrder);
                this.fixUpInsert(t.left);
                return Integer.MIN_VALUE;
            }
            if (t.right == NIL) break;
            t = t.right;
        }
        this.incrementSize(this.lastOrder == 0);
        t.right = new DoubleEntry(key, value, t, this.lastOrder);
        this.fixUpInsert(t.right);
        return Integer.MIN_VALUE;
    }

    @Override
    public int remove(double key) {
        AbstractTreeMap.Entry x = this.allowDuplicates ? this.findPredecessor(key, Integer.MAX_VALUE) : this.find(key, 0);
        if (x == NIL) {
            return Integer.MIN_VALUE;
        }
        int val = x.val;
        this.remove(x);
        return val;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int remove(double key, int val) {
        x = this.findCeiling(key, 0);
        if (x != DoubleIntTreeMap.NIL && x.getDoubleKey() != key) {
            x = this.successor(x);
        }
        if (x != DoubleIntTreeMap.NIL && x.getDoubleKey() == key) ** GOTO lbl7
        return -2147483648;
lbl-1000:
        // 1 sources

        {
            x = this.successor(x);
lbl7:
            // 2 sources

            ** while (x.val != val && x != DoubleIntTreeMap.NIL)
        }
lbl8:
        // 1 sources

        if (x == DoubleIntTreeMap.NIL) {
            return -2147483648;
        }
        this.remove(x);
        return val;
    }

    @Override
    public double firstKey() {
        return this.minimum(this.root).getDoubleKey();
    }

    @Override
    public double lastKey() {
        return this.maximum(this.root).getDoubleKey();
    }

    @Override
    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    @Override
    public LiteralIterator keyRangeIterator(double fromKey, boolean fromInc, double toKey, boolean toInc) {
        AbstractTreeMap.Entry end;
        AbstractTreeMap.Entry start;
        if (this.cmp.compare(fromKey, toKey) <= 0) {
            start = this.findCeiling(fromKey, fromInc ? 0 : Integer.MAX_VALUE);
            end = this.findCeiling(toKey, toInc ? Integer.MAX_VALUE : 0);
        } else {
            start = this.findCeiling(fromKey, fromInc ? Integer.MAX_VALUE : 0);
            start = this.predecessor(start);
            end = this.findCeiling(toKey, toInc ? 0 : Integer.MAX_VALUE);
            end = this.predecessor(end);
        }
        return new KeyIterator(start, end);
    }

    @Override
    public IntIterator valueRangeIterator(double fromKey, boolean fromInc, double toKey, boolean toInc) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(fromKey, fromInc, toKey, toInc));
    }

    @Override
    protected int compare(AbstractTreeMap.Entry e1, AbstractTreeMap.Entry e2) {
        int c = this.cmp.compare(e1.getDoubleKey(), e2.getDoubleKey());
        if (this.allowDuplicates && c == 0) {
            c = e1.order < e2.order ? -1 : (e1.order > e2.order ? 1 : 0);
            this.lastOrder = 1 + (c < 0 ? e1.order : e2.order);
        }
        return c;
    }

    private AbstractTreeMap.Entry find(double key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.find(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findPredecessor(double key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findPredecessor(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findCeiling(double key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findCeiling(this.dummy);
        return e;
    }

    static class DoubleEntry
    extends AbstractTreeMap.Entry {
        double key;

        public DoubleEntry(double key, int val) {
            super(val);
            this.key = key;
        }

        public DoubleEntry(double key, int val, AbstractTreeMap.Entry parent, int order) {
            super(val, parent, order);
            this.key = key;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public Object getKey() {
            return new Double(this.key);
        }

        @Override
        public boolean keyEquals(AbstractTreeMap.Entry e) {
            return e instanceof DoubleEntry && this.key == ((DoubleEntry)e).key;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DoubleEntry)) {
                return false;
            }
            DoubleEntry e = (DoubleEntry)o;
            return this.key == e.key && this.val == e.val;
        }

        @Override
        public int hashCode() {
            long k = Double.doubleToLongBits(this.key);
            int khash = (int)(k ^ k >>> 32);
            int vhash = this.val;
            return khash ^ vhash ^ this.order;
        }

        @Override
        public String toString() {
            return String.valueOf(this.key) + "=" + this.val;
        }

        @Override
        public void copyFields(AbstractTreeMap.Entry x) {
            super.copyFields(x);
            this.key = x.getDoubleKey();
        }
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry start, AbstractTreeMap.Entry end) {
            super(start, end);
        }

        @Override
        public boolean isDoubleSupported() {
            return true;
        }

        @Override
        public double nextDouble() {
            return this.nextEntry().getDoubleKey();
        }
    }
}

