/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import prefuse.util.collections.AbstractHashMap;

public class IntObjectHashMap
extends AbstractHashMap
implements Cloneable {
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected int[] table;
    protected Object[] values;
    protected byte[] state;
    protected int freeEntries;

    public IntObjectHashMap() {
        this(277);
    }

    public IntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public IntObjectHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.values, null);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        try {
            IntObjectHashMap copy = (IntObjectHashMap)super.clone();
            copy.table = (int[])copy.table.clone();
            copy.values = (Object[])copy.values.clone();
            copy.state = (byte[])copy.state.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean containsKey(int key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public Object get(int key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(int key) {
        int[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && tab[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 2) {
            int j = i;
            while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (stat[i] == 0) {
                i = j;
            }
        }
        if (stat[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(int key) {
        int[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(Object value) {
        Object[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int keyOf(Object value) {
        int i = this.indexOfValue(value);
        if (i < 0) {
            return Integer.MIN_VALUE;
        }
        return this.table[i];
    }

    public int keys(int[] list) {
        int[] tab = this.table;
        byte[] stat = this.state;
        if (list.length < this.distinct) {
            return -1;
        }
        int j = 0;
        int i = tab.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            list[j++] = tab[i];
        }
        return this.distinct;
    }

    public boolean put(int key, Object value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        int[] oldTable = this.table;
        Object[] oldValues = this.values;
        byte[] oldState = this.state;
        int[] newTable = new int[newCapacity];
        Object[] newValues = new Object[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            int element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newValues[index] = oldValues[i];
            newState[index] = 1;
        }
    }

    public boolean removeKey(int key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        this.values[i] = null;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new int[capacity];
        this.values = new Object[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public void values(ArrayList list) {
        Object[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            list.add(val[i]);
        }
    }
}

