/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import prefuse.Display;
import prefuse.util.display.Clip;
import prefuse.util.display.PaintListener;
import prefuse.util.io.IOLib;

public class BackgroundPainter
implements PaintListener {
    private static final double THRESH = 0.01;
    private Image m_img;
    private boolean m_fixed;
    private boolean m_tiled;
    private AffineTransform m_identity;
    private Clip m_clip;

    public BackgroundPainter(String imageLocation, boolean fixed, boolean tile) {
        this(Toolkit.getDefaultToolkit().getImage(IOLib.urlFromString(imageLocation)), fixed, tile);
    }

    public BackgroundPainter(Image image, boolean fixed, boolean tile) {
        this.m_img = image;
        MediaTracker mt = new MediaTracker(new Container());
        mt.addImage(this.m_img, 0);
        try {
            mt.waitForID(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mt.removeImage(this.m_img, 0);
        this.m_fixed = fixed;
        this.m_tiled = tile;
    }

    @Override
    public void prePaint(Display d, Graphics2D g) {
        AffineTransform at = g.getTransform();
        boolean translate = BackgroundPainter.isTranslation(at);
        if (this.m_fixed || translate) {
            int tx = this.m_fixed ? 0 : (int)at.getTranslateX();
            int ty = this.m_fixed ? 0 : (int)at.getTranslateY();
            g.setTransform(this.getIdentity());
            if (this.m_tiled) {
                int sy;
                int w = d.getWidth();
                int iw = this.m_img.getWidth(null);
                int h = d.getHeight();
                int ih = this.m_img.getHeight(null);
                int sx = this.m_fixed ? 0 : tx % iw;
                int n = sy = this.m_fixed ? 0 : ty % ih;
                if (sx > 0) {
                    sx -= iw;
                }
                if (sy > 0) {
                    sy -= ih;
                }
                int x = sx;
                while (x < w - sx) {
                    int y = sy;
                    while (y < h - sy) {
                        g.drawImage(this.m_img, x, y, null);
                        y += ih;
                    }
                    x += iw;
                }
            } else {
                g.drawImage(this.m_img, tx, ty, null);
            }
            g.setTransform(at);
        } else if (this.m_tiled) {
            int iw = this.m_img.getWidth(null);
            int ih = this.m_img.getHeight(null);
            Clip c = this.getClip();
            c.setClip(0.0, 0.0, d.getWidth(), d.getHeight());
            c.transform(d.getInverseTransform());
            int w = (int)Math.ceil(c.getWidth());
            int h = (int)Math.ceil(c.getHeight());
            int tx = (int)c.getMinX();
            int ty = (int)c.getMinY();
            int dw = tx % iw + iw;
            int dh = ty % ih + ih;
            w += dw;
            ty -= dh;
            h += dh;
            int x = tx -= dw;
            while (x < tx + w) {
                int y = ty;
                while (y < ty + h) {
                    g.drawImage(this.m_img, x, y, null);
                    y += ih;
                }
                x += iw;
            }
        } else {
            g.drawImage(this.m_img, 0, 0, null);
        }
    }

    private static boolean isTranslation(AffineTransform at) {
        return Math.abs(at.getScaleX() - 1.0) < 0.01 && Math.abs(at.getScaleY() - 1.0) < 0.01 && Math.abs(at.getShearX()) < 0.01 && Math.abs(at.getShearY()) < 0.01;
    }

    private AffineTransform getIdentity() {
        if (this.m_identity == null) {
            this.m_identity = new AffineTransform();
        }
        return this.m_identity;
    }

    private Clip getClip() {
        if (this.m_clip == null) {
            this.m_clip = new Clip();
        }
        return this.m_clip;
    }

    @Override
    public void postPaint(Display d, Graphics2D g) {
    }
}

