/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prefuse.util.ui.UILib;

public class JToggleGroup
extends JPanel {
    public static final int CHECKBOX = 0;
    public static final int RADIO = 1;
    protected final int m_type;
    protected int m_margin = 0;
    protected int m_spacing = 0;
    protected int m_axis = 0;
    protected ListModel m_data;
    protected ListSelectionModel m_sel;
    protected String[] m_labels;
    protected ButtonGroup m_group;
    private Listener m_lstnr;

    public JToggleGroup(int type, Object[] data) {
        this(type, new DefaultListModel(), new DefaultListSelectionModel());
        DefaultListModel model = (DefaultListModel)this.m_data;
        int i = 0;
        while (i < data.length) {
            model.addElement(data[i]);
            ++i;
        }
        this.initUI();
    }

    public JToggleGroup(int type, ListModel data) {
        this(type, data, new DefaultListSelectionModel());
    }

    public JToggleGroup(int type, ListModel data, ListSelectionModel selection) {
        this.setLayout(new BoxLayout(this, this.m_axis));
        this.m_type = type;
        this.m_data = data;
        this.m_sel = selection;
        if (this.m_type == 1) {
            this.m_group = new ButtonGroup();
        }
        this.m_lstnr = new Listener();
        this.m_sel.addListSelectionListener(this.m_lstnr);
        if (this.m_data.getSize() > 0) {
            this.initUI();
        }
        this.setFocusable(false);
    }

    protected void initUI() {
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof JToggleButton) {
                JToggleButton tb = (JToggleButton)c;
                tb.removeActionListener(this.m_lstnr);
                if (this.m_group != null) {
                    this.m_group.remove(tb);
                }
            }
            ++i;
        }
        this.removeAll();
        UILib.addStrut((JComponent)this, this.m_axis, this.m_margin);
        i = 0;
        while (i < this.m_data.getSize()) {
            if (i > 0) {
                UILib.addStrut((JComponent)this, this.m_axis, this.m_spacing);
            }
            Object data = this.m_data.getElementAt(i);
            String label = this.m_labels == null ? data.toString() : this.m_labels[i];
            JToggleButton tb = null;
            if (this.m_type == 0) {
                tb = new JCheckBox(label);
            } else {
                tb = new JRadioButton(label);
                this.m_group.add(tb);
            }
            tb.putClientProperty("idx", new Integer(i));
            tb.addActionListener(this.m_lstnr);
            this.add(tb);
            ++i;
        }
        UILib.addStrut((JComponent)this, this.m_axis, this.m_margin);
        this.m_lstnr.valueChanged(null);
    }

    public void setAxisType(int axis) {
        this.setLayout(new BoxLayout(this, axis));
        this.m_axis = axis;
        this.initUI();
    }

    public int getAxisType() {
        return this.m_axis;
    }

    public void setMargin(int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("Margin is less than zero.");
        }
        this.m_margin = margin;
        this.initUI();
    }

    public int getMargin() {
        return this.m_margin;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("Spacing is less than zero.");
        }
        this.m_spacing = spacing;
        this.initUI();
    }

    public int getSpacing() {
        return this.m_spacing;
    }

    public void setModel(ListModel model) {
        this.m_data = model;
        this.initUI();
    }

    public ListModel getModel() {
        return this.m_data;
    }

    public void setSelectionModel(ListSelectionModel sel) {
        this.m_sel.removeListSelectionListener(this.m_lstnr);
        this.m_sel = sel;
        this.m_sel.addListSelectionListener(this.m_lstnr);
        this.m_lstnr.valueChanged(null);
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_sel;
    }

    public void setLabels(String[] labels) {
        if (labels.length < this.m_data.getSize()) {
            throw new IllegalArgumentException("Alias array is too short");
        }
        this.m_labels = labels;
        this.initUI();
    }

    @Override
    public void setBackground(Color background) {
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setBackground(background);
            ++i;
        }
    }

    @Override
    public void setForeground(Color foreground) {
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setForeground(foreground);
            ++i;
        }
    }

    @Override
    public void setFont(Font font) {
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setFont(font);
            ++i;
        }
    }

    public void setGroupFocusable(boolean b) {
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof JToggleButton) {
                c.setFocusable(b);
            }
            ++i;
        }
    }

    private class Listener
    implements ListSelectionListener,
    ActionListener {
        private boolean m_ignore = false;

        private Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent neverUsed) {
            if (this.m_ignore) {
                return;
            }
            this.m_ignore = true;
            if (JToggleGroup.this.m_type == 1) {
                int idx = JToggleGroup.this.m_sel.getMinSelectionIndex();
                boolean sel = idx >= 0;
                AbstractButton tb = null;
                int i = 0;
                int j = 0;
                while (i < JToggleGroup.this.getComponentCount()) {
                    Component c = JToggleGroup.this.getComponent(i);
                    if (c instanceof JToggleButton) {
                        tb = (JToggleButton)c;
                        if (!sel && tb.isSelected() || sel && idx == j) break;
                        ++j;
                    }
                    ++i;
                }
                tb.setSelected(sel);
            } else {
                int i = 0;
                int j = 0;
                while (i < JToggleGroup.this.getComponentCount()) {
                    Component c = JToggleGroup.this.getComponent(i);
                    if (c instanceof JCheckBox) {
                        ((JCheckBox)c).setSelected(JToggleGroup.this.m_sel.isSelectedIndex(j++));
                    }
                    ++i;
                }
            }
            this.m_ignore = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_ignore) {
                return;
            }
            this.m_ignore = true;
            JToggleButton tb = (JToggleButton)e.getSource();
            boolean sel = tb.isSelected();
            int idx = (Integer)tb.getClientProperty("idx");
            if (JToggleGroup.this.m_type == 1) {
                JToggleGroup.this.m_sel.setSelectionInterval(idx, idx);
            } else if (sel) {
                JToggleGroup.this.m_sel.addSelectionInterval(idx, idx);
            } else {
                JToggleGroup.this.m_sel.removeSelectionInterval(idx, idx);
            }
            this.m_ignore = false;
        }
    }
}

