/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual;

import prefuse.Visualization;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.util.collections.IntIterator;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.VisualTupleSet;

public class VisualTree
extends Tree
implements VisualTupleSet {
    private Visualization m_vis;
    private String m_group;

    public VisualTree(VisualTable nodes, VisualTable edges, String nodeKey, String sourceKey, String targetKey) {
        super((Table)nodes, (Table)edges, nodeKey, sourceKey, targetKey);
    }

    @Override
    protected void fireGraphEvent(Table t, int first, int last, int col, int type) {
        if (type == 0 && col == VisualItem.IDX_VALIDATED && t == this.getNodeTable()) {
            VisualTable nodes = (VisualTable)t;
            VisualTable edges = (VisualTable)this.getEdgeTable();
            int i = first;
            while (i <= last) {
                if (!nodes.isValidated(i)) {
                    IntIterator erows = this.edgeRows(i);
                    while (erows.hasNext()) {
                        int erow = erows.nextInt();
                        edges.setValidated(erow, false);
                    }
                }
                ++i;
            }
        }
        super.fireGraphEvent(t, first, last, col, type);
    }

    @Override
    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization vis) {
        this.m_vis = vis;
    }

    @Override
    public String getGroup() {
        return this.m_group;
    }

    public void setGroup(String group) {
        this.m_group = group;
    }
}

