/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.GroupExpression;

public class InGroupPredicate
extends GroupExpression
implements Predicate {
    public InGroupPredicate() {
    }

    public InGroupPredicate(String group) {
        super(group);
    }

    @Override
    public Object get(Tuple t) {
        return this.getBoolean(t) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean getBoolean(Tuple t) {
        if (!(t instanceof VisualItem)) {
            return false;
        }
        String group = this.getGroup(t);
        if (group == null) {
            return false;
        }
        VisualItem item = (VisualItem)t;
        return item.getVisualization().isInGroup(item, group);
    }

    @Override
    public String getName() {
        return "INGROUP";
    }

    @Override
    public Class getType(Schema s) {
        return Boolean.TYPE;
    }
}

