/*
 * Decompiled with CFR 0.152.
 */
package com.zehon;

import com.zehon.BatchTransferProgress;
import com.zehon.exception.FileTransferException;
import com.zehon.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;

public abstract class FileTransferClient {
    private static final Log log;

    public abstract String getServerName();

    public abstract void setServerName(String var1);

    public abstract String getUsername();

    public abstract void setUsername(String var1);

    public abstract String getPassword();

    public abstract void setPassword(String var1);

    public abstract int getPort();

    public abstract void setPort(int var1);

    protected abstract String getProtocol();

    protected abstract FileSystemOptions getFileSystemOptions() throws FileSystemException;

    protected boolean validate() {
        try {
            Class<?> vfsDependency = Class.forName("org.apache.commons.vfs.VFS");
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"++++++++++++PLEASE MAKE SURE HAVE ALL THE DEPENDENCY JARS IN THE CLASSPATH ++++++");
            return false;
        }
        if (this.getServerName() == null || this.getUsername() == null || this.getPassword() == null) {
            log.warn((Object)"++++++++++++PLEASE SET THE servername, username and password, if they're null set them to empty string++++++");
            return false;
        }
        return true;
    }

    protected int sendFile(String localFilePath, String filetransferDestFolder) throws FileTransferException {
        return this.sendFile(localFilePath, filetransferDestFolder, null, false);
    }

    protected int sendFileOriginal(String localFilePath, String filetransferDestFolder) throws FileTransferException {
        return this.sendFile(localFilePath, filetransferDestFolder, null, true);
    }

    public int sendFile(String localFilePath, String ftpDestFolder, String nameOfFileToStore) throws FileTransferException {
        return this.sendFile(localFilePath, ftpDestFolder, nameOfFileToStore, false);
    }

    public int sendFile(byte[] fileContent, String ftpDestFolder, String nameOfFileToStore) throws FileTransferException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileContent);
        return this.sendFile(byteArrayInputStream, nameOfFileToStore, ftpDestFolder);
    }

    public int sendFile(File file, String ftpDestFolder) throws FileTransferException {
        return this.sendFile(file.getAbsolutePath(), ftpDestFolder, file.getName());
    }

    public int sendFile(File file, String ftpDestFolder, String nameOfFileToStore) throws FileTransferException {
        return this.sendFile(file.getAbsolutePath(), ftpDestFolder, nameOfFileToStore);
    }

    public int sendFiles(String fromFolder, final String filePatternRegex, String ftpDestFolder) throws FileTransferException {
        File file = new File(fromFolder);
        if (!file.exists()) {
            throw new FileTransferException(fromFolder + " does not exist!");
        }
        if (!file.isDirectory()) {
            throw new FileTransferException(fromFolder + " is not a directory");
        }
        File[] listFiles = file.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(filePatternRegex);
            }
        });
        for (int i = 0; i < listFiles.length; ++i) {
            int sendFile = this.sendFile(listFiles[i], ftpDestFolder);
            if (sendFile != 0) continue;
            return 0;
        }
        return 1;
    }

    protected int sendFile(String localFilePath, String filetransferDestFolder, String nameOfFileToStore, boolean retainLastUpdate) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        BufferedInputStream is = null;
        try {
            int status;
            File localFile = new File(localFilePath);
            if (!localFile.exists()) {
                throw new FileTransferException(localFilePath + " does not exist!");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading file from " + localFilePath));
            }
            is = new BufferedInputStream(new FileInputStream(localFile));
            if (nameOfFileToStore == null) {
                nameOfFileToStore = FileUtils.getFileName(localFilePath);
            }
            Long lastModified = null;
            if (retainLastUpdate) {
                lastModified = new Long(localFile.lastModified());
            }
            int n = status = this.sendFileStreamHelper(is, nameOfFileToStore, filetransferDestFolder, lastModified);
            return n;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected int sendFile(InputStream inputStream, String nameOfFileToStore, String filetransferDestFolder) throws FileTransferException {
        return this.sendFileStreamHelper(inputStream, nameOfFileToStore, filetransferDestFolder, null);
    }

    private int sendFileStreamHelper(InputStream inputStream, String nameOfFileToStore, String filetransferDestFolder, Long modifiedTime) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        BufferedOutputStream os = null;
        FileObject fo = null;
        try {
            fo = this.getFileObject(nameOfFileToStore, filetransferDestFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            fo.createFile();
            os = new BufferedOutputStream(fo.getContent().getOutputStream());
            FileUtils.readStream(inputStream, os);
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (modifiedTime != null) {
                try {
                    fo.getContent().setLastModifiedTime(modifiedTime.longValue());
                }
                catch (FileSystemException fse) {
                    throw new FileTransferException("Could not set the last modified time to the sent file, your server might not support this feature!");
                }
            }
            int fse = 1;
            return fse;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {}
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected InputStream getFileAsStream(String remoteFileName, String filetransferFolder) throws FileTransferException {
        if (!this.validate()) {
            return null;
        }
        FileObject fo = null;
        try {
            fo = this.getFileObject(remoteFileName, filetransferFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            FileContent content = fo.getContent();
            InputStream inputStream = content.getInputStream();
            return inputStream;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
    }

    protected int getFile(String remoteFileName, String filetransferFolder, String toLocalFolder) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        try {
            InputStream is = this.getFileAsStream(remoteFileName, filetransferFolder);
            this.writeToFile(is, toLocalFolder, remoteFileName);
            return 1;
        }
        catch (Throwable ex) {
            throw new FileTransferException(ex);
        }
    }

    protected void writeToFile(InputStream inputStream, String toLocalFolder, String remoteFileName) throws Exception {
        OutputStream os = null;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(inputStream);
            String filePath = FileUtils.getFilePath(toLocalFolder, remoteFileName, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Writing to " + filePath));
            }
            os = new BufferedOutputStream(new FileOutputStream(filePath));
            FileUtils.readStream(is, os);
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int deleteFile(String nameOfFileToDelete, String filetransferFolder) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        FileObject fo = null;
        try {
            boolean delete;
            fo = this.getFileObject(nameOfFileToDelete, filetransferFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (!fo.exists()) {
                int n = 3;
                return n;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer(50).append("Deleting file: ").append(fo.getURL().toString()).toString());
            }
            if (delete = fo.delete()) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected int createFolder(String nameOfFolderToCreate, String filetransferFolder) throws FileTransferException {
        int n;
        if (!this.validate()) {
            return 2;
        }
        FileObject fo = null;
        try {
            fo = this.getFileObject(nameOfFolderToCreate, filetransferFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (fo.exists()) {
                int n2 = 1;
                return n2;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer(50).append("Creating a folder: ").append(fo.getURL().toString()).toString());
            }
            fo.createFolder();
            n = 1;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {}
            }
        }
        return n;
    }

    protected boolean folderExists(String folderPath) throws FileTransferException {
        return this.resourceExist(folderPath, FileType.FOLDER);
    }

    protected boolean fileExists(String folderPath, String fileName) throws FileTransferException {
        String filePath = FileUtils.getFilePath(folderPath, fileName, false);
        return this.resourceExist(filePath, FileType.FILE);
    }

    private boolean resourceExist(String folderPath, FileType resourceType) throws FileTransferException {
        if (!this.validate()) {
            throw new FileTransferException("Invalid Setting, username or password or servername is missing!");
        }
        FileObject fo = null;
        try {
            fo = this.getFileObject("", folderPath, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            boolean bl = fo.exists() && fo.getType() == resourceType;
            return bl;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected int moveFile(String nameOfFileToMove, String filetransferFromFolder, String newNameOfFile, String filetransferToFolder) throws FileTransferException {
        int n;
        if (!this.validate()) {
            return 2;
        }
        FileObject fromFo = null;
        FileObject toFo = null;
        try {
            fromFo = this.getFileObject(nameOfFileToMove, filetransferFromFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (!fromFo.exists()) {
                int n2 = 3;
                return n2;
            }
            toFo = this.getFileObject(newNameOfFile, filetransferToFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer(50).append("Moving file from ").append(fromFo.getURL().toString()).append(" to ").append(toFo.getURL().toString()).toString());
            }
            fromFo.moveTo(toFo);
            n = 1;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (fromFo != null) {
                try {
                    fromFo.close();
                }
                catch (IOException e) {}
            }
            if (toFo != null) {
                try {
                    toFo.close();
                }
                catch (IOException e) {}
            }
        }
        return n;
    }

    protected int copyFile(String sourceFilePath, String destFilePath) throws FileTransferException {
        int n;
        if (!this.validate()) {
            return 2;
        }
        FileObject fromFo = null;
        FileObject toFo = null;
        try {
            fromFo = this.getFileObject("", sourceFilePath, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (!fromFo.exists()) {
                int n2 = 3;
                return n2;
            }
            toFo = this.getFileObject("", destFilePath, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer(50).append("Copying file(s) from ").append(fromFo.getURL().toString()).append(" to ").append(toFo.getURL().toString()).toString());
            }
            toFo.copyFrom(fromFo, (FileSelector)new AllFileSelector());
            n = 1;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (fromFo != null) {
                try {
                    fromFo.close();
                }
                catch (IOException e) {}
            }
            if (toFo != null) {
                try {
                    toFo.close();
                }
                catch (IOException e) {}
            }
        }
        return n;
    }

    private FileObject getFileObject(String nameOfFile, String filetransferDestFolder, String hostname, String username, String password, int port) throws FileSystemException {
        FileSystemOptions fsOptions = this.getFileSystemOptions();
        DefaultFileSystemManager fsManager = (DefaultFileSystemManager)VFS.getManager();
        String separator = "";
        if (!filetransferDestFolder.endsWith("/")) {
            separator = "/";
        }
        String remoteFolderPath = filetransferDestFolder + separator + nameOfFile;
        String completePath = this.getUploadPathForFile(hostname, username, password, port, remoteFolderPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving to full filetransfer path : " + completePath));
        }
        FileObject fo = fsManager.resolveFile(completePath, fsOptions);
        return fo;
    }

    private String getUploadPathForFile(String hostname, String username, String password, int port, String fileName) {
        String filetransferPath = this.getFileTransferPath(hostname, username, password, port);
        if (!fileName.startsWith("/")) {
            filetransferPath = filetransferPath + "/";
        }
        return filetransferPath + fileName;
    }

    protected String getFileTransferPath(String hostname, String username, String password, int port) {
        try {
            username = URLEncoder.encode(username, "UTF-8");
            password = URLEncoder.encode(password, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid user name/password!");
        }
        StringBuffer buff = new StringBuffer(50).append(this.getProtocol()).append("://").append(username).append(":").append(password).append("@").append(hostname).append(":").append(port);
        return buff.toString();
    }

    protected int getFolder(String filetransferFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean justFolderContent, boolean recursive) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        File file = new File(toLocalFolder);
        if (!file.exists()) {
            throw new FileTransferException(toLocalFolder + " does not exist!");
        }
        if (!file.isDirectory()) {
            throw new FileTransferException(toLocalFolder + " is not a directory");
        }
        try {
            String nameOfFolderToCreate;
            File newFolder;
            boolean mkdir;
            if (!justFolderContent && !(mkdir = (newFolder = new File(toLocalFolder = FileUtils.getFilePath(toLocalFolder, nameOfFolderToCreate = FileUtils.getFileName(filetransferFolder), true))).mkdir())) {
                throw new FileTransferException(toLocalFolder + " can not be created!");
            }
            this.getFolderHelper(filetransferFolder, toLocalFolder, batchTransferProgress, recursive);
            return 1;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
    }

    private void getFolderHelper(String filetransferFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws IOException, Exception {
        FileObject fo = this.getFileObject("", filetransferFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
        FileObject[] listFiles = fo.getChildren();
        for (int i = 0; i < listFiles.length; ++i) {
            FileObject fileObject = listFiles[i];
            String fileObjectName = fileObject.getName().getBaseName();
            String fullFTPPath = FileUtils.getFilePath(filetransferFolder, fileObjectName, false);
            if (fileObject.getType() == FileType.FOLDER) {
                String subToLocalFolder = FileUtils.getFilePath(toLocalFolder, fileObjectName, true);
                File subDir = new File(subToLocalFolder);
                subDir.mkdir();
                if (!recursive) continue;
                this.getFolderHelper(fullFTPPath, subToLocalFolder, batchTransferProgress, recursive);
                continue;
            }
            this.getFolderFile(fileObject, toLocalFolder, batchTransferProgress);
        }
    }

    private void getFolderFile(FileObject fileObject, String toLocalFolder, BatchTransferProgress batchTransferProgress) throws IOException {
        String filePath;
        block4: {
            filePath = fileObject.getName().getPath();
            if (batchTransferProgress != null) {
                batchTransferProgress.transferStart(filePath);
            }
            try {
                InputStream retrieveFileStream = fileObject.getContent().getInputStream();
                this.writeToFile(retrieveFileStream, toLocalFolder, fileObject.getName().getBaseName());
            }
            catch (Throwable ex) {
                log.error((Object)ex, ex);
                if (batchTransferProgress == null) break block4;
                batchTransferProgress.transferError(filePath, ex);
            }
        }
        if (batchTransferProgress != null) {
            batchTransferProgress.transferComplete(filePath);
        }
    }

    protected String[] getFileNamesInFolder(String filetransferFolder) throws FileTransferException {
        try {
            FileObject fo = this.getFileObject("", filetransferFolder, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            FileObject[] children = fo.getChildren();
            String[] fileNames = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                FileObject fileObject = children[i];
                fileNames[i] = fileObject.getName().getBaseName();
            }
            return fileNames;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
    }

    private void sendFolderHelper(File fileObj, String filetransferFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException, IOException {
        if (fileObj.isDirectory()) {
            File[] listFiles = fileObj.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                File file = listFiles[i];
                if (file.isDirectory()) {
                    this.createFolder(file.getName(), filetransferFolder);
                    String subFiletransferFolder = filetransferFolder + "/" + file.getName();
                    if (!recursive) continue;
                    this.sendFolderHelper(file, subFiletransferFolder, batchTransferProgress, recursive);
                    continue;
                }
                this.sendFolderFile(file, filetransferFolder, batchTransferProgress);
            }
        } else {
            this.sendFolderFile(fileObj, filetransferFolder, batchTransferProgress);
        }
    }

    protected int sendFolder(String sendingFolder, String filetransferFolder, BatchTransferProgress batchTransferProgress, boolean justFolderContent, boolean recursive) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        File directory = new File(sendingFolder);
        if (!directory.exists()) {
            throw new FileTransferException(sendingFolder + " does not exist!");
        }
        if (!directory.isDirectory()) {
            throw new FileTransferException(sendingFolder + " is not a directory");
        }
        try {
            if (!justFolderContent) {
                String nameOfFolderToCreate = FileUtils.getFileName(sendingFolder);
                this.createFolder(nameOfFolderToCreate, filetransferFolder);
                filetransferFolder = FileUtils.getFilePath(filetransferFolder, nameOfFolderToCreate, false);
            }
            this.sendFolderHelper(directory, filetransferFolder, batchTransferProgress, recursive);
            return 1;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
    }

    private void sendFolderFile(File fileObj, String filetransferFolder, BatchTransferProgress batchTransferProgress) throws IOException {
        String filePath;
        block4: {
            filePath = fileObj.getCanonicalPath();
            if (batchTransferProgress != null) {
                batchTransferProgress.transferStart(filePath);
            }
            try {
                this.sendFile(filePath, filetransferFolder);
            }
            catch (Throwable ex) {
                log.error((Object)ex, ex);
                if (batchTransferProgress == null) break block4;
                batchTransferProgress.transferError(filePath, ex);
            }
        }
        if (batchTransferProgress != null) {
            batchTransferProgress.transferComplete(filePath);
        }
    }

    protected long getLastModificationTime(String filePath) throws FileTransferException {
        if (!this.validate()) {
            throw new FileTransferException("Invalid Setting, username or password or servername is missing!");
        }
        FileObject fo = null;
        try {
            fo = this.getFileObject("", filePath, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (!fo.exists()) {
                throw new FileTransferException(filePath + " does not exist");
            }
            long l = fo.getContent().getLastModifiedTime();
            return l;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected Date getLastModificationTimeDate(String filePath) throws FileTransferException {
        long lastModificationTime = this.getLastModificationTime(filePath);
        return new Date(lastModificationTime);
    }

    protected void setLastModificationTime(String filePath, long modificationTime) throws FileTransferException {
        if (!this.validate()) {
            throw new FileTransferException("Invalid Setting, username or password or servername is missing!");
        }
        FileObject fo = null;
        try {
            fo = this.getFileObject("", filePath, this.getServerName(), this.getUsername(), this.getPassword(), this.getPort());
            if (!fo.exists()) {
                throw new FileTransferException(filePath + " does not exist");
            }
            try {
                fo.getContent().setLastModifiedTime(modificationTime);
            }
            catch (FileSystemException fse) {
                throw new FileTransferException("Could not set the last modified time to " + filePath + ", your server might not support this feature!");
            }
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void setLastModificationTimeDate(String filePath, Date modificationDate) throws FileTransferException {
        this.setLastModificationTime(filePath, modificationDate.getTime());
    }

    public static void closeCache() throws FileTransferException {
        try {
            ((DefaultFileSystemManager)VFS.getManager()).close();
        }
        catch (FileSystemException e) {
            throw new FileTransferException((Exception)((Object)e));
        }
    }

    static {
        System.out.println("Thank you for using Zehon software (www.zehon.com).  \nPlease go to http://www.zehon.com/feedback.php to provide us your feedback about the product.\nPlease go to http://www.zehon.com/feature_request.php to submit bugs or feature requests.");
        log = LogFactory.getLog(FileTransferClient.class);
    }
}

