/*
 * Decompiled with CFR 0.152.
 */
package com.zehon.sftp;

import com.zehon.BatchTransferProgress;
import com.zehon.FileTransferClient;
import com.zehon.exception.FileTransferException;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;

public class SFTPClient
extends FileTransferClient {
    private String serverName;
    private String username;
    private String password;
    private int port = 22;
    private String privateKeyPath;
    private boolean usePrivateKey;
    private static final Log log = LogFactory.getLog(SFTPClient.class);

    public SFTPClient() {
    }

    public SFTPClient(String serverName, String username, String password) {
        this.setServerName(serverName);
        this.setUsername(username);
        this.setPassword(password);
    }

    public SFTPClient(String serverName, int port, String username, String password) {
        this.setServerName(serverName);
        this.setPort(port);
        this.setUsername(username);
        this.setPassword(password);
    }

    public SFTPClient(String serverName, String username, String privateKeyPath, boolean usePrivateKey) {
        this.setServerName(serverName);
        this.setUsername(username);
        this.setPrivateKeyPath(privateKeyPath);
        this.setUsePrivateKey(usePrivateKey);
    }

    public SFTPClient(String serverName, int port, String username, String privateKeyPath, boolean usePrivateKey) {
        this.setServerName(serverName);
        this.setPort(port);
        this.setUsername(username);
        this.setPrivateKeyPath(privateKeyPath);
        this.setUsePrivateKey(usePrivateKey);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public boolean isUsePrivateKey() {
        return this.usePrivateKey;
    }

    public void setUsePrivateKey(boolean usePrivateKey) {
        this.usePrivateKey = usePrivateKey;
    }

    protected boolean validate() {
        if (this.isUsePrivateKey() && (this.getPrivateKeyPath() == null || this.getPrivateKeyPath().trim().length() == 0)) {
            log.warn((Object)"++++++++++++PLEASE SET THE private key path ++++++");
            return false;
        }
        if (this.getServerName() == null || this.getUsername() == null) {
            log.warn((Object)"++++++++++++PLEASE SET THE servername, username and password, if they're null set them to empty string++++++");
            return false;
        }
        return true;
    }

    public int sendFile(String localFilePath, String sftpDestFolder) throws FileTransferException {
        return super.sendFile(localFilePath, sftpDestFolder);
    }

    public int sendFileOriginal(String localFilePath, String filetransferDestFolder) throws FileTransferException {
        return this.sendFile(localFilePath, filetransferDestFolder, null, true);
    }

    public int sendFileOriginal(String localFilePath, String filetransferDestFolder, String nameOfFileToStore) throws FileTransferException {
        return this.sendFile(localFilePath, filetransferDestFolder, nameOfFileToStore, true);
    }

    public int sendFile(InputStream inputStream, String nameOfFileToStore, String sftpDestFolder) throws FileTransferException {
        return super.sendFile(inputStream, nameOfFileToStore, sftpDestFolder);
    }

    public InputStream getFileAsStream(String remoteFileName, String sftpFolder) throws FileTransferException {
        return super.getFileAsStream(remoteFileName, sftpFolder);
    }

    public int getFile(String remoteFileName, String sftpFolder, String toLocalFolder) throws FileTransferException {
        return super.getFile(remoteFileName, sftpFolder, toLocalFolder);
    }

    protected String getFileTransferPath(String hostname, String username, String password, int port) {
        if (this.isUsePrivateKey()) {
            try {
                username = URLEncoder.encode(username, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Invalid user name/password!");
            }
            StringBuffer buff = new StringBuffer(50).append(this.getProtocol()).append("://").append(username).append("@").append(hostname);
            return buff.toString();
        }
        return super.getFileTransferPath(hostname, username, password, port);
    }

    public int deleteFile(String nameOfFileToDelete, String sftpFolder) throws FileTransferException {
        return super.deleteFile(nameOfFileToDelete, sftpFolder);
    }

    public int createFolder(String nameOfFolderToCreate, String sftpFolder) throws FileTransferException {
        return super.createFolder(nameOfFolderToCreate, sftpFolder);
    }

    public int moveFile(String nameOfFileToMove, String sftpFromFolder, String newNameOfFile, String sftpToFolder) throws FileTransferException {
        return super.moveFile(nameOfFileToMove, sftpFromFolder, newNameOfFile, sftpToFolder);
    }

    public int copyFile(String sourceFilePath, String destFilePath) throws FileTransferException {
        return super.copyFile(sourceFilePath, destFilePath);
    }

    public int getFolder(String sftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.getFolder(sftpFolder, toLocalFolder, batchTransferProgress, true, true);
    }

    public int getFolder(String sftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.getFolder(sftpFolder, toLocalFolder, batchTransferProgress, true, recursive);
    }

    public int getFolderCreate(String sftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.getFolder(sftpFolder, toLocalFolder, batchTransferProgress, false, true);
    }

    public int getFolderCreate(String sftpFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.getFolder(sftpFolder, toLocalFolder, batchTransferProgress, false, recursive);
    }

    public String[] getFileNamesInFolder(String sftpFolder) throws FileTransferException {
        return super.getFileNamesInFolder(sftpFolder);
    }

    public int sendFolder(String sendingFolder, String sftpFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.sendFolder(sendingFolder, sftpFolder, batchTransferProgress, true, true);
    }

    public int sendFolder(String sendingFolder, String sftpFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.sendFolder(sendingFolder, sftpFolder, batchTransferProgress, true, recursive);
    }

    public int sendFolderCreate(String sendingFolder, String sftpFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return super.sendFolder(sendingFolder, sftpFolder, batchTransferProgress, false, true);
    }

    public int sendFolderCreate(String sendingFolder, String sftpFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return super.sendFolder(sendingFolder, sftpFolder, batchTransferProgress, false, recursive);
    }

    public boolean folderExists(String sftpFolder) throws FileTransferException {
        return super.folderExists(sftpFolder);
    }

    public boolean fileExists(String sftpFolder, String nameOfFile) throws FileTransferException {
        return super.fileExists(sftpFolder, nameOfFile);
    }

    public long getLastModificationTime(String filePath) throws FileTransferException {
        return super.getLastModificationTime(filePath);
    }

    public Date getLastModificationTimeDate(String filePath) throws FileTransferException {
        return super.getLastModificationTimeDate(filePath);
    }

    public void setLastModificationTime(String filePath, long modificationTime) throws FileTransferException {
        super.setLastModificationTime(filePath, modificationTime);
    }

    public void setLastModificationTimeDate(String filePath, Date modificationDate) throws FileTransferException {
        super.setLastModificationTimeDate(filePath, modificationDate);
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions fsOptions = new FileSystemOptions();
        SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(fsOptions, "no");
        if (this.isUsePrivateKey()) {
            File[] identities = new File[1];
            File file = new File(this.getPrivateKeyPath());
            if (!file.exists()) {
                throw new FileSystemException(file.getAbsolutePath() + " does not exist");
            }
            identities[0] = file;
            SftpFileSystemConfigBuilder.getInstance().setIdentities(fsOptions, identities);
        }
        return fsOptions;
    }

    protected String getProtocol() {
        return "sftp";
    }
}

