/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import org.apache.commons.vfs.util.Cryptor;
import org.apache.commons.vfs.util.DefaultCryptor;

public final class CryptorFactory {
    public static final String CRYPTOR_CLASS = "org.apache.commons.vfs.cryptor";
    private static Cryptor instance;

    private CryptorFactory() {
    }

    public static synchronized void setCryptor(Cryptor cryptor) {
        instance = cryptor;
    }

    public static synchronized Cryptor getCryptor() {
        if (instance != null) {
            return instance;
        }
        String cryptorClass = System.getProperty(CRYPTOR_CLASS);
        if (cryptorClass != null) {
            try {
                Class<?> clazz = Class.forName(cryptorClass);
                instance = (Cryptor)clazz.newInstance();
                return instance;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create Cryptor " + cryptorClass, ex);
            }
        }
        instance = new DefaultCryptor();
        return instance;
    }
}

