/*
 * Decompiled with CFR 0.152.
 */
package backup;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

class ImageScalingPanel
extends JPanel {
    BufferedImage image;
    double scale;
    double zoomInc;

    public ImageScalingPanel() {
        this.loadImage();
        this.scale = 1.0;
        this.zoomInc = 0.01;
        this.setBackground(Color.white);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int w = this.getWidth();
        int h = this.getHeight();
        double imageWidth = this.scale * (double)this.image.getWidth();
        double imageHeight = this.scale * (double)this.image.getHeight();
        double x = ((double)w - imageWidth) / 2.0;
        double y = ((double)h - imageHeight) / 2.0;
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        at.scale(this.scale, this.scale);
        g2.drawRenderedImage(this.image, at);
    }

    public void setScale(int direction) {
        this.scale += (double)direction * this.zoomInc;
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        int w = (int)(this.scale * (double)this.image.getWidth());
        int h = (int)(this.scale * (double)this.image.getHeight());
        return new Dimension(w, h);
    }

    private void loadImage() {
        String fileName = "D:\\javaworkspace\\RNAProject\\images\\software_header.gif";
        try {
            File file = new File(fileName);
            this.image = ImageIO.read(file);
        }
        catch (MalformedURLException mue) {
            System.out.println("url: " + mue.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("read: " + ioe.getMessage());
        }
    }
}

